/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Manifest;

public class Version2 {
    private static final String BUILD_INFORMATION_FILE = "/META-INF/MANIFEST.MF";
    private static final int majorVersion;
    private static final int minorVersion;
    private static final int serviceVersion;
    private static final int serviceSubVersion;
    private static final Date buildDate;
    private static final int buildNumber;

    public static void main(String[] args) {
        System.out.println("IBM Informix JDBC Driver");
        System.out.println("Build-Version: " + majorVersion + '.' + minorVersion + '.' + serviceVersion + '.' + serviceSubVersion);
        System.out.println("Build-Number: " + buildNumber);
        System.out.println("Build-Date: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(buildDate));
    }

    public static int getMajorVerision() {
        return majorVersion;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    public static int getServiceVersion() {
        return serviceVersion;
    }

    public static int getServiceSubVersion() {
        return serviceSubVersion;
    }

    public static int getBuildNumber() {
        return buildNumber;
    }

    public static String getLegacyVersionString() {
        String toReturn = "" + majorVersion + '.' + minorVersion + ".JC" + serviceVersion;
        if (serviceSubVersion > 0) {
            toReturn = toReturn + "W" + serviceSubVersion;
        }
        return toReturn;
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        int major = 12;
        int minor = 10;
        int service = 8;
        int subservice = 0;
        int build = 0;
        Date date = null;
        try {
            Enumeration<URL> resources = Version2.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                String[] versionSplit;
                Manifest m = new Manifest(resources.nextElement().openStream());
                if (m.getMainAttributes().getValue("Implementation-Title") == null || !m.getMainAttributes().getValue("Implementation-Title").equals("Informix JDBC Driver")) continue;
                String version = m.getMainAttributes().getValue("Implementation-Version");
                if (version.indexOf("-") > 0) {
                    version = version.substring(0, version.indexOf("-"));
                }
                if ((versionSplit = version.split("\\.")).length != 3 && versionSplit.length != 4) {
                    throw new RuntimeException("Incorrect number of properties for utm.version in file:  /META-INF/MANIFEST.MF");
                }
                major = Integer.parseInt(versionSplit[0]);
                minor = Integer.parseInt(versionSplit[1]);
                service = Integer.parseInt(versionSplit[2]);
                if (versionSplit.length == 4) {
                    subservice = Integer.parseInt(versionSplit[3]);
                }
                date = dateFormat.parse(m.getMainAttributes().getValue("Build-Date"));
                String buildString = m.getMainAttributes().getValue("Build-Number");
                build = Integer.parseInt(buildString);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        majorVersion = major;
        minorVersion = minor;
        serviceVersion = service;
        buildDate = date;
        buildNumber = build;
        serviceSubVersion = subservice;
    }
}

