/*
 * Decompiled with CFR 0.152.
 */
package com.informix.json;

import com.informix.bson.DBRefBase;
import com.informix.json.AbstractObjectSerializer;
import com.informix.json.Base64Codec;
import com.informix.json.Bytes;
import com.informix.json.ClassMapBasedObjectSerializer;
import com.informix.json.ObjectSerializer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JSONSerializer
implements ObjectSerializer {
    protected final ClassMapBasedObjectSerializer serializer;
    protected final Configuration configuration;

    public static void main(String[] args) {
        System.out.println(new Builder().build().serialize(new BasicBSONObject("a\\", (Object)1)));
        System.out.println(new Builder().escapeJavaEscapeSequences(false).build().serialize(new BasicBSONObject("a\\", (Object)1)));
    }

    protected JSONSerializer(ClassMapBasedObjectSerializer serializer, Configuration configuration) {
        this.serializer = serializer;
        this.configuration = configuration;
    }

    @Override
    public void serialize(Object obj, StringBuilder buf) {
        this.serializer.serialize(obj, buf);
    }

    @Override
    public String serialize(Object obj) {
        return this.serializer.serialize(obj);
    }

    static class ByteArraySerializer
    extends BinarySerializerBase {
        ByteArraySerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serialize((byte[])obj, (byte)0, buf);
        }
    }

    static class BinarySerializer
    extends BinarySerializerBase {
        BinarySerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Binary bin = (Binary)obj;
            this.serialize(bin.getData(), bin.getType(), buf);
        }
    }

    static abstract class BinarySerializerBase
    extends CompoundObjectSerializer {
        BinarySerializerBase(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        protected void serialize(byte[] bytes, byte type, StringBuilder buf) {
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$binary", (Object)new Base64Codec().encode(bytes));
            temp.put("$type", (Object)type);
            this.serializer.serialize(temp, buf);
        }
    }

    static class DateSerializer
    extends CompoundObjectSerializer {
        DateSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Date d = (Date)obj;
            this.serializer.serialize(new BasicBSONObject("$date", (Object)d.getTime()), buf);
        }
    }

    static class BSONTimestampSerializer
    extends CompoundObjectSerializer {
        BSONTimestampSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BSONTimestamp t = (BSONTimestamp)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("t", (Object)t.getTime());
            temp.put("i", (Object)t.getInc());
            BasicBSONObject timestampObj = new BasicBSONObject();
            timestampObj.put("$timestamp", (Object)temp);
            this.serializer.serialize(timestampObj, buf);
        }
    }

    static class UUIDSerializer
    extends CompoundObjectSerializer {
        UUIDSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            UUID uuid = (UUID)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$uuid", (Object)uuid.toString());
            this.serializer.serialize(temp, buf);
        }
    }

    static class StringSerializer
    extends AbstractObjectSerializer {
        protected final Configuration configuration;

        public StringSerializer() {
            this.configuration = new Configuration(true, false, true, true);
        }

        public StringSerializer(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            String s = (String)obj;
            StringSerializer.serialize(s, buf, this.configuration, true);
        }

        public static void serialize(String s, StringBuilder buf, Configuration configuration, boolean requiresDoubleQuotes) {
            if (requiresDoubleQuotes) {
                buf.append("\"");
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (configuration.escapeJavaEscapeSequences) {
                    if (c == '\\') {
                        buf.append("\\\\");
                        continue;
                    }
                    if (c == '\"') {
                        buf.append("\\\"");
                        continue;
                    }
                    if (c == '\n') {
                        buf.append("\\n");
                        continue;
                    }
                    if (c == '\r') {
                        buf.append("\\r");
                        continue;
                    }
                    if (c == '\t') {
                        buf.append("\\t");
                        continue;
                    }
                    if (c == '\b') {
                        buf.append("\\b");
                        continue;
                    }
                    if (c < ' ' && configuration.suppressControlCharacters) continue;
                    buf.append(c);
                    continue;
                }
                if (c < ' ' && configuration.suppressControlCharacters) continue;
                buf.append(c);
            }
            if (requiresDoubleQuotes) {
                buf.append("\"");
            }
        }

        public static boolean needsDoubleQuotes(String s, Configuration configuration) {
            if (configuration.strict) {
                return true;
            }
            if (configuration.escapeJavaEscapeSequences) {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '\\') {
                        return true;
                    }
                    if (c == '\"') {
                        return true;
                    }
                    if (c == '\n') {
                        return true;
                    }
                    if (c == '\r') {
                        return true;
                    }
                    if (c == '\t') {
                        return true;
                    }
                    if (c == '\b') {
                        return true;
                    }
                    if (c >= ' ' || !configuration.suppressControlCharacters) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    static class PatternSerializer
    extends CompoundObjectSerializer {
        PatternSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BasicBSONObject externalForm = new BasicBSONObject();
            externalForm.put("$regex", (Object)obj.toString());
            if (((Pattern)obj).flags() != 0) {
                externalForm.put("$options", (Object)Bytes.regexFlags(((Pattern)obj).flags()));
            }
            this.serializer.serialize(externalForm, buf);
        }
    }

    static class InformixObjectIdSerializer
    extends CompoundObjectSerializer {
        InformixObjectIdSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            buf.append("ObjectId(\"" + obj.toString() + "\")");
        }
    }

    static class ObjectIdSerializer
    extends CompoundObjectSerializer {
        ObjectIdSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serializer.serialize(new BasicBSONObject("$oid", obj.toString()), buf);
        }
    }

    static class MinKeySerializer
    extends CompoundObjectSerializer {
        MinKeySerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serializer.serialize(new BasicBSONObject("$minKey", (Object)1), buf);
        }
    }

    static class MaxKeySerializer
    extends CompoundObjectSerializer {
        MaxKeySerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serializer.serialize(new BasicBSONObject("$maxKey", (Object)1), buf);
        }
    }

    static class MapSerializer
    extends CompoundObjectSerializer {
        MapSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            boolean first = true;
            if (this.configuration.minify) {
                buf.append("{");
            } else {
                buf.append("{ ");
            }
            Map m = (Map)obj;
            for (Map.Entry entry : m.entrySet()) {
                if (first) {
                    first = false;
                } else if (this.configuration.minify) {
                    buf.append(",");
                } else {
                    buf.append(" , ");
                }
                String key = (String)entry.getKey();
                StringSerializer.serialize(key, buf, this.configuration, StringSerializer.needsDoubleQuotes(key, this.configuration));
                if (this.configuration.minify) {
                    buf.append(":");
                } else {
                    buf.append(" : ");
                }
                this.serializer.serialize(entry.getValue(), buf);
            }
            if (this.configuration.minify) {
                buf.append("}");
            } else {
                buf.append(" }");
            }
        }
    }

    static class IterableSerializer
    extends CompoundObjectSerializer {
        IterableSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            boolean first = true;
            if (this.configuration.minify) {
                buf.append("[");
            } else {
                buf.append("[ ");
            }
            for (Object o : (Iterable)obj) {
                if (first) {
                    first = false;
                } else if (this.configuration.minify) {
                    buf.append(",");
                } else {
                    buf.append(" , ");
                }
                this.serializer.serialize(o, buf);
            }
            if (this.configuration.minify) {
                buf.append("]");
            } else {
                buf.append(" ]");
            }
        }
    }

    static class DBRefBaseSerializer
    extends CompoundObjectSerializer {
        DBRefBaseSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            DBRefBase ref = (DBRefBase)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ref", (Object)ref.getRef());
            temp.put("$id", ref.getId());
            this.serializer.serialize(temp, buf);
        }
    }

    static class BSONObjectSerializer
    extends CompoundObjectSerializer {
        BSONObjectSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            boolean first = true;
            if (this.configuration.minify) {
                buf.append("{");
            } else {
                buf.append("{ ");
            }
            BSONObject dbo = (BSONObject)obj;
            Iterator<String> i$ = dbo.keySet().iterator();
            while (i$.hasNext()) {
                String s;
                String name = s = i$.next();
                if (first) {
                    first = false;
                } else if (this.configuration.minify) {
                    buf.append(",");
                } else {
                    buf.append(" , ");
                }
                StringSerializer.serialize(name, buf, this.configuration, StringSerializer.needsDoubleQuotes(name, this.configuration));
                if (this.configuration.minify) {
                    buf.append(":");
                } else {
                    buf.append(" : ");
                }
                this.serializer.serialize(dbo.get(name), buf);
            }
            if (this.configuration.minify) {
                buf.append("}");
            } else {
                buf.append(" }");
            }
        }
    }

    static class InformixDateSerializer
    extends CompoundObjectSerializer {
        InformixDateSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Date d = (Date)obj;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            buf.append("ISODate(\"");
            buf.append(format.format(d));
            buf.append("\")");
        }
    }

    static class LegacyDateSerializer
    extends CompoundObjectSerializer {
        LegacyDateSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Date d = (Date)obj;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            this.serializer.serialize(new BasicBSONObject("$date", format.format(d)), buf);
        }
    }

    static class CodeWScopeSerializer
    extends CompoundObjectSerializer {
        CodeWScopeSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            CodeWScope c = (CodeWScope)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$code", (Object)c.getCode());
            temp.put("$scope", (Object)c.getScope());
            this.serializer.serialize(temp, buf);
        }
    }

    static class CodeSerializer
    extends CompoundObjectSerializer {
        CodeSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Code c = (Code)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$code", (Object)c.getCode());
            this.serializer.serialize(temp, buf);
        }
    }

    static class LegacyBSONTimestampSerializer
    extends CompoundObjectSerializer {
        LegacyBSONTimestampSerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BSONTimestamp t = (BSONTimestamp)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ts", (Object)t.getTime());
            temp.put("$inc", (Object)t.getInc());
            this.serializer.serialize(temp, buf);
        }
    }

    static class ToStringSerializer
    extends AbstractObjectSerializer {
        ToStringSerializer() {
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            buf.append(obj.toString());
        }
    }

    static class ObjectArraySerializer
    extends CompoundObjectSerializer {
        ObjectArraySerializer(ObjectSerializer serializer, Configuration configuration) {
            super(serializer, configuration);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            if (this.configuration.minify) {
                buf.append("[");
            } else {
                buf.append("[ ");
            }
            for (int i = 0; i < Array.getLength(obj); ++i) {
                if (i > 0) {
                    if (this.configuration.minify) {
                        buf.append(",");
                    } else {
                        buf.append(" , ");
                    }
                }
                this.serializer.serialize(Array.get(obj, i), buf);
            }
            if (this.configuration.minify) {
                buf.append("]");
            } else {
                buf.append(" ]");
            }
        }
    }

    static class LegacyBinarySerializer
    extends AbstractObjectSerializer {
        LegacyBinarySerializer() {
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            buf.append("<Binary Data>");
        }
    }

    static abstract class CompoundObjectSerializer
    extends AbstractObjectSerializer {
        protected final ObjectSerializer serializer;
        protected final Configuration configuration;

        CompoundObjectSerializer(ObjectSerializer serializer, Configuration configuration) {
            this.serializer = serializer;
            this.configuration = configuration;
        }
    }

    public static class Builder {
        private static final boolean DEFAULT_ESCAPE_JAVA_ESCAPE_SEQUENCES = true;
        private static final boolean DEFAULT_INFORMIX_SUPPORT = false;
        private static final boolean DEFAULT_MINIFY = false;
        private static final boolean DEFAULT_STRICT = false;
        private static final boolean DEFAULT_SUPPRESS_CONTROL_CHARACTERS = true;
        private boolean escapeJavaEscapeSequences = true;
        private boolean informixSupport = false;
        private boolean minify = false;
        private boolean strict = false;
        private boolean suppressControlCharacters = true;

        public Builder reset() {
            this.escapeJavaEscapeSequences = true;
            this.informixSupport = false;
            this.minify = false;
            this.strict = false;
            this.suppressControlCharacters = true;
            return this;
        }

        public Builder escapeJavaEscapeSequences(boolean escapeJavaEscapeSequences) {
            this.escapeJavaEscapeSequences = escapeJavaEscapeSequences;
            return this;
        }

        public Builder minify(boolean minify) {
            this.minify = minify;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder suppressControlCharacters(boolean suppressControlCharacters) {
            this.suppressControlCharacters = suppressControlCharacters;
            return this;
        }

        public JSONSerializer build() {
            ClassMapBasedObjectSerializer serializer = new ClassMapBasedObjectSerializer();
            Configuration configuration = new Configuration(this.strict, this.minify, this.escapeJavaEscapeSequences, this.suppressControlCharacters);
            serializer.addObjectSerializer(Boolean.class, new ToStringSerializer());
            serializer.addObjectSerializer(BSONObject.class, new BSONObjectSerializer(serializer, configuration));
            serializer.addObjectSerializer(Code.class, new CodeSerializer(serializer, configuration));
            serializer.addObjectSerializer(CodeWScope.class, new CodeWScopeSerializer(serializer, configuration));
            serializer.addObjectSerializer(DBRefBase.class, new DBRefBaseSerializer(serializer, configuration));
            serializer.addObjectSerializer(Iterable.class, new IterableSerializer(serializer, configuration));
            serializer.addObjectSerializer(Map.class, new MapSerializer(serializer, configuration));
            serializer.addObjectSerializer(MaxKey.class, new MaxKeySerializer(serializer, configuration));
            serializer.addObjectSerializer(MinKey.class, new MinKeySerializer(serializer, configuration));
            serializer.addObjectSerializer(Number.class, new ToStringSerializer());
            serializer.addObjectSerializer(Object[].class, new ObjectArraySerializer(serializer, configuration));
            serializer.addObjectSerializer(ObjectId.class, new ObjectIdSerializer(serializer, configuration));
            serializer.addObjectSerializer(Pattern.class, new PatternSerializer(serializer, configuration));
            serializer.addObjectSerializer(String.class, new StringSerializer(configuration));
            serializer.addObjectSerializer(UUID.class, new UUIDSerializer(serializer, configuration));
            if (this.strict) {
                serializer.addObjectSerializer(Date.class, new DateSerializer(serializer, configuration));
                serializer.addObjectSerializer(BSONTimestamp.class, new BSONTimestampSerializer(serializer, configuration));
                serializer.addObjectSerializer(Binary.class, new BinarySerializer(serializer, configuration));
                serializer.addObjectSerializer(byte[].class, new ByteArraySerializer(serializer, configuration));
            }
            if (this.informixSupport) {
                serializer.addObjectSerializer(ObjectId.class, new InformixObjectIdSerializer(serializer, configuration));
                serializer.addObjectSerializer(Date.class, new InformixDateSerializer(serializer, configuration));
                serializer.addObjectSerializer(BSONTimestamp.class, new LegacyBSONTimestampSerializer(serializer, configuration));
                serializer.addObjectSerializer(Binary.class, new LegacyBinarySerializer());
                serializer.addObjectSerializer(byte[].class, new LegacyBinarySerializer());
            }
            return new JSONSerializer(serializer, configuration);
        }
    }

    protected static class Configuration {
        protected final boolean escapeJavaEscapeSequences;
        protected final boolean minify;
        protected final boolean strict;
        protected final boolean suppressControlCharacters;

        protected Configuration(boolean strict, boolean minify, boolean escapeJavaEscapeSequences, boolean suppressControlCharacters) {
            this.escapeJavaEscapeSequences = escapeJavaEscapeSequences;
            this.minify = minify;
            this.strict = strict;
            this.suppressControlCharacters = suppressControlCharacters;
        }
    }
}

