/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.lang.Decimal;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CSMspwd {
    static final int STREAM_BUF_SIZE = 4096;
    static final short CSM_SPWD_MSG_TYPE_DH_PUB_NUMBER = 1;
    static final short CSM_SPWD_MSG_TYPE_ENCRYPTED_PWD = 2;
    static final short SPWD_CSM_MSG_TYPE_DATA = 3;
    static final String DH = "DH";
    static final String DES_ENCRYPT = "DES";
    private static final String CSM_SPWD_DH_MODULUS_String = "CB4AAD9AD0B42AF666B42B57463C7325B781EFA79B5063AB0CCE98D23B3AA975475549A99E3E75EC1DBC9503CD6C1303BA6184FC769ED599966DA4BD84558EB7";
    private static final BigInteger CSM_SPWD_DH_MODULUS = new BigInteger("CB4AAD9AD0B42AF666B42B57463C7325B781EFA79B5063AB0CCE98D23B3AA975475549A99E3E75EC1DBC9503CD6C1303BA6184FC769ED599966DA4BD84558EB7", 16);
    private static final BigInteger CSM_SPWD_DH_GENERATOR = BigInteger.valueOf(5L);
    private static final short BLOCK_SIZE = 8;
    static final short CSM_SPWD_DH_NUM_BITS = 512;
    static final short[] odd_parity = new short[]{1, 1, 2, 2, 4, 4, 7, 7, 8, 8, 11, 11, 13, 13, 14, 14, 16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31, 32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47, 49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62, 64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79, 81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94, 97, 97, 98, 98, 100, 100, 103, 103, 104, 104, 107, 107, 109, 109, 110, 110, 112, 112, 115, 115, 117, 117, 118, 118, 121, 121, 122, 122, 124, 124, 127, 127, 128, 128, 131, 131, 133, 133, 134, 134, 137, 137, 138, 138, 140, 140, 143, 143, 145, 145, 146, 146, 148, 148, 151, 151, 152, 152, 155, 155, 157, 157, 158, 158, 161, 161, 162, 162, 164, 164, 167, 167, 168, 168, 171, 171, 173, 173, 174, 174, 176, 176, 179, 179, 181, 181, 182, 182, 185, 185, 186, 186, 188, 188, 191, 191, 193, 193, 194, 194, 196, 196, 199, 199, 200, 200, 203, 203, 205, 205, 206, 206, 208, 208, 211, 211, 213, 213, 214, 214, 217, 217, 218, 218, 220, 220, 223, 223, 224, 224, 227, 227, 229, 229, 230, 230, 233, 233, 234, 234, 236, 236, 239, 239, 241, 241, 242, 242, 244, 244, 247, 247, 248, 248, 251, 251, 253, 253, 254, 254};
    private byte[] dhPubKeyEncoded;
    private KeyFactory dhKeyFactory = null;
    private PublicKey dhPubKey;
    private KeyAgreement dhKeyAgree;
    private byte[] secret;
    private SecretKey DESKey;
    private byte[] iv;
    private Cipher cipherPassword;
    private Cipher cipherMessage;
    private IvParameterSpec ivSpec;
    private String ClientLocale = null;

    public CSMspwd() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException {
        KeyPairGenerator dhKeyPairGenerator;
        DHParameterSpec aDHParamSpec = new DHParameterSpec(CSM_SPWD_DH_MODULUS, CSM_SPWD_DH_GENERATOR);
        KeyPair dhKeyPair = null;
        try {
            dhKeyPairGenerator = KeyPairGenerator.getInstance(DH);
        }
        catch (Exception e) {
            dhKeyPairGenerator = KeyPairGenerator.getInstance(DH);
        }
        dhKeyPairGenerator.initialize(aDHParamSpec);
        dhKeyPair = dhKeyPairGenerator.genKeyPair();
        this.dhPubKeyEncoded = dhKeyPair.getPublic().getEncoded();
        this.dhKeyFactory = KeyFactory.getInstance(DH);
        this.dhKeyAgree = KeyAgreement.getInstance(DH);
        this.dhKeyAgree.init(dhKeyPair.getPrivate());
        this.cipherPassword = Cipher.getInstance("DES/ECB/PKCS5Padding");
        this.cipherMessage = Cipher.getInstance("DES/CBC/PKCS5Padding");
    }

    public void createContext(String username, String password, IfxDataInputStream asfIfxIs, IfxDataOutputStream asfIfxOs) throws IOException, IfxASFException {
        this.sendPublicKey(asfIfxOs);
        this.recvPublicKey(asfIfxIs, asfIfxOs);
        this.computeSecretKey();
    }

    private void sendPublicKey(IfxDataOutputStream asfIfxOs) throws IOException {
        byte lenAlgorithmID = this.dhPubKeyEncoded[4];
        byte lenPublicKey = this.dhPubKeyEncoded[lenAlgorithmID + 6];
        byte[] keyBytes = new byte[lenPublicKey + 2];
        Decimal.bycopy(this.dhPubKeyEncoded, lenAlgorithmID + 5, keyBytes, 0);
        ByteArrayOutputStream keyByteArrayOs = new ByteArrayOutputStream(lenPublicKey + 8);
        short messageType = 1;
        IfxDataOutputStream o = new IfxDataOutputStream(keyByteArrayOs);
        o.writeShort(messageType);
        o.writeShort(keyBytes.length);
        o.write(keyBytes);
        keyByteArrayOs.writeTo(asfIfxOs);
        o.close();
    }

    private void recvPublicKey(IfxDataInputStream asfIfxIs, IfxDataOutputStream asfIfxOs) throws IOException, IfxASFException {
        byte[] byteArrayInput = new byte[4096];
        IfxDataInputStream in = null;
        asfIfxOs.flush();
        in = new IfxDataInputStream(new ByteArrayInputStream(byteArrayInput));
        in.setClientLocale(this.ClientLocale);
        short messageType = asfIfxIs.readShort();
        if (messageType != 1) {
            in.close();
            throw IfxErrMsg.getLocIfxASFException(-5011, this.ClientLocale);
        }
        short length = asfIfxIs.readShort();
        asfIfxIs.read(byteArrayInput, 0, length);
        int byteLen = length + this.dhPubKeyEncoded[4] + 5;
        byte[] keyBytes = new byte[byteLen];
        Decimal.bycopy(this.dhPubKeyEncoded, 0, keyBytes, 0);
        in.readFully(keyBytes, this.dhPubKeyEncoded[4] + 5, length);
        keyBytes[2] = (byte)(byteLen - 3);
        in.close();
        try {
            X509EncodedKeySpec dhServerPubKeySpec = new X509EncodedKeySpec(keyBytes);
            this.dhPubKey = this.dhKeyFactory.generatePublic(dhServerPubKeySpec);
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxASFException(-5030, this.ClientLocale);
        }
    }

    private void computeSecretKey() throws IfxASFException {
        try {
            this.dhKeyAgree.doPhase(this.dhPubKey, true);
            this.secret = this.dhKeyAgree.generateSecret();
            int marker = 0;
            for (int i = 0; i < this.secret.length && this.secret[i] == 0; ++i) {
                marker = i + 1;
            }
            byte[] SessionKey = new byte[8];
            Decimal.bycopy(this.secret, marker, SessionKey, 0);
            this.iv = new byte[8];
            System.arraycopy(this.secret, 8, this.iv, 0, 8);
            this.DESSetOddParity(SessionKey);
            this.DESKey = new SecretKeySpec(SessionKey, DES_ENCRYPT);
            this.ivSpec = new IvParameterSpec(this.iv);
        }
        catch (Exception e3) {
            throw IfxErrMsg.getLocIfxASFException(-5030, this.ClientLocale);
        }
    }

    public void sendEncryptPassword(String password, IfxDataOutputStream asfIfxOs) throws IOException, IfxASFException {
        byte[] cipherpassword;
        int length;
        ByteArrayOutputStream PasswordByteArrayOs = new ByteArrayOutputStream(4096);
        try {
            int remainder;
            this.cipherPassword.init(1, this.DESKey);
            length = password.length();
            if (length == 8) {
                ++length;
            }
            if ((remainder = length % 8) > 0) {
                StringBuffer junkSB = new StringBuffer(password);
                junkSB.setLength(length + (8 - remainder));
                password = junkSB.toString();
            }
            byte[] BytePassword = password.getBytes();
            cipherpassword = this.cipherPassword.doFinal(BytePassword, 0, BytePassword.length);
        }
        catch (Exception e3) {
            throw IfxErrMsg.getLocIfxASFException(-5030, this.ClientLocale);
        }
        IfxDataOutputStream o = new IfxDataOutputStream(PasswordByteArrayOs);
        o.writeShort((short)2);
        length = cipherpassword.length + 4;
        o.writeShort(length);
        o.writeShort(cipherpassword.length);
        o.write(cipherpassword);
        o.writeShort(0);
        PasswordByteArrayOs.writeTo(asfIfxOs);
        asfIfxOs.flush();
        o.close();
    }

    private void DESSetOddParity(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            short shortKey = (short)((short)key[i] & 0xFF);
            key[i] = (byte)odd_parity[shortKey];
        }
    }

    public void processInMessage(byte[] messageArray, byte[] decyptedDataArray) throws IfxASFException {
        try {
            this.cipherMessage.init(2, (Key)this.DESKey, this.ivSpec);
            this.cipherMessage.doFinal(messageArray, 0, decyptedDataArray.length, decyptedDataArray);
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxASFException(-5030, this.ClientLocale);
        }
    }

    public void processOutMessage(byte[] dataArray, byte[] encryptedDataArray) throws IfxASFException {
        try {
            this.cipherMessage.init(1, (Key)this.DESKey, this.ivSpec);
            this.cipherMessage.doFinal(dataArray, 0, dataArray.length, encryptedDataArray);
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxASFException(-5030, this.ClientLocale);
        }
    }

    public void setClientLocale(String loc) {
        this.ClientLocale = loc;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

