/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmDescriptor;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxMsgHdr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class IfxEncCsm
implements IfxCsm {
    private static final int ENC_CSM_FLAG_INITSTRING_PENDING = 1;
    private static final String ENC_CSM_CONTEXT_ID = "CSMENC";
    private static final int ENC_CSM_STATE_UNINITIALIZED = -1;
    private static final int ENC_CSM_STATE_INITIAL = 0;
    private static final int ENC_CSM_STATE_INITSTRING = 1;
    private static final int ENC_CSM_STATE_INITSTRINGDEFER = 2;
    private static final int ENC_CSM_STATE_INITSTRINGPENDING = 3;
    private static final int ENC_CSM_STATE_AUTHPENDING = 4;
    private static final int ENC_CSM_STATE_INITSTRING_SEND = 5;
    private static final int ENC_CSM_STATE_INITPW_SEND = 6;
    private static final int ENC_CSM_STATE_INITDONE = 7;
    private static final int ENC_CSM_STATE_ACTIVE = 8;
    private static final int ENC_CSM_STATE_MORE_INPUT_NEEDED = 9;
    private static final int ENC_CSM_STATE_MORE_OUTPUT_AVAILABLE = 10;
    private static final int ENC_CSM_STATE_SENDTOPEER_DONE = 11;
    private static final int ENC_CSM_STATE_RELEASE_CONTEXT = 12;
    private static final int ENC_CSM_STATE_READY = 13;
    private static final int ENC_CSM_STATE_ABORT = 14;
    private static final int ENC_CSM_STATE_ABORT_FINAL = 15;
    private static final int ENC_CSM_STATE_INIT_SEND = 20;
    private static final int ENC_CSM_MSG_TYPE_INITSTRING = 1;
    private static final int ENC_CSM_MSG_TYPE_AUTHENTICATION = 2;
    private static final int ENC_CSM_MSG_TYPE_DATA = 3;
    private static final int ENC_CSM_MSG_TYPE_RELEASE_CONTEXT = 4;
    private static final int ENC_CSM_MSG_TYPE_ABORT = 5;
    private static final int ENC_CSM_MSG_TYPE_PWD = 6;
    private static final int ENC_CSM_MSG_TYPE_ID = 7;
    private static final int ENC_CSM_PWD_REQD_FLAG = 1;
    private static final int ENC_CSM_PWD_NOT_GIVEN = 16;
    String csmContextId;
    int contextFlags;
    int state = -1;
    int csm_error;
    IfxCsmDescriptor csmDesc;
    IfxCsmBuffer savedBuffer;
    IfxCryptoSession cryptoSession;
    IfxCsmBuffer outHandshake;
    IfxCsmBuffer outPw;
    String csmString;

    public IfxEncCsm(IfxCsmDescriptor csmdescr) throws IfxCsmException {
        this.csmDesc = csmdescr;
        this.savedBuffer = new IfxCsmBuffer();
        this.state = -1;
        this.csmDesc.setLoadState(0);
        this.csmDesc.setLoadState(2);
        this.csmString = this.csmDesc.getInitString();
        this.csmDesc.setLoadState(1);
    }

    public IfxCsmDescriptor getDescriptor() {
        return this.csmDesc;
    }

    @Override
    public int ifxCsmInit(String csmInitString, long flags, IfxCsm.Status status) throws IfxCsmException {
        int csmStatus = 0;
        status.reset();
        this.cryptoSession = new IfxCryptoSession();
        csmStatus = this.cryptoSession.csmCryptoInit(csmInitString, flags);
        if (csmStatus != 0) {
            status.setCsmErr(-5006);
            status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(csmStatus));
            return 1;
        }
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmTerminate(IfxCsm.Status status) {
        int retVal = 0;
        return retVal;
    }

    @Override
    public long ifxCsmGetAttributeFlags(IfxCsm.Status status) {
        return 2L;
    }

    @Override
    public int ifxCsmCreateContext(IfxCsm.Credentials credentials, IfxCsmReadBuffer inHndShk, IfxCsmBuffer outHndShk, String contextInitString, IfxCsm.Status status) throws IfxCsmException {
        boolean retVal = false;
        IfxCsmBuffer outputToken = new IfxCsmBuffer();
        IfxCsmBuffer inputToken = new IfxCsmBuffer();
        IfxCsmBuffer IDBuff = new IfxCsmBuffer();
        IfxMsgHdr msgHeader = new IfxMsgHdr();
        int ctxFlags = 0;
        int cryptoStatus = 0;
        int rtnStatus = 0;
        int msgType = 0;
        outHndShk.reset();
        status.reset();
        if (this.state == -1) {
            this.encInitializeCsmContext();
            this.savedBuffer = new IfxCsmBuffer();
            this.contextFlags = ctxFlags;
            this.outHandshake = new IfxCsmBuffer();
            cryptoStatus = this.cryptoSession.csmCryptoInitSession(1, outputToken);
            if (cryptoStatus != 0) {
                this.encDestroyCsmContext();
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(cryptoStatus));
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            msgType = 1;
            if (this.encPackBuffer(outputToken, this.outHandshake, msgType, status) == 1) {
                this.encDestroyCsmContext();
                status.setCsmErr(-5010);
                outputToken.reset();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            outputToken.reset();
            if (inHndShk != null && inHndShk.available() > 0) {
                this.outHandshake.reset();
                this.outHandshake.write(outHndShk.toByteArray());
                this.state = 3;
            } else {
                this.state = 1;
            }
        }
        if (this.state == 7) {
            return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
        }
        if (this.state == 14) {
            this.state = 15;
        } else if (inHndShk != null && inHndShk.available() > 0) {
            if (this.encSaveInBuffer(inHndShk, status) == 1) {
                this.encDestroyCsmContext();
                status.setCsmErr(-5010);
                status.setCsmString("Failure attempting to combine buffers");
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (this.encProcessSavedBuffer(msgHeader, inputToken, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Unable to process a staged buffer");
                this.encDestroyCsmContext();
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (status.getCsmCode() == 5L) {
                return 0;
            }
            if (msgHeader.getType() == 5) {
                this.encGetAbortToken(inputToken, status);
                this.state = 15;
                this.savedBuffer.reset();
                return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
            }
            if (msgHeader.getType() != 1) {
                status.setCsmErr(-5012);
                status.setCsmString("Received message type %d but expecting %d" + msgHeader.getType() + 1);
                this.encDestroyCsmContext();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            cryptoStatus = this.cryptoSession.csmCryptoAcceptConnection(inputToken);
            if (cryptoStatus != 0) {
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(cryptoStatus));
                if (this.state == 14) {
                    return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
                }
                this.encDestroyCsmContext();
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            rtnStatus = this.encBuildCredentialsBuffer(credentials, IDBuff);
            if (rtnStatus != 0) {
                status.setCsmErr(rtnStatus);
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            cryptoStatus = this.cryptoSession.csmCryptoEncrypt(new IfxCsmReadBuffer(IDBuff), outputToken);
            if (cryptoStatus != 0) {
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(cryptoStatus));
                this.encDestroyCsmContext();
                outputToken.reset();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            this.outPw = new IfxCsmBuffer();
            msgType = 2;
            if (this.encPackBuffer(outputToken, this.outPw, msgType, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Can not pack output buffer");
                this.encDestroyCsmContext();
                outputToken.reset();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            outputToken.reset();
            if (this.state == 1) {
                this.state = 6;
            } else if (this.state == 3) {
                this.state = 5;
            }
        }
        return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
    }

    @Override
    public int ifxCsmProcessOutMessage(IfxCsmReadBuffer inBuffer, IfxCsmBuffer outBuffer, IfxCsm.Status status) throws IfxCsmException {
        status.reset();
        if (inBuffer == null || inBuffer.available() == 0) {
            status.setCsmCode(1L);
            return 0;
        }
        int cryptoStat = 0;
        IfxCsmBuffer tempBuffer = new IfxCsmBuffer();
        cryptoStat = this.cryptoSession.csmCryptoEncrypt(inBuffer, tempBuffer);
        if (cryptoStat != 0) {
            status.setCsmErr(-5010);
            status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(cryptoStat));
            tempBuffer = null;
            this.encDestroyCsmContext();
            return 1;
        }
        int msgType = 3;
        if (this.encPackBuffer(tempBuffer, outBuffer, msgType, status) == 1) {
            tempBuffer = null;
            return 1;
        }
        tempBuffer = null;
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmProcessInMessage(IfxCsmReadBuffer inBuffer, IfxCsmBuffer outBuffer, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        status.reset();
        if (this.state != 10 && (inBuffer == null || inBuffer.available() == 0)) {
            status.setCsmCode(5L);
            return 0;
        }
        if (this.state != 10 && this.encSaveInBuffer(inBuffer, status) == 1) {
            return 1;
        }
        this.state = 13;
        IfxMsgHdr msgHdr = new IfxMsgHdr();
        if (outBuffer.getCount() > 0) {
            IfxCsmBuffer tempBuffer = new IfxCsmBuffer();
            retVal = this.encProcessSavedBuffer(msgHdr, tempBuffer, status);
            try {
                tempBuffer.writeTo(outBuffer);
            }
            catch (IOException ex) {
                status.setCsmErr(-5010);
                return 1;
            }
        } else {
            retVal = this.encProcessSavedBuffer(msgHdr, outBuffer, status);
        }
        if (msgHdr.MsgType == 5) {
            this.encGetAbortToken(outBuffer, status);
            return 1;
        }
        return retVal;
    }

    private int encSaveInBuffer(IfxCsmReadBuffer inBuffer, IfxCsm.Status status) throws IfxCsmException {
        if (inBuffer == null || inBuffer.available() == 0) {
            return 0;
        }
        IfxCsmBuffer tempBuff = new IfxCsmBuffer();
        tempBuff.initialize(inBuffer);
        try {
            tempBuff.writeTo(this.savedBuffer);
        }
        catch (IOException ex) {
            status.setCsmErr(-5010);
            return 1;
        }
        return 0;
    }

    private int encProcessSavedBuffer(IfxMsgHdr msgHdr, IfxCsmBuffer outBuffer, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        if (this.savedBuffer.getCount() < 4) {
            status.setCsmCode(5L);
            return 0;
        }
        this.getMsgHdr(this.savedBuffer, msgHdr);
        if (this.savedBuffer.getCount() < msgHdr.MsgSize + 4) {
            status.setCsmCode(5L);
            return 0;
        }
        switch (msgHdr.MsgType) {
            case 4: {
                status.setCsmErr(-5008);
                this.state = 12;
                return 1;
            }
            case 5: {
                retVal = this.encProcessSavedBufferAbort(outBuffer, status);
                if (retVal != 0) {
                    outBuffer.reset();
                }
                return retVal;
            }
            case 2: 
            case 3: {
                return this.encProcessSavedBufferData(outBuffer, status, true);
            }
            case 1: {
                return this.encProcessSavedBufferData(outBuffer, status, false);
            }
        }
        status.setCsmErr(-5000);
        return 1;
    }

    private int encGetAbortToken(ByteArrayOutputStream outBuffer, IfxCsm.Status status) {
        int retVal = 0;
        return retVal;
    }

    @Override
    public int ifxCsmAbortContext(Object csmContext, IfxCsm.AbortInfo abortInfo, IfxCsm.Status status) {
        int retVal = 0;
        return retVal;
    }

    private void getMsgHdr(IfxCsmBuffer buff, IfxMsgHdr msgHdr) {
        byte[] hdrArray = new byte[4];
        buff.read(hdrArray, 0, 4);
        msgHdr.setMsgHdr(hdrArray);
    }

    private int encProcessSavedBufferAbort(ByteArrayOutputStream outBuffer, IfxCsm.Status status) {
        return this.encGetTokenFromSavedBuffer(outBuffer, status);
    }

    private int encGetTokenFromSavedBuffer(ByteArrayOutputStream outBuffer, IfxCsm.Status status) {
        IfxMsgHdr msgHdr = new IfxMsgHdr();
        this.getMsgHdr(this.savedBuffer, msgHdr);
        byte[] tempArray = new byte[msgHdr.MsgSize + 4];
        this.savedBuffer.readWithReset(tempArray, 0, msgHdr.MsgSize + 4);
        outBuffer.reset();
        outBuffer.write(tempArray, 4, msgHdr.MsgSize);
        if (this.savedBuffer.getCount() == 0) {
            this.savedBuffer.reset();
            status.setCsmCode(1L);
            return 0;
        }
        this.state = 10;
        status.setCsmCode(2L);
        return 0;
    }

    private int encProcessSavedBufferData(IfxCsmBuffer outBuffer, IfxCsm.Status status, boolean decrypt) throws IfxCsmException {
        IfxCsmBuffer inputMessageBuffer = new IfxCsmBuffer();
        if (this.encGetTokenFromSavedBuffer(inputMessageBuffer, status) == 1) {
            return 1;
        }
        if (decrypt) {
            int cryptoStat = 0;
            cryptoStat = this.cryptoSession.csmCryptoDecrypt(inputMessageBuffer, outBuffer);
            if (cryptoStat != 0) {
                outBuffer.reset();
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(cryptoStat));
                return 1;
            }
        } else {
            try {
                inputMessageBuffer.writeTo(outBuffer);
            }
            catch (IOException ex) {
                outBuffer.reset();
                status.setCsmErr(-5010);
                return 1;
            }
        }
        return 0;
    }

    private void encDestroyCsmContext() {
    }

    private int encPackBuffer(IfxCsmBuffer inBuff, IfxCsmBuffer outBuff, int msgType, IfxCsm.Status status) {
        int tokenLen = 0;
        if (inBuff != null) {
            tokenLen = inBuff.getCount();
        }
        IfxMsgHdr msgHdr = new IfxMsgHdr(msgType, tokenLen);
        int outBuffLenEstimate = outBuff.size() + 4 + tokenLen;
        IfxCsmBuffer newOutBuff = new IfxCsmBuffer(outBuffLenEstimate);
        try {
            if (outBuff.size() > 0) {
                outBuff.writeTo(newOutBuff);
            }
            newOutBuff.write(msgHdr.getCMsgHdr());
            if (tokenLen > 0) {
                inBuff.writeTo(newOutBuff);
            }
        }
        catch (IOException ex) {
            status.setCsmErr(-5010);
            return 1;
        }
        outBuff.initialize(newOutBuff);
        return 0;
    }

    private void encInitializeCsmContext() {
        this.state = 0;
        this.csmContextId = ENC_CSM_CONTEXT_ID;
        if (this.savedBuffer != null) {
            this.savedBuffer.reset();
        }
        this.outHandshake = null;
    }

    private int exitIfxCsmCreateContext(IfxCsmBuffer inputToken, IfxCsmBuffer outputToken, IfxCsmBuffer outHndShk, IfxCsm.Status status) throws IfxCsmException {
        if (inputToken != null) {
            inputToken.reset();
        }
        switch (this.state) {
            case 7: {
                status.setCsmCode(1L);
                this.state = 13;
                return 0;
            }
            case 1: {
                outHndShk.reset();
                outHndShk.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(3L);
                return 0;
            }
            case 5: {
                outHndShk.reset();
                outHndShk.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(4L);
                this.state = 6;
                return 0;
            }
            case 6: {
                outHndShk.reset();
                outHndShk.write(this.outPw.toByteArrayWithReset());
                status.setCsmCode(4L);
                this.state = 7;
                return 0;
            }
            case 14: {
                if (outHndShk.size() > 0) {
                    outHndShk.reset();
                }
                outputToken = new IfxCsmBuffer();
                this.encMakeAbortToken(outputToken, status);
                int msgType = 5;
                if (this.encPackBuffer(outputToken, outHndShk, msgType, status) == 1) {
                    status.setCsmErr(-5010);
                    status.setCsmString("Can not pack output buffer");
                    this.encDestroyCsmContext();
                    return this.err1IfxCsmCreateContext(outHndShk, status);
                }
                status.setCsmCode(4L);
                status.setCsmErr(0);
                return 0;
            }
            case 15: {
                status.setCsmErr(-5000);
                status.setCsmString("CSM abort");
                this.encDestroyCsmContext();
                status.setCsmCode(1L);
                return 1;
            }
            case 13: {
                status.setCsmCode(1L);
                return 1;
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    private int err1IfxCsmCreateContext(ByteArrayOutputStream outHndShk, IfxCsm.Status status) throws IfxCsmException {
        outHndShk.reset();
        status.setCsmCode(1L);
        throw IfxCryptoSession.getCsmErrException(-5010);
    }

    private int encBuildCredentialsBuffer(IfxCsm.Credentials creds, IfxCsmBuffer idbuffParm) {
        int retVal = 0;
        byte[] nullTerminatedPwd = new byte[]{};
        IfxMsgHdr msgHdr = new IfxMsgHdr();
        if (creds.getPwd() == null) {
            return retVal;
        }
        try {
            byte[] pwd = creds.getPwd().getBytes("ASCII");
            nullTerminatedPwd = new byte[pwd.length + 1];
            System.arraycopy(pwd, 0, nullTerminatedPwd, 0, pwd.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        msgHdr.setMsgType(6);
        msgHdr.setMsgSize(nullTerminatedPwd.length);
        idbuffParm.reset();
        idbuffParm.write(msgHdr.getCMsgHdr());
        idbuffParm.write(nullTerminatedPwd);
        return retVal;
    }

    private void encMakeAbortToken(IfxCsmBuffer outputToken, IfxCsm.Status status) {
    }

    @Override
    public int ifxCsmReleaseContext(IfxCsmReadBuffer inHandshake, IfxCsmBuffer outHandShake, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        return retVal;
    }

    @Override
    public int ifxCsmAcceptContext(Object csmContext, IfxCsm.Credentials cred, IfxCsmReadBuffer inHandshake, IfxCsmBuffer outHandShake, String contextInitString, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        return retVal;
    }
}

