/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxByteArrayOutputStream;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

abstract class IfxSQLOutput
implements SQLOutput {
    IfxByteArrayOutputStream bStream = new IfxByteArrayOutputStream();
    IfxDataOutputStream os = new IfxDataOutputStream(this.bStream);
    protected IfxConnection conn;
    protected Trace trace = null;
    private boolean randomAccess = true;

    IfxSQLOutput() {
    }

    IfxSQLOutput(IfxConnection conn) throws SQLException {
        this.setConnection(conn);
    }

    void setConnection(IfxConnection conn) throws SQLException {
        this.conn = conn;
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace = conn.getTrace();
            if (this.trace == null) {
                throw IfxErrMsg.getSQLException(-79716, conn);
            }
        }
    }

    void reset() {
        this.bStream.reset();
    }

    int length() {
        return this.bStream.size();
    }

    public byte[] toByteArray() {
        return this.bStream.toByteArray();
    }

    @Override
    public void writeString(String x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeString(String).", this.conn);
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBoolean(boolean).", this.conn);
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.writeShort(x);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        try {
            this.os.writeShort(x);
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeInt(int x) throws SQLException {
        try {
            this.os.writeInt(x);
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeLong(long x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeLong(long).", this.conn);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        try {
            this.os.writeReal(x);
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        try {
            this.os.writeDouble(x);
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBigDecimal(BigDecimal).", this.conn);
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        try {
            this.os.write(x);
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeBytes(byte[] x, int len) throws SQLException {
        try {
            int numPadded = len - x.length;
            this.os.write(x);
            while (numPadded-- > 0) {
                this.os.write(0);
            }
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        try {
            this.os.writeDate(x);
            this.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        try {
            this.writeTimestamp(new Timestamp(x.getTime()));
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeTimestamp(Timestamp).", this.conn);
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeCharacterStream(Reader).", this.conn);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeAsciiStream(InputStream).", this.conn);
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBinaryStream(InputStream).", this.conn);
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeObject(SQLData).", this.conn);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeRef(Ref).", this.conn);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBlob(Blob).", this.conn);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeClob(Clob).", this.conn);
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeStruct(Struct).", this.conn);
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeArray(Array).", this.conn);
    }

    void setRandomAccess(boolean value) {
        this.randomAccess = value;
    }

    void adjustTotalDataSize() {
        if (this.randomAccess) {
            this.bStream.adjustTotalDataSize();
        }
    }
}

