/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLInput;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;

public class IfxUDTInput
extends IfxSQLInput
implements IfmxUDTSQLInput {
    private static final Object logger = Trace.getLoggerForClass(IfxUDTInput.class);
    private static final int NO_ALIGNMENT = -1;
    private boolean autoAlignmentEnabled = true;

    IfxUDTInput(IfxConnection conn, byte[] b, int index, int length) throws SQLException {
        super(conn, b, index, length);
    }

    private void checkAlignment(int dataSize, int alignment) throws SQLException {
        if (this.autoAlignmentEnabled && alignment != -1) {
            int nbSkip = (this.currentPos + dataSize + (alignment - 1) & ~(alignment - 1)) - (this.currentPos + dataSize);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "IfxUDTOutput.checkAlignment(): currentPos = " + this.currentPos);
                this.trace.writeTrace(logger, 3, "                               dataSize = " + dataSize);
                this.trace.writeTrace(logger, 3, "                               nbSkip = " + nbSkip);
            }
            if (nbSkip > 0) {
                super.checkLength(nbSkip);
                super.skipBytes(nbSkip);
                this.currentPos += nbSkip;
            }
        }
    }

    @Override
    public byte readByte() throws SQLException {
        this.checkAlignment(1, -1);
        this.checkLength(1);
        ++this.currentPos;
        try {
            return this.is.readByte();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public short readShort() throws SQLException {
        this.checkAlignment(2, 2);
        return super.readShort();
    }

    @Override
    public int readInt() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readInt();
    }

    @Override
    public String readString(int len) throws SQLException {
        return this.readString(len, null);
    }

    public String readString(int len, String dbEnc) throws SQLException {
        String S;
        byte[] b;
        if (this.unreadLength < len) {
            len = this.unreadLength;
        }
        this.checkAlignment(len, -1);
        this.checkLength(len);
        try {
            b = new byte[len];
            this.is.readFully(b, 0, len);
            this.currentPos += len;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        try {
            int adjustedLength;
            for (adjustedLength = 0; adjustedLength < b.length && b[adjustedLength] != 0; ++adjustedLength) {
            }
            dbEnc = this.conn.getdbEncoding();
            S = IfxToJavaType.IfxToJavaChar(b, 0, adjustedLength, dbEnc, ((IfxSqliConnect)this.conn).encoption);
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
        if (S == null) {
            this.isNull = true;
            return null;
        }
        return S;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        byte b = 0;
        this.checkAlignment(1, -1);
        this.checkLength(1);
        try {
            b = this.is.readByte();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        ++this.currentPos;
        if (b == 1) {
            return true;
        }
        if (b == 0) {
            return false;
        }
        if (b == 255) {
            this.isNull = true;
        }
        return false;
    }

    @Override
    public long readLong() throws SQLException {
        this.checkAlignment(4, 4);
        try {
            int i;
            byte[] bint8 = new byte[8];
            long l = 0L;
            for (i = 4; i < 8; ++i) {
                bint8[i] = (byte)(0xFF & (short)this.readByte());
            }
            for (i = 0; i < 4; ++i) {
                bint8[i] = (byte)(0xFF & (short)this.readByte());
            }
            short sign = this.readShort();
            if (sign == 0) {
                this.isNull = true;
            } else {
                BigInteger b = new BigInteger(bint8);
                l = b.longValue();
                if (sign == -1) {
                    l *= -1L;
                }
            }
            if (this.autoAlignmentEnabled) {
                this.readByte();
                this.readByte();
            }
            return l;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public long readLongBigint() throws SQLException {
        this.checkAlignment(4, 4);
        try {
            int i;
            byte[] bigint = new byte[8];
            long l = 0L;
            for (i = 4; i < 8; ++i) {
                bigint[i] = (byte)(0xFF & (short)this.readByte());
            }
            for (i = 0; i < 4; ++i) {
                bigint[i] = (byte)(0xFF & (short)this.readByte());
            }
            BigInteger b = new BigInteger(bigint);
            l = b.longValue();
            if (this.autoAlignmentEnabled) {
                this.readByte();
                this.readByte();
            }
            return l;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public float readFloat() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readFloat();
    }

    @Override
    public double readDouble() throws SQLException {
        this.checkAlignment(8, 8);
        return super.readDouble();
    }

    private Decimal readIfxDecimal() throws SQLException {
        this.checkAlignment(2, 2);
        return Decimal.dec_tToJava(this.readBytes(22));
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        try {
            Decimal dec = this.readIfxDecimal();
            if (dec.isNull()) {
                this.isNull = true;
                return null;
            }
            return dec.numericValue();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public byte[] readBytes(int len) throws SQLException {
        this.checkAlignment(len, -1);
        return super.readBytes(len);
    }

    @Override
    public Date readDate() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readDate();
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        try {
            short qualifier = this.readShort();
            Decimal dec = this.readIfxDecimal();
            if (dec.isNull()) {
                this.isNull = true;
                return null;
            }
            dec.setTimestampQualifier(qualifier);
            return dec.timestampValue();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readCharacterStream().", this.conn);
    }

    @Override
    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readObject().", this.conn);
    }

    @Override
    public Ref readRef() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readRef().", this.conn);
    }

    private IfxLocator readIfxLocator() throws SQLException {
        byte[] b = this.readBytes(72);
        return new IfxLocator(b, this.conn);
    }

    @Override
    public Blob readBlob() throws SQLException {
        IfxLocator loc = this.readIfxLocator();
        IfxSmBlob sBlob = new IfxSmBlob(this.conn, loc);
        return sBlob.toBlob();
    }

    @Override
    public Clob readClob() throws SQLException {
        IfxLocator loc = this.readIfxLocator();
        IfxSmBlob sBlob = new IfxSmBlob(this.conn, loc);
        return sBlob.toClob();
    }

    @Override
    public Array readArray() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readArray().", this.conn);
    }

    @Override
    public Interval readInterval() throws SQLException {
        try {
            short qualifier = this.readShort();
            Decimal dec = this.readIfxDecimal();
            if (dec.isNull()) {
                this.isNull = true;
                return null;
            }
            dec.setTimestampQualifier(qualifier);
            return dec.intervalValue();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.getMessage(), this.conn);
        }
    }

    @Override
    public void setAutoAlignment(boolean value) {
        this.autoAlignmentEnabled = value;
    }

    @Override
    public boolean getAutoAlignment() {
        return this.autoAlignmentEnabled;
    }

    @Override
    public void skipBytes(int len) throws SQLException {
        super.checkLength(len);
        super.skipBytes(len);
        this.currentPos += len;
    }

    @Override
    public int getCurrentPosition() {
        return super.currentPosition();
    }

    @Override
    public void setCurrentPosition(int position) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxUDTOutput.setCurrentPosition entering");
            this.trace.writeTrace(logger, 3, "    getCurrentPosition: " + this.getCurrentPosition());
        }
        if (position < 0) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        int cPos = this.getCurrentPosition();
        if (position > cPos) {
            this.skipBytes(position - cPos);
        } else if (position < cPos) {
            this.reset();
            this.currentPos = 0;
            this.unreadLength = this.totalLength;
            this.skipBytes(position);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxUDTOutput.setCurrentPosition exiting");
        }
    }

    @Override
    public int available() {
        return super.available();
    }

    @Override
    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        return this.conn.getUDTInfo(xid);
    }

    @Override
    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        return this.conn.getUDTInfo(name, owner);
    }

    @Override
    public URL readURL() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxUDTInput:readURL()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readURL()", this.conn);
    }

    @Override
    public NClob readNClob() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxUDTInput:readNClob()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readNClob()", this.conn);
    }

    @Override
    public String readNString() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxUDTInput:readNString()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readNString()", this.conn);
    }

    @Override
    public RowId readRowId() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxUDTInput:readRowId()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readRowId()", this.conn);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxUDTInput:readSQLXML()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readSQLXML()", this.conn);
    }

    @Override
    public byte[] readAllBytes() throws SQLException {
        this.reset();
        return this.readBytes(this.length());
    }
}

