/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxScrollableResultSet;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class IfxClientResultSet
extends IfxScrollableResultSet
implements IfmxResultSet {
    private static final Object logger = Trace.getLoggerForClass(IfxClientResultSet.class);
    private int fetchDirection = 1000;
    private int resultSetType = 1004;
    private int concurrency = 1008;
    private final int VECTOR_CAPACITY = 20;
    private int totalRowCount = 0;
    private Vector<Vector<IfxObject>> rowVector = null;
    private int curRowID = 0;
    private int savedRowID = 0;
    boolean isClosed = false;
    private final boolean uppercaseStrings;

    public IfxClientResultSet(IfxConnection conn, ResultSetMetaData md) throws SQLException {
        super(conn, md);
        this.uppercaseStrings = conn.isUpperCaseMetaDataLabels();
    }

    public void executeQuery() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeQuery().", this.conn);
    }

    public int executeUpdate() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeUpdate().", this.conn);
    }

    public void execute() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.execute().", this.conn);
    }

    @Override
    public void updateRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRow().", this.conn);
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.insertMode) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        if (this.totalRowCount == 0) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowVector.removeElementAt(this.curRowID - 1);
        --this.totalRowCount;
    }

    void deleteRow(int row) throws SQLException {
        if (this.concurrency == 1008) {
            this.rowVector.removeElementAt(row - 1);
            --this.totalRowCount;
        } else {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet:insertRow()");
        }
        if (!this.insertMode) {
            throw IfxErrMsg.getSQLException(-79815, this.conn);
        }
        if (this.insertRowVector == null) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        this.savedRowID = this.curRowID;
        if (this.curRowID == this.rowVector.size()) {
            this.rowVector.setSize(this.rowVector.size() + 20);
        }
        int insertRowIndex = this.curRowID;
        if (this.isAfterLast()) {
            insertRowIndex = this.curRowID - 1;
        }
        if (this.rowVector.get(this.curRowID) == null) {
            this.rowVector.setElementAt(this.insertRowVector, this.curRowID);
        } else {
            this.rowVector.add(this.curRowID, this.insertRowVector);
        }
        if (insertRowIndex == this.curRowID) {
            ++this.curRowID;
        }
        ++this.totalRowCount;
        this.insertRowVector = null;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.cancelRowUpdates().", this.conn);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.refreshRow().", this.conn);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    void setType(int type) throws SQLException {
        if (type != 1004 && type != 1003) {
            SQLWarning warn = new SQLWarning(IfxErrMsg.getMessage(-79775, this.conn.getclLocale()), "01000", -79775);
            this.chainWarnings(warn);
        }
        this.resultSetType = type == 1005 ? 1004 : type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    void setConcurrency(int value) throws SQLException {
        if (value != 1008 && value != 1007) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        this.concurrency = value;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:setFetchDirection()");
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.conn);
        }
        if (this.resultSetType == 1003 && direction != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.conn);
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:setFetchSize()");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (this.conn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.conn);
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.next() called");
            if (this.rowVector == null) {
                this.trace.writeTrace(logger, 2, "  rowVector is null.");
            } else {
                this.trace.writeTrace(logger, 2, "  rowVector is not null.");
                this.trace.writeTrace(logger, 2, "  rowVector.size(): " + this.rowVector.size());
                this.trace.writeTrace(logger, 2, "  CurRowID: " + this.curRowID);
                this.trace.writeTrace(logger, 2, "  totalRowCount: " + this.totalRowCount);
            }
        }
        if (this.rowVector == null || this.totalRowCount == 0) {
            return false;
        }
        if (this.curRowID >= this.totalRowCount) {
            return false;
        }
        ++this.curRowID;
        this.insertMode = false;
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, " next(): curRowID set too : " + this.curRowID);
        }
        this.colVector = this.rowVector.elementAt(this.curRowID - 1);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  next() colVector: " + this.colVector);
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.next() exited");
        }
        return true;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        this.insertMode = true;
        if (this.rowVector == null) {
            this.rowVector = new Vector(20, 20);
            this.rowVector.setSize(20);
            this.totalRowCount = 0;
        }
    }

    public void newRow() throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.newRow() called");
            this.trace.writeTrace(logger, 2, " rowVector: " + this.rowVector);
            this.trace.writeTrace(logger, 2, " totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 2, " insertRowVector: " + this.insertRowVector);
        }
        if (this.rowVector == null) {
            this.rowVector = new Vector(20, 20);
            this.rowVector.setSize(20);
            this.totalRowCount = 0;
        } else if (this.totalRowCount >= this.rowVector.size()) {
            this.rowVector.setSize(this.rowVector.size() + 20);
        }
        this.insertMode = false;
        this.colVector = new Vector(this.rsmd.getColumnCount());
        this.colVector.setSize(this.rsmd.getColumnCount());
        ++this.totalRowCount;
        this.rowVector.setElementAt(this.colVector, this.totalRowCount - 1);
        this.curRowID = this.totalRowCount;
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 2, " insertRowVector: " + this.insertRowVector);
            this.trace.writeTrace(logger, 2, " colVector: " + this.colVector);
            this.trace.writeTrace(logger, 2, " row added at: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.newRow() exiting");
        }
    }

    public void newRow(int nrows) throws SQLException {
        if (this.rowVector == null && nrows < 20) {
            this.rowVector = new Vector(nrows, 20);
            this.rowVector.setSize(nrows);
        }
        for (int i = 0; i < nrows; ++i) {
            this.newRow();
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this.curRowID;
    }

    public int getRowCount() {
        return this.totalRowCount;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.totalRowCount == 0) {
            return false;
        }
        if (row == 0) {
            this.curRowID = 0;
            this.colVector = null;
            return false;
        }
        if (row > this.totalRowCount + 1) {
            this.curRowID = this.totalRowCount + 1;
            this.colVector = null;
            return false;
        }
        if (row < 0) {
            this.curRowID = this.totalRowCount + row + 1;
            if (this.curRowID < 1) {
                this.curRowID = 0;
                return false;
            }
        } else {
            this.curRowID = row;
        }
        this.colVector = this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.curRowID == 0 || this.totalRowCount == 0) {
            return false;
        }
        --this.curRowID;
        this.colVector = this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean relative(int count) throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.totalRowCount == 0) {
            return false;
        }
        if (count == 0) {
            return this.curRowID == 0 || this.curRowID == this.totalRowCount;
        }
        int newRowID = this.curRowID + count;
        if (newRowID >= this.totalRowCount + 1) {
            this.afterLast();
            return false;
        }
        if (newRowID < 0) {
            this.beforeFirst();
            return false;
        }
        this.curRowID = newRowID;
        this.colVector = this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.curRowID == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxResultSet.isAfterLast() called");
        }
        return this.totalRowCount > 0 && this.curRowID == this.totalRowCount + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.curRowID == 1;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.savedRowID != 0) {
            this.curRowID = this.savedRowID;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxResultSet.isLast() called");
        }
        return this.totalRowCount > 0 && this.curRowID == this.totalRowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        this.curRowID = 0;
        this.colVector = null;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.totalRowCount == 0) {
            return;
        }
        this.insertMode = false;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxResultSet.afterLast() called");
        }
        this.curRowID = this.totalRowCount + 1;
        this.colVector = null;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.totalRowCount == 0) {
            return false;
        }
        this.insertMode = false;
        this.curRowID = 1;
        this.colVector = this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.totalRowCount == 0) {
            return false;
        }
        this.insertMode = false;
        this.curRowID = this.totalRowCount;
        this.colVector = this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.rowUpdated().", this.conn);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.rowInserted().", this.conn);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.rowDeleted().", this.conn);
    }

    public void updateNull(int rowIdx, int colIdx) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateNull() called");
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateNull(colIdx);
    }

    public void updateNull(int rowIdx, String column) throws SQLException {
        this.updateNull(rowIdx, this.findColumn(column));
    }

    public void updateBoolean(int rowIdx, int colIdx, boolean x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBoolean(colIdx, x);
    }

    public void updateBoolean(int rowIdx, String column, boolean x) throws SQLException {
        this.updateBoolean(rowIdx, this.findColumn(column), x);
    }

    public void updateByte(int rowIdx, int colIdx, byte x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateByte(colIdx, x);
    }

    public void updateByte(int rowIdx, String column, byte x) throws SQLException {
        this.updateByte(rowIdx, this.findColumn(column), x);
    }

    public void updateShort(int rowIdx, int colIdx, short x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateShort(colIdx, x);
    }

    public void updateShort(int rowIdx, String column, short x) throws SQLException {
        this.updateShort(rowIdx, this.findColumn(column), x);
    }

    public void updateInt(int rowIdx, int colIdx, int x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateInt(colIdx, x);
    }

    public void updateInt(int rowIdx, String column, int x) throws SQLException {
        this.updateInt(rowIdx, this.findColumn(column), x);
    }

    public void updateLong(int rowIdx, int colIdx, long x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateLong(colIdx, x);
    }

    public void updateLong(int rowIdx, String column, long x) throws SQLException {
        this.updateLong(rowIdx, this.findColumn(column), x);
    }

    public void updateFloat(int rowIdx, int colIdx, float x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateFloat(colIdx, x);
    }

    public void updateFloat(int rowIdx, String column, float x) throws SQLException {
        this.updateFloat(rowIdx, this.findColumn(column), x);
    }

    public void updateDouble(int rowIdx, int colIdx, double x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateDouble(colIdx, x);
    }

    public void updateDouble(int rowIdx, String column, double x) throws SQLException {
        this.updateDouble(rowIdx, this.findColumn(column), x);
    }

    public void updateBigDecimal(int rowIdx, int colIdx, BigDecimal x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBigDecimal(colIdx, x);
    }

    public void updateBigDecimal(int rowIdx, String column, BigDecimal x) throws SQLException {
        this.updateBigDecimal(rowIdx, this.findColumn(column), x);
    }

    public void updateString(int rowIdx, int colIdx, String x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateString(colIdx, x);
    }

    public void updateString(int rowIdx, String column, String x) throws SQLException {
        this.updateString(rowIdx, this.findColumn(column), x);
    }

    public void updateBytes(int rowIdx, int colIdx, byte[] x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBytes(colIdx, x);
    }

    public void updateBytes(int rowIdx, String column, byte[] x) throws SQLException {
        this.updateBytes(rowIdx, this.findColumn(column), x);
    }

    public void updateDate(int rowIdx, int colIdx, Date x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateDate(colIdx, x);
    }

    public void updateDate(int rowIdx, String column, Date x) throws SQLException {
        this.updateDate(rowIdx, this.findColumn(column), x);
    }

    public void updateTime(int rowIdx, int colIdx, Time x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateTime(colIdx, x);
    }

    public void updateTime(int rowIdx, String column, Time x) throws SQLException {
        this.updateTime(rowIdx, this.findColumn(column), x);
    }

    public void updateTimestamp(int rowIdx, int colIdx, Timestamp x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateTimestamp(colIdx, x);
    }

    public void updateTimestamp(int rowIdx, String column, Timestamp x) throws SQLException {
        this.updateTimestamp(rowIdx, this.findColumn(column), x);
    }

    public void updateAsciiStream(int rowIdx, int colIdx, InputStream x, int length) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateAsciiStream(colIdx, x, length);
    }

    public void updateAsciiStream(int rowIdx, String column, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(rowIdx, this.findColumn(column), x, length);
    }

    public void updateBinaryStream(int rowIdx, int colIdx, InputStream x, int length) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBinaryStream(colIdx, x, length);
    }

    public void updateBinaryStream(int rowIdx, String column, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(rowIdx, this.findColumn(column), x, length);
    }

    public void updateCharacterStream(int rowIdx, int colIdx, Reader x, int length) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateCharacterStream(colIdx, x, length);
    }

    public void updateCharacterStream(int rowIdx, String column, Reader x, int length) throws SQLException {
        this.updateCharacterStream(rowIdx, this.findColumn(column), x, length);
    }

    public void updateObject(int rowIdx, int colIdx, Object x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateObject(int, int, Object) entered");
            this.trace.writeTrace(logger, 2, " totalRowCount: " + rowIdx);
            this.trace.writeTrace(logger, 2, " colIdx: " + colIdx);
            this.trace.writeTrace(logger, 2, " colVector: " + this.colVector);
            this.trace.writeTrace(logger, 2, " insertRowVector: " + this.insertRowVector);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateObject(colIdx, x);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   updateObject() colVector: " + this.colVector);
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateObject() exited");
        }
    }

    public void updateObject(int rowIdx, String column, Object x) throws SQLException {
        this.updateObject(rowIdx, this.findColumn(column), x);
    }

    public void updateIfxObject(int rowIdx, int colIdx, Object x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateIfxObject(colIdx, x);
    }

    public void updateIfxObject(int rowIdx, String column, Object x) throws SQLException {
        this.updateIfxObject(rowIdx, this.findColumn(column), x);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateNull(int) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateBoolean(int, boolean) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateByte(int, byte) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateShort(int, short) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateString(int, String) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateLong(int, String) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateFloat(int, Float) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateDouble(int, double) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateBigDecimal(int, BigDecimal) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateString(int, String) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateBytes(int, byte[]) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateDate(int, Date) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateTime(int, Time) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateTimestamp(int, TimeStamp) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateAsciiStream(int, InputStream, length) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateBinaryStream(int, InputStream, length) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateCharacterStream(int, Reader, length) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateObject(int, Object, scale) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet.updateObject(int, Object) called");
            this.trace.writeTrace(logger, 1, "    totalRowCount: " + this.totalRowCount);
            this.trace.writeTrace(logger, 1, "    curRowID: " + this.curRowID);
            this.trace.writeTrace(logger, 1, "    colVector: " + this.colVector);
        }
        super.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public String getCursorName() throws SQLException {
        return "ClientResultCurs";
    }

    protected void setInsertMode(boolean value) {
        this.insertMode = value;
    }

    protected boolean getInsertMode() {
        return this.insertMode;
    }

    @Override
    public void close() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxClientResultSet:close() called");
        }
        this.isClosed = true;
        if (this.rowVector != null) {
            for (int i = 0; i < this.totalRowCount; ++i) {
                Vector<IfxObject> tmpVector = this.rowVector.elementAt(i);
                tmpVector.removeAllElements();
            }
            this.rowVector.removeAllElements();
            this.rowVector = null;
        }
        this.insertMode = false;
        this.insertRowVector = null;
        this.colVector = null;
        super.close();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getURL(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getURL(int)", this.conn);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateRef(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRef(int)", this.conn);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateRef(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRef(String)", this.conn);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBlob(int, Blob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(int, Blob)", this.conn);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBlob(String, Blob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(String, Blob)", this.conn);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateClob(int, Clob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(int, Clob)", this.conn);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateClob(String, Clob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(String, Clob)", this.conn);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateArray(int, Array)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateArray(int, Array)", this.conn);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateArray(String, Array)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateArray(String, Array)", this.conn);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getHoldability() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getHoldability()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getHoldability()", this.conn);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getNClob(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getNClob(int)", this.conn);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getNClob(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getNClob(String)", this.conn);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getRowId(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getRowId(int)", this.conn);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getRowId(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getRowId(String)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getSQLXML(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getSQLXML(int)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:getSQLXML(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getSQLXML(String)", this.conn);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateAsciiStream(int , InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateAsciiStream(int , InputStream)", this.conn);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateAsciiStream(String ,InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateAsciiStream(String ,InputStream)", this.conn);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateAsciiStream(int, InputStream, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateAsciiStream(int, InputStream, long)", this.conn);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateAsciiStream(String , InputStream , long )not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateAsciiStream(String ,InputStream ,long)", this.conn);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBinaryStream(int, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBinaryStream(int, InputStream)", this.conn);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBinaryStream(String, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBinaryStream(String, InputStream)", this.conn);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBinaryStream(int,InputStream ,long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBinaryStream(int ,InputStream ,long)", this.conn);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBinaryStream(String , InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBinaryStream(String, InputStream , long)", this.conn);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBlob(int, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(int, InputStream)", this.conn);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBlob(String, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(String, InputStream)", this.conn);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBlob(int , InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(int , InputStream , long)", this.conn);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateBlob(String, InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(String, InputStream , long)", this.conn);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateCharacterStream(int ,Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateCharacterStream(int , Reader)", this.conn);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateCharacterStream(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateCharacterStream(String, Reader)", this.conn);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateCharacterStream(int ,Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateCharacterStream(int, Reader, long)", this.conn);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateCharacterStream(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateCharacterStream(String, Reader, long)", this.conn);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateClob(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(int, Reader)", this.conn);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateClob(String , Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(String, Reader)", this.conn);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateClob(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(int, Reader)", this.conn);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateClob(String , Reader , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(String , Reader, long)", this.conn);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNCharacterStream(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNCharacterStream(int, Reader)", this.conn);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNCharacterStream(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNCharacterStream(String, Reader)", this.conn);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNCharacterStream(int, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNCharacterStream(int, Reader, long)", this.conn);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNCharacterStream(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNCharacterStream(String, Reader, long)", this.conn);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNClob(int, NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNClob(int, NClob)", this.conn);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNClob(String, NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNClob(String, NClob)", this.conn);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNClob(int, NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNClob(int, NClob)", this.conn);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNClob(String , Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNClob(String, Reader)", this.conn);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNClob(int ,Reader,long )not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNClob(int,Reader,long )", this.conn);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNClob(String , Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNClob(String, Reader, long)", this.conn);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNString(int ,String )not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNString(int ,String)", this.conn);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateNString(String,String )not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateNString(String,String)", this.conn);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateRowId(int, RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRowId(int, RowId)", this.conn);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateRowId(String , RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRowId(String , RowId)", this.conn);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateSQLXML(int, SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateSQLXML(int, SQLXML)", this.conn);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxClientResultSet:updateSQLXML(String, SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateSQLXML(String, SQLXML)", this.conn);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw IfxErrMsg.getSQLException(-80053, this.conn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getObject(int, Class<T>)", this.conn);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getObject(String, Class<T>)", this.conn);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.uppercaseStrings ? super.getString(columnIndex).toUpperCase() : super.getString(columnIndex);
    }
}

