/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.crypto.IfxCryptoUtils;

class IfxGssMsgHdr {
    int MsgType;
    int MsgSize;
    public static final int GSS_CSM_HDR_TYPESIZE = 4;
    public static final int GSS_CSM_HDR_SIZESIZE = 4;
    public static final int GSS_CSM_HDRSIZE = 8;

    public IfxGssMsgHdr() {
    }

    public IfxGssMsgHdr(int msgType, int msgSize) {
        this.MsgType = msgType;
        this.MsgSize = msgSize;
    }

    int getType() {
        return this.MsgType;
    }

    int getMsgSize() {
        return this.MsgSize;
    }

    void setMsgHdr(byte[] b) {
        this.MsgType = IfxCryptoUtils.Ifx2ToJavaInt(b, 0);
        this.MsgSize = IfxCryptoUtils.Ifx2ToJavaInt(b, 4);
    }

    void setMsgHdr(int msgType, int msgSize) {
        this.setMsgType(msgType);
        this.setMsgSize(msgSize);
    }

    void setMsgType(int msgType) {
        this.MsgType = msgType;
    }

    void setMsgSize(int msgSize) {
        this.MsgSize = msgSize;
    }

    byte[] getCMsgHdr() {
        byte[] ret = new byte[8];
        System.arraycopy(this.getCMsgType(), 0, ret, 0, 4);
        System.arraycopy(this.getCMsgSize(), 0, ret, 4, 4);
        return ret;
    }

    byte[] getCMsgType() {
        return IfxCryptoUtils.JavaToIfx2Int(this.MsgType, 4);
    }

    byte[] getCMsgSize() {
        return IfxCryptoUtils.JavaToIfx2Int(this.MsgSize, 4);
    }
}

