/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.context.impl;

import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.JobContext;

public class JobContextImpl
implements JobContext {
    private static final String sourceClass = JobContextImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private BatchStatus batchStatus = null;
    private String exitStatus = null;
    private Object transientUserData = null;
    private ModelNavigator<JSLJob> navigator = null;
    private String id;
    private Properties properties = new Properties();
    private long executionId;
    private long instanceId;
    protected String restartOn;

    public ModelNavigator<JSLJob> getNavigator() {
        return this.navigator;
    }

    public JobContextImpl(ModelNavigator<JSLJob> navigator, JSLProperties jslProperties) {
        this.navigator = navigator;
        this.id = navigator.getRootModelElement().getId();
        this.batchStatus = BatchStatus.STARTING;
        this.properties = this.convertJSProperties(jslProperties);
    }

    private Properties convertJSProperties(JSLProperties jslProperties) {
        Properties jobProperties = new Properties();
        if (jslProperties != null) {
            for (Property property : jslProperties.getPropertyList()) {
                jobProperties.setProperty(property.getName(), property.getValue());
            }
        }
        return jobProperties;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        logger.fine("Setting exitStatus = " + exitStatus);
        this.exitStatus = exitStatus;
    }

    public String getJobName() {
        return this.id;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public Object getTransientUserData() {
        return this.transientUserData;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public void setRestartOn(String restartOn) {
        logger.fine("Setting restartOn = " + restartOn);
        this.restartOn = restartOn;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("batchStatus = " + this.batchStatus);
        buf.append(" , exitStatus = " + this.exitStatus);
        buf.append(" , id = " + this.id);
        buf.append(" , executionId = " + this.executionId);
        buf.append(" , instanceId = " + this.instanceId);
        buf.append(" , restartOn = " + this.restartOn);
        return buf.toString();
    }
}

