/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.utils;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.Serializable;

public class ArrayUtils
implements Serializable {
    private static final long serialVersionUID = -6185850803487454927L;

    public static boolean isArrayOfNumbers(JsonNode arr) {
        boolean result = false;
        if (arr.isArray()) {
            JsonNode cell;
            ArrayNode array = (ArrayNode)arr;
            int i = 0;
            for (i = 0; i < array.size() && (cell = array.get(i)).isNumber(); ++i) {
            }
            if (i == array.size()) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isArrayOfStrings(JsonNode arr) {
        boolean result = false;
        if (arr.isArray()) {
            JsonNode cell;
            ArrayNode array = (ArrayNode)arr;
            int i = 0;
            for (i = 0; i < array.size() && (cell = array.get(i)).isTextual(); ++i) {
            }
            if (i == array.size()) {
                result = true;
            }
        }
        return result;
    }

    public static boolean compare(JsonNode left, JsonNode right) throws EvaluateRuntimeException {
        boolean result = false;
        if (left.isTextual() && right.isTextual()) {
            result = left.asText().compareTo(right.asText()) > 0;
        } else {
            ValueNode a = NumberUtils.convertNumberToValueNode(left.asText());
            ValueNode b = NumberUtils.convertNumberToValueNode(right.asText());
            result = new Double(a.doubleValue()).compareTo(new Double(b.doubleValue())) > 0;
        }
        return result;
    }

    public static ArrayNode ensureArray(JsonNode n) {
        if (n == null) {
            return JsonNodeFactory.instance.arrayNode();
        }
        if (n.isNull()) {
            return JsonNodeFactory.instance.arrayNode().add((JsonNode)((NullNode)null));
        }
        if (n.getNodeType() == JsonNodeType.ARRAY) {
            return (ArrayNode)n;
        }
        return JsonNodeFactory.instance.arrayNode().add(n);
    }

    public static ArrayNode push(ArrayNode left, JsonNode right) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        if (left != null && right != null && left.isArray()) {
            int i;
            for (i = 0; i < left.size(); ++i) {
                result.add(left.get(i));
            }
            if (right.isArray()) {
                for (i = 0; i < right.size(); ++i) {
                    result.add(right.get(i));
                }
            } else {
                result.add(right);
            }
        }
        return result;
    }

    public static ArrayNode slice(ArrayNode array, int start, int end) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        if (array != null && array.isArray() && start < end && end < array.size()) {
            for (int i = start; i < end; ++i) {
                result.add(array.get(i));
            }
        }
        return result;
    }

    public static ArrayNode slice(ArrayNode array, int start) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        if (array != null && array.isArray() && start < array.size()) {
            for (int i = start; i < array.size(); ++i) {
                result.add(array.get(i));
            }
        }
        return result;
    }
}

