/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.iotf.devicemgmt.DeviceAction;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ConcreteDeviceAction
implements DeviceAction {
    public static final String DEVICE_ACTION_STATUS_UPDATE = "ListenerStatusUpdate";
    private DeviceAction.Status status;
    private String message;
    private String typeId;
    private String deviceId;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ConcreteDeviceAction(String typeId, String deviceId) {
        this.typeId = typeId;
        this.deviceId = deviceId;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public void setStatus(DeviceAction.Status status) {
        this.status = status;
        this.fireEvent(DEVICE_ACTION_STATUS_UPDATE);
    }

    @Override
    public void setStatus(DeviceAction.Status status, String message) {
        this.status = status;
        this.message = message;
        this.fireEvent(DEVICE_ACTION_STATUS_UPDATE);
    }

    public String getMessage() {
        return this.message;
    }

    public void fireEvent(String event) {
        this.pcs.firePropertyChange(event, null, this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(DEVICE_ACTION_STATUS_UPDATE, listener);
    }

    public synchronized void clearListener() {
        PropertyChangeListener[] listener = this.pcs.getPropertyChangeListeners(DEVICE_ACTION_STATUS_UPDATE);
        for (int i = 0; i < listener.length; ++i) {
            this.pcs.removePropertyChangeListener(listener[i]);
        }
    }

    public JsonObject toJsonObject() {
        JsonObject o = new JsonObject();
        o.add("rc", (JsonElement)new JsonPrimitive((Number)this.status.get()));
        if (this.message != null) {
            o.add("message", (JsonElement)new JsonPrimitive(this.message));
        }
        return o;
    }

    public String toString() {
        return this.toJsonObject().toString();
    }

    public int getStatus() {
        return this.status.get();
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }
}

