/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.gateway;

import com.ibm.internal.iotf.devicemgmt.DMAgentTopic;

public class GatewayDMAgentTopic
implements DMAgentTopic {
    private static String STARTING = "iotdevice-1";
    private static String TYPE = "type";
    private static String ID = "id";
    private String deviceType;
    private String deviceId;
    private String topicStarter;

    public GatewayDMAgentTopic(String deviceType, String deviceId) {
        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.topicStarter = STARTING + '/' + TYPE + '/' + this.deviceType + '/' + ID + '/' + this.deviceId + '/';
    }

    @Override
    public String getManageTopic() {
        return this.topicStarter + Topic.MANAGE.getName();
    }

    @Override
    public String getUpdateLocationTopic() {
        return this.topicStarter + Topic.UPDATE_LOCATION.getName();
    }

    @Override
    public String getClearDiagErrorCodesTopic() {
        return this.topicStarter + Topic.CLEAR_DIAG_ERRCODES.getName();
    }

    @Override
    public String getClearDiagLogsTopic() {
        return this.topicStarter + Topic.CLEAR_DIAG_LOG.getName();
    }

    @Override
    public String getAddErrorCodesTopic() {
        return this.topicStarter + Topic.CREATE_DIAG_ERRCODES.getName();
    }

    @Override
    public String getAddDiagLogTopic() {
        return this.topicStarter + Topic.ADD_DIAG_LOG.getName();
    }

    @Override
    public String getUnmanageTopic() {
        return this.topicStarter + Topic.UNMANAGE.getName();
    }

    @Override
    public String getDMServerTopic() {
        return this.topicStarter + Topic.RESPONSE.getName();
    }

    @Override
    public String getNotifyTopic() {
        return this.topicStarter + Topic.NOTIFY.getName();
    }

    static enum Topic {
        MANAGE("mgmt/manage"),
        UNMANAGE("mgmt/unmanage"),
        UPDATE_LOCATION("device/update/location"),
        CREATE_DIAG_ERRCODES("add/diag/errorCodes"),
        CLEAR_DIAG_ERRCODES("clear/diag/errorCodes"),
        ADD_DIAG_LOG("add/diag/log"),
        CLEAR_DIAG_LOG("clear/diag/log"),
        NOTIFY("notify"),
        RESPONSE("response");

        private final String name;

        private Topic(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

