/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.gateway;

import com.ibm.internal.iotf.devicemgmt.DMServerTopic;

public class GatewayDMServerTopic
implements DMServerTopic {
    private static String STARTING = "iotdm-1";
    private static String TYPE = "type";
    private static String ID = "id";
    private String deviceType;
    private String deviceId;
    private String topicStarter;

    public GatewayDMServerTopic(String deviceType, String deviceId) {
        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.topicStarter = STARTING + '/' + TYPE + '/' + this.deviceType + '/' + ID + '/' + this.deviceId + '/';
    }

    @Override
    public String getDMServerTopic() {
        return this.topicStarter + ServerTopic.RESPONSE.getName();
    }

    @Override
    public String getDeviceUpdateTopic() {
        return this.topicStarter + ServerTopic.DEVICE_UPDATE.getName();
    }

    @Override
    public String getObserveTopic() {
        return this.topicStarter + ServerTopic.OBSERVE.getName();
    }

    @Override
    public String getCancelTopic() {
        return this.topicStarter + ServerTopic.CANCEL.getName();
    }

    @Override
    public String getInitiateRebootTopic() {
        return this.topicStarter + ServerTopic.INITIATE_REBOOT.getName();
    }

    @Override
    public String getInitiateFactoryReset() {
        return this.topicStarter + ServerTopic.INITIATE_FACTORY_RESET.getName();
    }

    @Override
    public String getInitiateFirmwareDownload() {
        return this.topicStarter + ServerTopic.INITIATE_FIRMWARE_DOWNLOAD.getName();
    }

    @Override
    public String getInitiateFirmwareUpdate() {
        return this.topicStarter + ServerTopic.INITIATE_FIRMWARE_UPDATE.getName();
    }

    static enum ServerTopic {
        RESPONSE("response"),
        OBSERVE("observe"),
        CANCEL("cancel"),
        INITIATE_REBOOT("mgmt/initiate/device/reboot"),
        INITIATE_FACTORY_RESET("mgmt/initiate/device/factory_reset"),
        INITIATE_FIRMWARE_DOWNLOAD("mgmt/initiate/firmware/download"),
        INITIATE_FIRMWARE_UPDATE("mgmt/initiate/firmware/update"),
        DEVICE_UPDATE("device/update");

        private final String name;

        private ServerTopic(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ServerTopic get(String topic) {
            switch (topic) {
                case "response": {
                    return RESPONSE;
                }
                case "observe": {
                    return OBSERVE;
                }
                case "cancel": {
                    return CANCEL;
                }
                case "mgmt/initiate/device/reboot": {
                    return INITIATE_REBOOT;
                }
                case "mgmt/initiate/device/factory_reset": {
                    return INITIATE_FACTORY_RESET;
                }
                case "mgmt/initiate/firmware/download": {
                    return INITIATE_FIRMWARE_DOWNLOAD;
                }
                case "mgmt/initiate/firmware/update": {
                    return INITIATE_FIRMWARE_UPDATE;
                }
                case "device/update": {
                    return DEVICE_UPDATE;
                }
            }
            return null;
        }
    }
}

