/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.handler;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.internal.iotf.devicemgmt.DMAgentTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.handler.CancelRequestHandler;
import com.ibm.internal.iotf.devicemgmt.handler.DeviceUpdateRequestHandler;
import com.ibm.internal.iotf.devicemgmt.handler.FactoryResetRequestHandler;
import com.ibm.internal.iotf.devicemgmt.handler.FirmwareDownloadRequestHandler;
import com.ibm.internal.iotf.devicemgmt.handler.FirmwareUpdateRequestHandler;
import com.ibm.internal.iotf.devicemgmt.handler.ObserveRequestHandler;
import com.ibm.internal.iotf.devicemgmt.handler.RebootRequestHandler;
import com.ibm.iotf.util.LoggerUtility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public abstract class DMRequestHandler
implements IMqttMessageListener {
    protected static final String CLASS_NAME = DMRequestHandler.class.getName();
    private ManagedClient dmClient = null;
    private static Map<ManagedClient, DeviceUpdateRequestHandler> deviceUpdateHandlers = new HashMap<ManagedClient, DeviceUpdateRequestHandler>();
    private static Map<ManagedClient, ObserveRequestHandler> observeHandlers = new HashMap<ManagedClient, ObserveRequestHandler>();
    private static Map<ManagedClient, CancelRequestHandler> cancelHandlers = new HashMap<ManagedClient, CancelRequestHandler>();
    private static Map<ManagedClient, RebootRequestHandler> rebootHandlers = new HashMap<ManagedClient, RebootRequestHandler>();
    private static Map<ManagedClient, FactoryResetRequestHandler> resetHandlers = new HashMap<ManagedClient, FactoryResetRequestHandler>();
    private static Map<ManagedClient, FirmwareDownloadRequestHandler> fwDownloadHandlers = new HashMap<ManagedClient, FirmwareDownloadRequestHandler>();
    private static Map<ManagedClient, FirmwareUpdateRequestHandler> fwUpdateHandlers = new HashMap<ManagedClient, FirmwareUpdateRequestHandler>();

    protected abstract String getTopic();

    protected abstract void handleRequest(JsonObject var1);

    public void messageArrived(String topic, MqttMessage message) {
        String METHOD = "messageArrived";
        try {
            String payload = new String(message.getPayload(), "UTF-8");
            JsonObject jsonRequest = new JsonParser().parse(payload).getAsJsonObject();
            LoggerUtility.fine(CLASS_NAME, "messageArrived", System.identityHashCode(this) + "Handler(" + this.getClass().getName() + ") Received request on topic " + topic + ") " + jsonRequest.toString());
            this.handleRequest(jsonRequest);
        }
        catch (Exception e) {
            LoggerUtility.severe(CLASS_NAME, "messageArrived", "Unexpected Exception = " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected ManagedClient getDMClient() {
        return this.dmClient;
    }

    protected void setDMClient(ManagedClient client) {
        this.dmClient = client;
    }

    protected ObserveRequestHandler getObserveRequestHandler(ManagedClient dmClient) {
        return observeHandlers.get(dmClient);
    }

    protected void respond(JsonObject payload) {
        String METHOD = "respond";
        try {
            DMAgentTopic topic = this.dmClient.getDMAgentTopic();
            this.dmClient.publish(topic.getDMServerTopic(), payload, 1);
        }
        catch (MqttException e) {
            LoggerUtility.severe(CLASS_NAME, "respond", "Unexpected Mqtt Exception, code = " + e.getReasonCode());
        }
    }

    protected void notify(JsonObject payload) {
        String METHOD = "notify";
        try {
            DMAgentTopic topic = this.dmClient.getDMAgentTopic();
            this.dmClient.publish(topic.getNotifyTopic(), payload, 1);
        }
        catch (MqttException e) {
            LoggerUtility.severe(CLASS_NAME, "notify", "Unexpected Mqtt Exception, code = " + e.getReasonCode());
        }
    }

    public static void setRequestHandlers(ManagedClient dmClient) throws MqttException {
        FirmwareUpdateRequestHandler fwUpdate;
        FirmwareDownloadRequestHandler fwDownload;
        FactoryResetRequestHandler reset;
        RebootRequestHandler reboot;
        CancelRequestHandler cancel;
        ObserveRequestHandler observe;
        String[] topics = new String[7];
        IMqttMessageListener[] listener = new IMqttMessageListener[7];
        int index = 0;
        DeviceUpdateRequestHandler device = deviceUpdateHandlers.get(dmClient);
        if (device == null) {
            device = new DeviceUpdateRequestHandler(dmClient);
            topics[index] = device.getTopic();
            listener[index++] = device;
            deviceUpdateHandlers.put(dmClient, device);
        }
        if ((observe = observeHandlers.get(dmClient)) == null) {
            observe = new ObserveRequestHandler(dmClient);
            topics[index] = observe.getTopic();
            listener[index++] = observe;
            observeHandlers.put(dmClient, observe);
        }
        if ((cancel = cancelHandlers.get(dmClient)) == null) {
            cancel = new CancelRequestHandler(dmClient);
            topics[index] = cancel.getTopic();
            listener[index++] = cancel;
            cancelHandlers.put(dmClient, cancel);
        }
        if ((reboot = rebootHandlers.get(dmClient)) == null) {
            reboot = new RebootRequestHandler(dmClient);
            topics[index] = reboot.getTopic();
            listener[index++] = reboot;
            rebootHandlers.put(dmClient, reboot);
        }
        if ((reset = resetHandlers.get(dmClient)) == null) {
            reset = new FactoryResetRequestHandler(dmClient);
            topics[index] = reset.getTopic();
            listener[index++] = reset;
            resetHandlers.put(dmClient, reset);
        }
        if ((fwDownload = fwDownloadHandlers.get(dmClient)) == null) {
            fwDownload = new FirmwareDownloadRequestHandler(dmClient);
            topics[index] = fwDownload.getTopic();
            listener[index++] = fwDownload;
            fwDownloadHandlers.put(dmClient, fwDownload);
        }
        if ((fwUpdate = fwUpdateHandlers.get(dmClient)) == null) {
            fwUpdate = new FirmwareUpdateRequestHandler(dmClient);
            topics[index] = fwUpdate.getTopic();
            listener[index++] = fwUpdate;
            fwUpdateHandlers.put(dmClient, fwUpdate);
        }
        if (index > 0) {
            String[] filters = Arrays.copyOf(topics, index);
            IMqttMessageListener[] listeners = Arrays.copyOf(listener, index);
            int[] qos = new int[index];
            Arrays.fill(qos, 1);
            dmClient.subscribe(filters, qos, listeners);
        }
    }

    public static void clearRequestHandlers(ManagedClient dmClient) throws MqttException {
        FirmwareUpdateRequestHandler fwUpdate;
        FirmwareDownloadRequestHandler fwDownload;
        FactoryResetRequestHandler reset;
        RebootRequestHandler reboot;
        CancelRequestHandler cancel;
        ObserveRequestHandler observe;
        String[] topics = new String[7];
        int index = 0;
        DeviceUpdateRequestHandler device = deviceUpdateHandlers.remove(dmClient);
        if (device != null) {
            topics[index++] = device.getTopic();
        }
        if ((observe = observeHandlers.remove(dmClient)) != null) {
            topics[index++] = observe.getTopic();
        }
        if ((cancel = cancelHandlers.remove(dmClient)) != null) {
            topics[index++] = cancel.getTopic();
        }
        if ((reboot = rebootHandlers.remove(dmClient)) != null) {
            topics[index++] = reboot.getTopic();
        }
        if ((reset = resetHandlers.remove(dmClient)) != null) {
            topics[index++] = reset.getTopic();
        }
        if ((fwDownload = fwDownloadHandlers.remove(dmClient)) != null) {
            topics[index++] = fwDownload.getTopic();
        }
        if ((fwUpdate = fwUpdateHandlers.remove(dmClient)) != null) {
            topics[index++] = fwUpdate.getTopic();
        }
        if (index > 0) {
            String[] filters = Arrays.copyOf(topics, index);
            dmClient.unsubscribe(filters);
        }
    }
}

