/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.devicemgmt.resource.Resource;
import com.ibm.iotf.util.LoggerUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

public class DeviceUpdateRequestHandler
extends DMRequestHandler {
    private static final String CLASS_NAME = DeviceUpdateRequestHandler.class.getName();
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public DeviceUpdateRequestHandler(ManagedClient dmClient) {
        this.setDMClient(dmClient);
    }

    @Override
    protected String getTopic() {
        DMServerTopic topic = this.getDMClient().getDMServerTopic();
        return topic.getDeviceUpdateTopic();
    }

    @Override
    public void handleRequest(JsonObject jsonRequest) {
        JsonArray fields;
        String METHOD = "handleRequest";
        ArrayList<Resource> fireRequiredResources = new ArrayList<Resource>();
        ResponseCode rc = ResponseCode.DM_UPDATE_SUCCESS;
        JsonObject response = new JsonObject();
        JsonObject d = (JsonObject)jsonRequest.get("d");
        if (d != null && (fields = (JsonArray)d.get("fields")) != null) {
            JsonArray resFields = new JsonArray();
            for (int i = 0; i < fields.size(); ++i) {
                boolean success;
                String key;
                block6: {
                    JsonObject obj = (JsonObject)fields.get(i);
                    if (obj.get("field") == null) continue;
                    key = obj.get("field").getAsString();
                    JsonObject value = (JsonObject)obj.get("value");
                    success = false;
                    try {
                        Resource resource = this.getDMClient().getDeviceData().getResource(key);
                        if (resource != null) {
                            success = this.updateField(resource, value);
                            fireRequiredResources.add(resource);
                        }
                    }
                    catch (Exception e) {
                        LoggerUtility.log(Level.SEVERE, CLASS_NAME, "handleRequest", "Exception in updating field " + key + " value " + value, e);
                        if (e.getMessage() == null) break block6;
                        response.add("message", (JsonElement)new JsonPrimitive(e.getMessage()));
                    }
                }
                if (success) continue;
                resFields.add((JsonElement)new JsonPrimitive(key));
                rc = ResponseCode.DM_NOT_FOUND;
            }
            if (resFields.size() != 0) {
                JsonObject json = new JsonObject();
                json.add("fields", (JsonElement)resFields);
                response.add("d", (JsonElement)json);
            }
        }
        response.add("rc", (JsonElement)new JsonPrimitive((Number)rc.getCode()));
        response.add("reqId", jsonRequest.get("reqId"));
        this.respond(response);
        Task task = new Task(fireRequiredResources);
        executor.execute(task);
    }

    private boolean updateField(Resource resource, JsonObject value) {
        if (resource != null) {
            resource.update((JsonElement)value, false);
            return true;
        }
        return false;
    }

    private class Task
    implements Runnable {
        private List<Resource> fireRequiredResources;

        private Task(List<Resource> fireRequiredResources) {
            this.fireRequiredResources = fireRequiredResources;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.fireRequiredResources.size(); ++i) {
                Resource resource = this.fireRequiredResources.get(i);
                resource.notifyExternalListeners();
            }
        }
    }
}

