/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.ConcreteDeviceAction;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.devicemgmt.DeviceAction;
import com.ibm.iotf.devicemgmt.DeviceActionHandler;
import com.ibm.iotf.util.LoggerUtility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class FactoryResetRequestHandler
extends DMRequestHandler
implements PropertyChangeListener {
    private static final String REQ_ID = "reqId";
    private JsonElement reqId;

    public FactoryResetRequestHandler(ManagedClient dmClient) {
        this.setDMClient(dmClient);
    }

    @Override
    protected String getTopic() {
        DMServerTopic topic = this.getDMClient().getDMServerTopic();
        return topic.getInitiateFactoryReset();
    }

    @Override
    protected void handleRequest(JsonObject jsonRequest) {
        String METHOD = "handleRequest";
        DeviceAction action = this.getDMClient().getDeviceData().getDeviceAction();
        if (action == null || this.getDMClient().getActionHandler() == null) {
            JsonObject response = new JsonObject();
            response.add(REQ_ID, jsonRequest.get(REQ_ID));
            response.add("rc", (JsonElement)new JsonPrimitive((Number)ResponseCode.DM_FUNCTION_NOT_IMPLEMENTED.getCode()));
            this.respond(response);
        } else {
            LoggerUtility.fine(CLASS_NAME, "handleRequest", " start Factory Reset action ");
            ((ConcreteDeviceAction)action).clearListener();
            ((ConcreteDeviceAction)action).addPropertyChangeListener(this);
            this.reqId = jsonRequest.get(REQ_ID);
            DeviceActionHandler handler = this.getDMClient().getActionHandler();
            handler.handleFactoryReset(action);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ListenerStatusUpdate".equals(evt.getPropertyName())) {
            try {
                ConcreteDeviceAction action = (ConcreteDeviceAction)evt.getNewValue();
                JsonObject response = action.toJsonObject();
                response.add(REQ_ID, this.reqId);
                this.respond(response);
            }
            catch (Exception e) {
                LoggerUtility.warn(CLASS_NAME, "propertyChange", e.getMessage());
            }
        }
    }
}

