/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.devicemgmt.DeviceFirmware;
import com.ibm.iotf.util.LoggerUtility;

public class FirmwareDownloadRequestHandler
extends DMRequestHandler {
    private static final String CLASS_NAME = FirmwareDownloadRequestHandler.class.getName();

    public FirmwareDownloadRequestHandler(ManagedClient dmClient) {
        this.setDMClient(dmClient);
    }

    @Override
    protected String getTopic() {
        DMServerTopic topic = this.getDMClient().getDMServerTopic();
        return topic.getInitiateFirmwareDownload();
    }

    @Override
    public void handleRequest(JsonObject jsonRequest) {
        ResponseCode rc;
        String METHOD = "handleRequest";
        JsonObject response = new JsonObject();
        response.add("reqId", jsonRequest.get("reqId"));
        DeviceFirmware deviceFirmware = this.getDMClient().getDeviceData().getDeviceFirmware();
        if (deviceFirmware == null || this.getDMClient().getFirmwareHandler() == null) {
            rc = ResponseCode.DM_FUNCTION_NOT_IMPLEMENTED;
        } else if (deviceFirmware.getState() != DeviceFirmware.FirmwareState.IDLE.getState()) {
            rc = ResponseCode.DM_BAD_REQUEST;
        } else if (deviceFirmware.getUrl() != null) {
            LoggerUtility.fine(CLASS_NAME, "handleRequest", "fire firmware download");
            this.getDMClient().getFirmwareHandler().downloadFirmware(deviceFirmware);
            rc = ResponseCode.DM_ACCEPTED;
        } else {
            rc = ResponseCode.DM_BAD_REQUEST;
            LoggerUtility.severe(CLASS_NAME, "handleRequest", "No URL mentioned in the request");
        }
        response.add("rc", (JsonElement)new JsonPrimitive((Number)rc.getCode()));
        this.respond(response);
    }
}

