/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.devicemgmt.DeviceFirmware;
import com.ibm.iotf.util.LoggerUtility;

public class FirmwareUpdateRequestHandler
extends DMRequestHandler {
    public FirmwareUpdateRequestHandler(ManagedClient dmClient) {
        this.setDMClient(dmClient);
    }

    @Override
    protected String getTopic() {
        DMServerTopic topic = this.getDMClient().getDMServerTopic();
        return topic.getInitiateFirmwareUpdate();
    }

    @Override
    public void handleRequest(JsonObject jsonRequest) {
        ResponseCode rc;
        String METHOD = "handleRequest";
        JsonObject response = new JsonObject();
        response.add("reqId", jsonRequest.get("reqId"));
        DeviceFirmware firmware = this.getDMClient().getDeviceData().getDeviceFirmware();
        if (firmware == null || this.getDMClient().getFirmwareHandler() == null) {
            rc = ResponseCode.DM_FUNCTION_NOT_IMPLEMENTED;
        } else if (firmware.getState() == DeviceFirmware.FirmwareState.IDLE.getState()) {
            rc = ResponseCode.DM_BAD_REQUEST;
        } else if (firmware.getUrl() != null) {
            LoggerUtility.fine(CLASS_NAME, "handleRequest", "Fire Firmware update ");
            this.getDMClient().getFirmwareHandler().updateFirmware(firmware);
            rc = ResponseCode.DM_ACCEPTED;
        } else {
            rc = ResponseCode.DM_BAD_REQUEST;
            response.add("message", (JsonElement)new JsonPrimitive("The value of the firmware URL is not set or null"));
        }
        response.add("rc", (JsonElement)new JsonPrimitive((Number)rc.getCode()));
        this.respond(response);
    }
}

