/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.internal.iotf.devicemgmt.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.devicemgmt.resource.Resource;
import com.ibm.iotf.util.LoggerUtility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObserveRequestHandler
extends DMRequestHandler
implements PropertyChangeListener {
    private static final String FIELDS = "fields";
    private static final String FIELD = "field";
    private ConcurrentHashMap<String, Resource> fieldsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, JsonElement> responseMap = new ConcurrentHashMap();

    public ObserveRequestHandler(ManagedClient dmClient) {
        this.setDMClient(dmClient);
    }

    @Override
    protected String getTopic() {
        DMServerTopic topic = this.getDMClient().getDMServerTopic();
        return topic.getObserveTopic();
    }

    @Override
    protected void handleRequest(JsonObject jsonRequest) {
        JsonObject response = new JsonObject();
        JsonArray responseArray = new JsonArray();
        JsonObject d = (JsonObject)jsonRequest.get("d");
        JsonArray fields = (JsonArray)d.get(FIELDS);
        for (int i = 0; i < fields.size(); ++i) {
            JsonObject field = fields.get(i).getAsJsonObject();
            String name = field.get(FIELD).getAsString();
            JsonObject fieldResponse = new JsonObject();
            Resource resource = this.getDMClient().getDeviceData().getResource(name);
            if (resource != null) {
                resource.addPropertyChangeListener(Resource.ChangeListenerType.INTERNAL, this);
                this.fieldsMap.put(name, resource);
            }
            fieldResponse.addProperty(FIELD, name);
            JsonElement value = resource.toJsonObject();
            fieldResponse.add("value", value);
            this.responseMap.put(name, value);
            responseArray.add((JsonElement)fieldResponse);
        }
        JsonObject responseFileds = new JsonObject();
        responseFileds.add(FIELDS, (JsonElement)responseArray);
        response.add("d", (JsonElement)responseFileds);
        response.add("reqId", jsonRequest.get("reqId"));
        response.add("rc", (JsonElement)new JsonPrimitive((Number)ResponseCode.DM_SUCCESS.getCode()));
        this.respond(response);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Resource resource = this.fieldsMap.get(evt.getPropertyName());
        if (resource != null) {
            JsonObject response = new JsonObject();
            JsonObject field = new JsonObject();
            field.add(FIELD, (JsonElement)new JsonPrimitive(resource.getCanonicalName()));
            JsonElement value = resource.toJsonObject();
            JsonElement trimedValue = this.trimResponse(evt.getPropertyName(), value);
            if (null == trimedValue) {
                return;
            }
            field.add("value", trimedValue);
            JsonObject fields = new JsonObject();
            JsonArray fieldsArray = new JsonArray();
            fieldsArray.add((JsonElement)field);
            fields.add(FIELDS, (JsonElement)fieldsArray);
            response.add("d", (JsonElement)fields);
            this.notify(response);
        }
    }

    void cancel(JsonArray fields) {
        String METHOD = "cancel";
        LoggerUtility.fine(CLASS_NAME, "cancel", "Cancel observation for " + fields);
        for (int i = 0; i < fields.size(); ++i) {
            JsonObject obj = (JsonObject)fields.get(i);
            String name = obj.get(FIELD).getAsString();
            Resource resource = this.fieldsMap.remove(name);
            if (null == resource) continue;
            resource.removePropertyChangeListener(this);
            this.responseMap.remove(name);
        }
    }

    private JsonElement trimResponse(String name, JsonElement newValue) {
        JsonElement previousValue = this.responseMap.get(name);
        if (previousValue == null) {
            return null;
        }
        if (previousValue.isJsonPrimitive()) {
            if (previousValue.equals(newValue)) {
                return null;
            }
            return newValue;
        }
        boolean bModified = false;
        JsonObject response = new JsonObject();
        for (Map.Entry en : ((JsonObject)previousValue).entrySet()) {
            String key = (String)en.getKey();
            JsonElement value = (JsonElement)en.getValue();
            JsonElement otherValue = ((JsonObject)newValue).get(key);
            if (otherValue != null && otherValue.equals(value)) continue;
            response.add(key, otherValue);
            en.setValue(otherValue);
            bModified = true;
        }
        if (bModified) {
            return response;
        }
        return null;
    }
}

