/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.iotf.util.LoggerUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.util.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;

public abstract class AbstractClient {
    private static final String CLASS_NAME = AbstractClient.class.getName();
    private static final String QUICK_START = "quickstart";
    protected static final String CLIENT_ID_DELIMITER = ":";
    public static final String DEFAULT_DOMAIN = "internetofthings.ibmcloud.com";
    protected static final String MESSAGING = "messaging";
    protected static final int MQTT_PORT = 1883;
    protected static final int MQTTS_PORT = 8883;
    private volatile boolean disconnectRequested = false;
    private static final long RATE_0 = TimeUnit.SECONDS.toMillis(1L);
    private static final int THROTTLE_1 = 5;
    private static final long RATE_1 = TimeUnit.SECONDS.toMillis(10L);
    private static final int THROTTLE_2 = 10;
    private static final long RATE_2 = TimeUnit.MINUTES.toMillis(1L);
    private static final int THROTTLE_3 = 20;
    private static final long RATE_3 = TimeUnit.MINUTES.toMillis(5L);
    protected static final Gson gson = new Gson();
    protected static final DateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected Properties options;
    protected String clientId;
    protected String clientUsername;
    protected String clientPassword;
    protected int messageCount = 0;
    protected MqttAsyncClient mqttAsyncClient = null;
    protected MqttConnectOptions mqttClientOptions;
    protected MqttCallback mqttCallback;
    protected int keepAliveInterval = -1;
    protected MqttClient mqttClient = null;

    public AbstractClient(Properties options) {
        this.options = options;
    }

    protected AbstractClient(MqttAsyncClient mqttAsyncClient) {
        this.mqttAsyncClient = mqttAsyncClient;
    }

    protected AbstractClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    protected void createClient(MqttCallback callback) {
        LoggerUtility.info(CLASS_NAME, "createClient", "Org ID    = " + this.getOrgId() + "\n         Client ID    = " + this.clientId);
        this.mqttAsyncClient = null;
        this.mqttClientOptions = new MqttConnectOptions();
        this.mqttCallback = callback;
    }

    public void connect(int numberOfRetryAttempts) throws MqttException {
        String METHOD = "connect";
        if (this.mqttAsyncClient != null && this.mqttAsyncClient.isConnected()) {
            LoggerUtility.log(Level.WARNING, CLASS_NAME, "connect", "Client is already connected");
            return;
        }
        boolean tryAgain = true;
        int connectAttempts = 0;
        this.disconnectRequested = false;
        if (this.getOrgId() == QUICK_START) {
            this.configureMqtt();
        } else {
            this.configureMqtts();
        }
        while (tryAgain && !this.disconnectRequested) {
            LoggerUtility.info(CLASS_NAME, "connect", "Connecting client " + this.clientId + " to " + this.mqttAsyncClient.getServerURI() + " (attempt #" + ++connectAttempts + ")...");
            try {
                this.mqttAsyncClient.connect(this.mqttClientOptions).waitForCompletion(60000L);
            }
            catch (MqttSecurityException e) {
                System.err.println("Looks like one or more connection parameters are wrong !!!");
                LoggerUtility.log(Level.SEVERE, CLASS_NAME, "connect", "Connecting to Watson IoT Platform failed - one or more connection parameters are wrong !!!", e);
                throw e;
            }
            catch (MqttException e) {
                if (connectAttempts > numberOfRetryAttempts) {
                    LoggerUtility.log(Level.SEVERE, CLASS_NAME, "connect", "Connecting to Watson IoT Platform failed", e);
                    throw e;
                }
                e.printStackTrace();
            }
            if (this.mqttAsyncClient.isConnected()) {
                LoggerUtility.info(CLASS_NAME, "connect", "Successfully connected to the IBM Watson IoT Platform");
                if (LoggerUtility.isLoggable(Level.FINEST)) {
                    LoggerUtility.log(Level.FINEST, CLASS_NAME, "connect", " * Connection attempts: " + connectAttempts);
                }
                tryAgain = false;
                continue;
            }
            this.waitBeforeNextConnectAttempt(connectAttempts);
        }
    }

    public void connect(boolean autoRetry) throws MqttException {
        if (!autoRetry) {
            this.connect(0);
        } else {
            this.connect(Integer.MAX_VALUE);
        }
    }

    private void configureMqtt() {
        String serverURI = "tcp://" + this.getOrgId() + "." + MESSAGING + "." + this.getDomain() + CLIENT_ID_DELIMITER + 1883;
        try {
            this.mqttAsyncClient = new MqttAsyncClient(serverURI, this.clientId, null);
            this.mqttAsyncClient.setCallback(this.mqttCallback);
            this.mqttClientOptions = new MqttConnectOptions();
            this.mqttClientOptions.setCleanSession(this.isCleanSession());
            if (this.keepAliveInterval != -1) {
                this.mqttClientOptions.setKeepAliveInterval(this.keepAliveInterval);
            }
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    private void configureMqtts() {
        String METHOD = "configureMqtts";
        String serverURI = "ssl://" + this.getOrgId() + "." + MESSAGING + "." + this.getDomain() + CLIENT_ID_DELIMITER + 8883;
        try {
            this.mqttAsyncClient = new MqttAsyncClient(serverURI, this.clientId, null);
            this.mqttAsyncClient.setCallback(this.mqttCallback);
            this.mqttClientOptions = new MqttConnectOptions();
            this.mqttClientOptions.setUserName(this.clientUsername);
            this.mqttClientOptions.setPassword(this.clientPassword.toCharArray());
            this.mqttClientOptions.setCleanSession(this.isCleanSession());
            if (this.keepAliveInterval != -1) {
                this.mqttClientOptions.setKeepAliveInterval(this.keepAliveInterval);
            }
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            this.mqttClientOptions.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
        }
        catch (GeneralSecurityException | MqttException e) {
            LoggerUtility.warn(CLASS_NAME, "configureMqtts", "Unable to configure TLSv1.2 connection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    private boolean isCleanSession() {
        boolean enabled = true;
        String value = this.options.getProperty("Clean-Session");
        if (value == null) {
            value = this.options.getProperty("clean-session");
        }
        if (value != null) {
            enabled = Boolean.parseBoolean(AbstractClient.trimedValue(value));
        }
        return enabled;
    }

    private void waitBeforeNextConnectAttempt(int attempts) {
        String METHOD = "waitBeforeNextConnectAttempt";
        if (attempts == 20) {
            LoggerUtility.warn(CLASS_NAME, "waitBeforeNextConnectAttempt", String.valueOf(attempts) + " consecutive failed attempts to connect.  Retry delay increased to " + String.valueOf(RATE_3) + "ms");
        } else if (attempts == 10) {
            LoggerUtility.warn(CLASS_NAME, "waitBeforeNextConnectAttempt", String.valueOf(attempts) + " consecutive failed attempts to connect.  Retry delay increased to " + String.valueOf(RATE_2) + "ms");
        } else if (attempts == 5) {
            LoggerUtility.info(CLASS_NAME, "waitBeforeNextConnectAttempt", String.valueOf(attempts) + " consecutive failed attempts to connect.  Retry delay set to " + String.valueOf(RATE_1) + "ms");
        }
        try {
            long delay = RATE_0;
            if (attempts >= 20) {
                delay = RATE_3;
            } else if (attempts >= 10) {
                delay = RATE_2;
            } else if (attempts >= 5) {
                delay = RATE_1;
            }
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        String METHOD = "disconnect";
        LoggerUtility.fine(CLASS_NAME, "disconnect", "Disconnecting from the IBM Watson IoT Platform ...");
        try {
            this.disconnectRequested = true;
            this.mqttAsyncClient.disconnect();
            LoggerUtility.info(CLASS_NAME, "disconnect", "Successfully disconnected from from the IBM Watson IoT Platform");
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        String METHOD = "isConnected";
        boolean connected = false;
        if (this.mqttAsyncClient != null) {
            connected = this.mqttAsyncClient.isConnected();
        } else if (this.mqttClient != null) {
            connected = this.mqttClient.isConnected();
        }
        LoggerUtility.log(Level.FINEST, CLASS_NAME, "isConnected", "Connected(" + connected + ")");
        return connected;
    }

    public String toString() {
        return "[" + this.clientId + "] " + this.messageCount + " messages sent - Connected = " + String.valueOf(this.isConnected());
    }

    public static Properties parsePropertiesFile(File propertiesFile) {
        Properties clientProperties = new Properties();
        try {
            FileInputStream in = new FileInputStream(propertiesFile);
            clientProperties.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return clientProperties;
        }
        catch (IOException e) {
            e.printStackTrace();
            return clientProperties;
        }
        return clientProperties;
    }

    protected String getDomain() {
        String domain = this.options.getProperty("domain");
        if (domain == null) {
            domain = this.options.getProperty("Domain");
        }
        if ((domain = AbstractClient.trimedValue(domain)) != null && !"".equals(domain)) {
            return domain;
        }
        return DEFAULT_DOMAIN;
    }

    public String getOrgId() {
        String org = this.options.getProperty("org");
        if (org == null) {
            org = this.options.getProperty("Organization-ID");
        }
        return AbstractClient.trimedValue(org);
    }

    public String getDeviceId() {
        String id = this.options.getProperty("id");
        if (id == null) {
            id = this.options.getProperty("Device-ID");
        }
        return AbstractClient.trimedValue(id);
    }

    public static String trimedValue(String value) {
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    public String getAuthMethod() {
        String method = this.options.getProperty("auth-method");
        if (method == null) {
            method = this.options.getProperty("Authentication-Method");
        }
        return AbstractClient.trimedValue(method);
    }

    public String getAuthToken() {
        String token = this.options.getProperty("auth-token");
        if (token == null) {
            token = this.options.getProperty("Authentication-Token");
        }
        return AbstractClient.trimedValue(token);
    }

    private static void validateNull(String property, String value) throws Exception {
        if (value == null || value == "") {
            throw new Exception(property + " cannot be null or empty !");
        }
    }

    protected static int publishEventsThroughHttps(String organization, String domain, String deviceType, String deviceId, String eventName, boolean device, String authKey, String authToken, Object payload) throws Exception {
        String METHOD = "publishEventsThroughHttps";
        AbstractClient.validateNull("Organization ID", organization);
        AbstractClient.validateNull("Domain", domain);
        AbstractClient.validateNull("Device Type", deviceType);
        AbstractClient.validateNull("Device ID", deviceId);
        AbstractClient.validateNull("Event Name", eventName);
        if (!QUICK_START.equalsIgnoreCase(organization)) {
            AbstractClient.validateNull("Authentication Method", authKey);
            AbstractClient.validateNull("Authentication Token", authToken);
        }
        StringBuilder sb = new StringBuilder();
        if (QUICK_START.equalsIgnoreCase(organization)) {
            sb.append("http://");
        } else {
            sb.append("https://");
        }
        sb.append(organization).append(".internetofthings.ibmcloud.com/api/v0002");
        if (device) {
            sb.append("/device");
        } else {
            sb.append("/application");
        }
        sb.append("/types/").append(deviceType).append("/devices/").append(deviceId).append("/events/").append(eventName);
        LoggerUtility.fine(CLASS_NAME, "publishEventsThroughHttps", "ReST URL::" + sb.toString());
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader(System.in));
        JsonObject message = new JsonObject();
        String timestamp = ISO8601_DATE_FORMAT.format(new Date());
        message.addProperty("ts", timestamp);
        JsonElement dataElement = gson.toJsonTree(payload);
        message.add("d", dataElement);
        StringEntity input = new StringEntity(message.toString(), StandardCharsets.UTF_8);
        HttpPost post = new HttpPost(sb.toString());
        post.setEntity((HttpEntity)input);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("Accept", "application/json");
        if (!QUICK_START.equalsIgnoreCase(organization)) {
            byte[] encoding = Base64.encodeBase64((byte[])new String(authKey + CLIENT_ID_DELIMITER + authToken).getBytes());
            String encodedString = new String(encoding);
            post.addHeader("Authorization", "Basic " + encodedString);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(sslContext).build();
            HttpResponse response = client.execute((HttpUriRequest)post);
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode >= 200 && httpCode < 300) {
                int n = httpCode;
                return n;
            }
            StringBuilder log = new StringBuilder("HTTP Code: " + httpCode);
            log.append("\nURL: ").append(sb.toString()).append("\nHeader:\n");
            Header[] headers = response.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                log.append(headers[i].getName()).append(' ').append(headers[i].getValue()).append('\n');
            }
            log.append("\nResponse \n");
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            log.append(br.readLine());
            LoggerUtility.severe(CLASS_NAME, "publishEventsThroughHttps", log.toString());
            int n = httpCode;
            return n;
        }
        catch (IOException e) {
            LoggerUtility.severe(CLASS_NAME, "publishEventsThroughHttps", e.getMessage());
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

