/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.iotf.client.app.ApplicationClient;
import com.ibm.iotf.util.LoggerUtility;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Message {
    private static final String CLASS_NAME = ApplicationClient.class.getName();
    protected static final JsonParser JSON_PARSER = new JsonParser();
    protected static final DateTimeFormatter DT_PARSER = ISODateTimeFormat.dateTimeParser();
    protected String payload;
    protected String data;
    protected DateTime timestamp;

    public Message(MqttMessage msg) throws UnsupportedEncodingException {
        this.data = null;
        this.timestamp = null;
        String METHOD = "Message(1)";
        this.payload = new String(msg.getPayload(), "UTF8");
        try {
            JsonObject payloadJson = JSON_PARSER.parse(this.payload).getAsJsonObject();
            this.data = payloadJson.has("d") ? payloadJson.get("d").getAsJsonObject().toString() : payloadJson.toString();
            if (payloadJson.has("ts")) {
                try {
                    this.timestamp = DT_PARSER.parseDateTime(payloadJson.get("ts").getAsString());
                }
                catch (IllegalArgumentException e) {
                    this.timestamp = DateTime.now();
                }
            } else {
                this.timestamp = DateTime.now();
            }
        }
        catch (JsonSyntaxException e) {
            LoggerUtility.log(Level.WARNING, CLASS_NAME, "Message(1)", "JsonSyntaxException thrown", e);
        }
        catch (JsonParseException jpe) {
            LoggerUtility.log(Level.WARNING, CLASS_NAME, "Message(1)", "JsonParseException thrown", jpe);
        }
    }

    public Message(MqttMessage msg, String format) throws UnsupportedEncodingException {
        block8: {
            this.data = null;
            this.timestamp = null;
            String METHOD = "Message(2)";
            this.payload = new String(msg.getPayload(), "UTF8");
            if (format.equalsIgnoreCase("json")) {
                try {
                    JsonObject payloadJson = JSON_PARSER.parse(this.payload).getAsJsonObject();
                    this.data = payloadJson.has("d") ? payloadJson.get("d").getAsJsonObject().toString() : payloadJson.toString();
                    if (payloadJson.has("ts")) {
                        try {
                            this.timestamp = DT_PARSER.parseDateTime(payloadJson.get("ts").getAsString());
                        }
                        catch (IllegalArgumentException e) {
                            this.timestamp = DateTime.now();
                        }
                        break block8;
                    }
                    this.timestamp = DateTime.now();
                }
                catch (JsonSyntaxException e) {
                    LoggerUtility.warn(CLASS_NAME, "Message(2)", "JsonSyntaxException thrown");
                }
                catch (JsonParseException jpe) {
                    LoggerUtility.warn(CLASS_NAME, "Message(2)", "JsonParseException thrown");
                }
            } else {
                this.data = this.payload;
                this.timestamp = DateTime.now();
            }
        }
    }

    public String getPayload() {
        return this.payload;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "[" + this.timestamp.toString() + "] " + this.data.toString();
    }
}

