/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.iotf.client.IoTFCReSTException;
import com.ibm.iotf.util.LoggerUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.net.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class APIClient {
    private static final String CLASS_NAME = APIClient.class.getName();
    private static final String BASIC_API_V0002_URL = "/api/v0002";
    private String authKey = null;
    private String authToken = null;
    private SSLContext sslContext = null;
    private String orgId = null;
    private String domain;

    public APIClient(Properties opt) throws NoSuchAlgorithmException, KeyManagementException {
        boolean isGateway = false;
        String authKeyPassed = null;
        if ("gateway".equals(APIClient.getAuthMethod(opt))) {
            isGateway = true;
        } else {
            authKeyPassed = opt.getProperty("auth-key");
            if (authKeyPassed == null) {
                authKeyPassed = opt.getProperty("API-Key");
            }
            this.authKey = APIClient.trimedValue(authKeyPassed);
        }
        String token = opt.getProperty("auth-token");
        if (token == null) {
            token = opt.getProperty("Authentication-Token");
        }
        this.authToken = APIClient.trimedValue(token);
        String org = null;
        org = opt.getProperty("org");
        if (org == null) {
            org = opt.getProperty("Organization-ID");
        }
        this.orgId = APIClient.trimedValue(org);
        this.domain = this.getDomain(opt);
        if (isGateway) {
            this.authKey = "g/" + this.orgId + '/' + this.getGWDeviceType(opt) + '/' + this.getGWDeviceId(opt);
        }
        this.sslContext = SSLContext.getInstance("TLSv1.2");
        this.sslContext.init(null, null, null);
    }

    protected String getDomain(Properties options) {
        String domain = options.getProperty("domain");
        if (domain == null) {
            domain = options.getProperty("Domain");
        }
        if ((domain = APIClient.trimedValue(domain)) != null && !"".equals(domain)) {
            return domain;
        }
        return "internetofthings.ibmcloud.com";
    }

    private static String getAuthMethod(Properties opt) {
        String method = opt.getProperty("auth-method");
        if (method == null) {
            method = opt.getProperty("Authentication-Method");
        }
        return APIClient.trimedValue(method);
    }

    protected String getGWDeviceId(Properties options) {
        String id = options.getProperty("Gateway-ID");
        if (id == null) {
            id = options.getProperty("Device-ID");
        }
        if (id == null) {
            id = options.getProperty("id");
        }
        return APIClient.trimedValue(id);
    }

    protected String getGWDeviceType(Properties options) {
        String type = options.getProperty("Gateway-Type");
        if (type == null) {
            type = options.getProperty("Device-Type");
        }
        if (type == null) {
            type = options.getProperty("type");
        }
        return APIClient.trimedValue(type);
    }

    private static String trimedValue(String value) {
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    private HttpResponse connect(String httpOperation, String url, String jsonPacket, List<NameValuePair> queryParameters) throws IoTFCReSTException, URISyntaxException, IOException {
        String METHOD = "connect";
        StringEntity input = null;
        if (jsonPacket != null) {
            input = new StringEntity(jsonPacket, StandardCharsets.UTF_8);
        }
        byte[] encoding = Base64.encodeBase64((byte[])new String(this.authKey + ":" + this.authToken).getBytes());
        String encodedString = new String(encoding);
        switch (httpOperation) {
            case "post": {
                return this.casePostFromConnect(queryParameters, url, "connect", input, encodedString);
            }
            case "put": {
                return this.casePutFromConnect(queryParameters, url, "connect", input, encodedString);
            }
            case "get": {
                return this.caseGetFromConnect(queryParameters, url, "connect", input, encodedString);
            }
            case "delete": {
                return this.caseDeleteFromConnect(queryParameters, url, "connect", input, encodedString);
            }
        }
        return null;
    }

    private HttpResponse casePostFromConnect(List<NameValuePair> queryParameters, String url, String method, StringEntity input, String encodedString) throws URISyntaxException, IOException {
        URIBuilder builder = new URIBuilder(url);
        if (queryParameters != null) {
            builder.setParameters(queryParameters);
        }
        HttpPost post = new HttpPost(builder.build());
        post.setEntity((HttpEntity)input);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("Accept", "application/json");
        post.addHeader("Authorization", "Basic " + encodedString);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(this.sslContext).build();
            return client.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            LoggerUtility.warn(CLASS_NAME, method, e.getMessage());
            throw e;
        }
    }

    private HttpResponse casePutFromConnect(List<NameValuePair> queryParameters, String url, String method, StringEntity input, String encodedString) throws URISyntaxException, IOException {
        URIBuilder putBuilder = new URIBuilder(url);
        if (queryParameters != null) {
            putBuilder.setParameters(queryParameters);
        }
        HttpPut put = new HttpPut(putBuilder.build());
        put.setEntity((HttpEntity)input);
        put.addHeader("Content-Type", "application/json");
        put.addHeader("Accept", "application/json");
        put.addHeader("Authorization", "Basic " + encodedString);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(this.sslContext).build();
            return client.execute((HttpUriRequest)put);
        }
        catch (IOException e) {
            LoggerUtility.warn(CLASS_NAME, method, e.getMessage());
            throw e;
        }
    }

    private HttpResponse caseGetFromConnect(List<NameValuePair> queryParameters, String url, String method, StringEntity input, String encodedString) throws URISyntaxException, IOException {
        URIBuilder getBuilder = new URIBuilder(url);
        if (queryParameters != null) {
            getBuilder.setParameters(queryParameters);
        }
        HttpGet get = new HttpGet(getBuilder.build());
        get.addHeader("Content-Type", "application/json");
        get.addHeader("Accept", "application/json");
        get.addHeader("Authorization", "Basic " + encodedString);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(this.sslContext).build();
            return client.execute((HttpUriRequest)get);
        }
        catch (IOException e) {
            LoggerUtility.warn(CLASS_NAME, method, e.getMessage());
            throw e;
        }
    }

    private HttpResponse caseDeleteFromConnect(List<NameValuePair> queryParameters, String url, String method, StringEntity input, String encodedString) throws URISyntaxException, IOException {
        URIBuilder deleteBuilder = new URIBuilder(url);
        if (queryParameters != null) {
            deleteBuilder.setParameters(queryParameters);
        }
        HttpDelete delete = new HttpDelete(deleteBuilder.build());
        delete.addHeader("Content-Type", "application/json");
        delete.addHeader("Accept", "application/json");
        delete.addHeader("Authorization", "Basic " + encodedString);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(this.sslContext).build();
            return client.execute((HttpUriRequest)delete);
        }
        catch (IOException e) {
            LoggerUtility.warn(CLASS_NAME, method, e.getMessage());
            throw e;
        }
    }

    private String readContent(HttpResponse response, String method) throws IllegalStateException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = null;
        try {
            line = br.readLine();
        }
        catch (IOException e) {
            LoggerUtility.warn(CLASS_NAME, method, e.getMessage());
            throw e;
        }
        LoggerUtility.fine(CLASS_NAME, method, line);
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    public boolean isDeviceExist(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "isDeviceExist";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the Device ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            return false;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "isDeviceExist");
        return false;
    }

    public JsonObject getDevice(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getDevice";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDevice");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the Device ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The device type does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getDevice");
        return null;
    }

    public JsonObject getDeviceLocation(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getDeviceLocation";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/location");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDeviceLocation");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieveing the Device Location ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device location information not found");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getDeviceLocation");
        return null;
    }

    public JsonObject updateDeviceLocation(String deviceType, String deviceId, JsonElement location) throws IoTFCReSTException {
        String METHOD = "updateDeviceLocation";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/location");
        int code = 0;
        JsonElement jsonResponse = null;
        HttpResponse response = null;
        try {
            response = this.connect("put", sb.toString(), location.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200 || code == 409) {
                String result = this.readContent(response, "updateDeviceLocation");
                jsonResponse = new JsonParser().parse(result);
                if (code == 200) {
                    return jsonResponse.getAsJsonObject();
                }
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in updating the Device Location ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device location information not found");
        }
        if (code == 409) {
            throw new IoTFCReSTException(code, "The update could not be completed due to a conflict", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "updateDeviceLocation");
        return null;
    }

    public JsonObject getDeviceManagementInformation(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getDeviceManagementInformation";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/mgmt");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDeviceManagementInformation");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieveing the Device Management Information ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device not found");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getDeviceManagementInformation");
        return null;
    }

    public JsonObject updateDevice(String deviceType, String deviceId, JsonElement propertiesToBeModified) throws IoTFCReSTException {
        String METHOD = "updateDevice";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId);
        int code = 0;
        JsonElement jsonResponse = null;
        HttpResponse response = null;
        try {
            response = this.connect("put", sb.toString(), propertiesToBeModified.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200 || code == 409) {
                String result = this.readContent(response, "updateDevice");
                jsonResponse = new JsonParser().parse(result);
                if (code == 200) {
                    return jsonResponse.getAsJsonObject();
                }
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in updating the Device ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The organization, device type or device does not exist");
        }
        if (code == 409) {
            throw new IoTFCReSTException(code, "The update could not be completed due to a conflict", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "updateDevice");
        return null;
    }

    public JsonObject getOrganizationDetails() throws IoTFCReSTException {
        String METHOD = "getOrganizationDetails";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getOrganizationDetails");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the Organization detail, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the api key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The organization does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        this.throwException(response, "getOrganizationDetails");
        return null;
    }

    public JsonObject getAllDevices(List<NameValuePair> parameters) throws IoTFCReSTException {
        String METHOD = "getDevices(1)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/bulk/devices");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDevices(1)");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the Device details, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the api key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The organization does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        this.throwException(response, "getDevices(1)");
        return null;
    }

    public JsonObject getAllDevices() throws IoTFCReSTException {
        return this.getAllDevices(null);
    }

    public JsonObject retrieveDevices(String deviceType, List<NameValuePair> parameters) throws IoTFCReSTException {
        String METHOD = "getDevices(typeID)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDevices(typeID)");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the Device details, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the api key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The organization does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        this.throwException(response, "getDevices(typeID)");
        return null;
    }

    public JsonObject retrieveDevices(String deviceType) throws IoTFCReSTException {
        return this.retrieveDevices(deviceType, null);
    }

    public JsonObject getDevicesConnectedThroughGateway(String gatewayType, String gatewayId) throws IoTFCReSTException {
        String METHOD = "getDevicesConnectedThroughGateway(typeID, deviceId)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(gatewayType).append("/devices/").append(gatewayId).append("/devices");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDevicesConnectedThroughGateway(typeID, deviceId)");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the device information that are connected through the specified gateway, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "Request is only allowed if the classId of the device type is 'Gateway'");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device type or device not found");
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        this.throwException(response, "getDevicesConnectedThroughGateway(typeID, deviceId)");
        return null;
    }

    public JsonObject getAllDeviceTypes(List<NameValuePair> parameters) throws IoTFCReSTException {
        String METHOD = "getDeviceTypes";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types");
        HttpResponse response = null;
        int code = 0;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDeviceTypes");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the DeviceType details, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the api key used does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        this.throwException(response, "getDeviceTypes");
        return null;
    }

    public JsonObject getDeviceTypes() throws IoTFCReSTException {
        return this.getAllDeviceTypes(null);
    }

    public boolean isDeviceTypeExist(String deviceType) throws IoTFCReSTException {
        String METHOD = "isDeviceTypeExist";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the Device Type ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            return false;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "isDeviceTypeExist");
        return false;
    }

    public JsonObject getDeviceType(String deviceType) throws IoTFCReSTException {
        String METHOD = "getDeviceType";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDeviceType");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the Device Type ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The device type does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getDeviceType");
        return null;
    }

    public JsonObject updateDeviceType(String deviceType, JsonElement updatedValues) throws IoTFCReSTException {
        String METHOD = "updateDeviceType";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType);
        int code = 0;
        JsonElement jsonResponse = null;
        HttpResponse response = null;
        try {
            response = this.connect("put", sb.toString(), updatedValues.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200 || code == 409) {
                String result = this.readContent(response, "updateDeviceType");
                jsonResponse = new JsonParser().parse(result);
                if (code == 200) {
                    return jsonResponse.getAsJsonObject();
                }
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in updating the Device Type ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The device type does not exist");
        }
        if (code == 409) {
            throw new IoTFCReSTException(code, "The update could not be completed due to a conflict", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "updateDeviceType");
        return null;
    }

    public JsonObject addDeviceType(JsonElement deviceType) throws IoTFCReSTException {
        String METHOD = "addDeviceType";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("post", sb.toString(), deviceType.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 201 || code == 400 || code == 409) {
                String result = this.readContent(response, "addDeviceType");
                jsonResponse = new JsonParser().parse(result);
            }
            if (code == 201) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the device Type ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 400) {
            throw new IoTFCReSTException(400, "Invalid request (No body, invalid JSON, unexpected key, bad value)", jsonResponse);
        }
        if (code == 401) {
            throw new IoTFCReSTException(401, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(403, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 409) {
            throw new IoTFCReSTException(409, "The device type already exists", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "addDeviceType");
        return null;
    }

    public JsonObject addGatewayDeviceType(JsonElement deviceType) throws IoTFCReSTException {
        if (deviceType != null && !deviceType.getAsJsonObject().has("classId")) {
            deviceType.getAsJsonObject().addProperty("classId", "Gateway");
        }
        return this.addDeviceType(deviceType);
    }

    public JsonObject addDeviceType(String id, String description, JsonElement deviceInfo, JsonElement metadata) throws IoTFCReSTException {
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types");
        JsonObject input = new JsonObject();
        if (id != null) {
            input.addProperty("id", id);
        }
        if (description != null) {
            input.addProperty("description", description);
        }
        if (deviceInfo != null) {
            input.add("deviceInfo", deviceInfo);
        }
        if (metadata != null) {
            input.add("metadata", metadata);
        }
        return this.addDeviceType((JsonElement)input);
    }

    public boolean deleteDeviceType(String typeId) throws IoTFCReSTException {
        String METHOD = "deleteDeviceType";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(typeId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Device Type ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "deleteDeviceType");
        return false;
    }

    public JsonElement getHistoricalEvents() throws IoTFCReSTException {
        return this.getHistoricalEvents(null, null, null);
    }

    public JsonElement getHistoricalEvents(List<NameValuePair> parameters) throws IoTFCReSTException {
        return this.getHistoricalEvents(null, null, parameters);
    }

    public JsonElement getHistoricalEvents(String deviceType) throws IoTFCReSTException {
        return this.getHistoricalEvents(deviceType, null, null);
    }

    public JsonElement getHistoricalEvents(String deviceType, List<NameValuePair> parameters) throws IoTFCReSTException {
        return this.getHistoricalEvents(deviceType, null, parameters);
    }

    public JsonElement getHistoricalEvents(String deviceType, String deviceId) throws IoTFCReSTException {
        return this.getHistoricalEvents(deviceType, deviceId, null);
    }

    public JsonElement getHistoricalEvents(String deviceType, String deviceId, List<NameValuePair> parameters) throws IoTFCReSTException {
        String METHOD = "getHistoricalEvents(3)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/historian");
        if (deviceType != null) {
            sb.append("/types/").append(deviceType);
        }
        if (deviceId != null) {
            sb.append("/devices/").append(deviceId);
        }
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getHistoricalEvents(3)");
            JsonElement jsonResponse = new JsonParser().parse(result);
            return jsonResponse;
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException(code, "Failure in retrieving the Historical events. :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public JsonElement getHistoricalEvents(String deviceType, String deviceId, String bookmark, String evtType, String start, String end) throws IoTFCReSTException {
        return this.getHistoricalEvents(deviceType, deviceId, bookmark, evtType, start, end, -1, null, null);
    }

    public JsonElement getHistoricalEvents(String deviceType, String deviceId, String bookmark, String evtType, String start, String end, int top, String summarize, String summarizeType) throws IoTFCReSTException {
        String METHOD = "getHistoricalEvents(9)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/historian/");
        if (deviceType != null) {
            sb.append("types/").append(deviceType);
        }
        if (deviceId != null) {
            sb.append("/devices/").append(deviceId);
        }
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (bookmark != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("_bookmark", bookmark));
        }
        if (evtType != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("evt_type", evtType));
        }
        if (start != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("start", start));
        }
        if (end != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("end", end));
        }
        if (top >= 0 && top <= 100) {
            parameters.add((NameValuePair)new BasicNameValuePair("top", Integer.toString(top)));
        }
        if (summarize != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("summarize", summarize));
        }
        if (summarizeType != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("summarize_type", summarizeType));
        }
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getHistoricalEvents(9)");
            JsonElement jsonResponse = new JsonParser().parse(result);
            return jsonResponse;
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException(code, "Failure in retrieving the Historical events. :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public JsonObject registerDevice(String deviceType, String deviceId, String authToken, JsonElement deviceInfo, JsonElement location, JsonElement metadata) throws IoTFCReSTException {
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices");
        JsonObject input = new JsonObject();
        if (deviceId != null) {
            input.addProperty("deviceId", deviceId);
        }
        if (authToken != null) {
            input.addProperty("authToken", authToken);
        }
        if (deviceInfo != null) {
            input.add("deviceInfo", deviceInfo);
        }
        if (location != null) {
            input.add("location", location);
        }
        if (metadata != null) {
            input.add("metadata", metadata);
        }
        return this.registerDevice(deviceType, (JsonElement)input);
    }

    public JsonObject registerDevice(String typeId, JsonElement device) throws IoTFCReSTException {
        String METHOD = "registerDevice";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(typeId).append("/devices");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("post", sb.toString(), device.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 201 || code == 400 || code == 409) {
                String result = this.readContent(response, "registerDevice");
                jsonResponse = new JsonParser().parse(result);
            }
            if (code == 201) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in registering the device ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 400) {
            throw new IoTFCReSTException(400, "Invalid request (No body, invalid JSON, unexpected key, bad value)", jsonResponse);
        }
        if (code == 401) {
            throw new IoTFCReSTException(401, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(403, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 409) {
            throw new IoTFCReSTException(409, "The device already exists", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "registerDevice");
        return null;
    }

    public JsonObject registerDeviceUnderGateway(String typeId, String gatewayId, String gatewayTypeId, JsonElement device) throws IoTFCReSTException {
        if (device != null) {
            JsonObject deviceObj = device.getAsJsonObject();
            deviceObj.addProperty("gatewayId", gatewayId);
            deviceObj.addProperty("gatewayTypeId", gatewayTypeId);
        }
        return this.registerDevice(typeId, device);
    }

    public boolean deleteDevice(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "deleteDevice";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Device::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "deleteDevice");
        return false;
    }

    public boolean clearAllDiagnosticLogs(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "clearDiagnosticLogs";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/logs");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Diagnostic Logs ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "clearDiagnosticLogs");
        return false;
    }

    public JsonArray getAllDiagnosticLogs(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getAllDiagnosticLogs";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/logs");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getAllDiagnosticLogs");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonArray();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the diagnostic logs ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device log not found");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getAllDiagnosticLogs");
        return null;
    }

    public boolean addDiagnosticLog(String deviceType, String deviceId, JsonElement log) throws IoTFCReSTException {
        String METHOD = "addDiagnosticLog";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/logs");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("post", sb.toString(), log.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 201) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the diagnostic Log ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "addDiagnosticLog");
        return false;
    }

    public boolean deleteDiagnosticLog(String deviceType, String deviceId, String logId) throws IoTFCReSTException {
        String METHOD = "deleteDiagnosticLog";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/logs/").append(logId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Diagnostic Log ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "deleteDiagnosticLog");
        return false;
    }

    private void throwException(HttpResponse response, String method) throws IoTFCReSTException {
        int code = 0;
        JsonElement jsonResponse = null;
        if (response != null) {
            code = response.getStatusLine().getStatusCode();
            try {
                String result = this.readContent(response, method);
                jsonResponse = new JsonParser().parse(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject getDiagnosticLog(String deviceType, String deviceId, String logId) throws IoTFCReSTException {
        String METHOD = "getDiagnosticLog";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/logs/").append(logId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDiagnosticLog");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the Diagnostic Log ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device not found");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getDiagnosticLog");
        return null;
    }

    public boolean clearAllDiagnosticErrorCodes(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "clearAllDiagnosticErrorCodes";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/errorCodes");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Diagnostic Errorcodes ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, METHOD);
        return false;
    }

    public JsonArray getAllDiagnosticErrorCodes(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getAllDiagnosticErrorCodes";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/errorCodes");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getAllDiagnosticErrorCodes");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonArray();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the diagnostic Errorcodes ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Device not found");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getAllDiagnosticErrorCodes");
        return null;
    }

    public boolean addDiagnosticErrorCode(String deviceType, String deviceId, JsonElement errorcode) throws IoTFCReSTException {
        String METHOD = "addDiagnosticErrorCode";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device/types/").append(deviceType).append("/devices/").append(deviceId).append("/diag/errorCodes");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("post", sb.toString(), errorcode.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 201) {
                return true;
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the Errorcode ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "addDiagnosticErrorCode");
        return false;
    }

    public boolean addDiagnosticErrorCode(String deviceType, String deviceId, int errorcode, Date date) throws IoTFCReSTException {
        JsonObject ec = new JsonObject();
        ec.addProperty("errorCode", (Number)errorcode);
        if (date == null) {
            date = new Date();
        }
        String utcTime = DateFormatUtils.formatUTC((Date)date, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        ec.addProperty("timestamp", utcTime);
        return this.addDiagnosticErrorCode(deviceType, deviceId, (JsonElement)ec);
    }

    public JsonArray getDeviceConnectionLogs(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getDeviceConnectionLogs";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/logs/connection");
        sb.append("?typeId=").append(deviceType).append("&deviceId=").append(deviceId);
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getDeviceConnectionLogs");
                JsonElement jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonArray();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the connection logs ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 401) {
            throw new IoTFCReSTException(code, "The authentication token is empty or invalid");
        }
        if (code == 403) {
            throw new IoTFCReSTException(code, "The authentication method is invalid or the API key used does not exist");
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "The device type does not exist");
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        this.throwException(response, "getDeviceConnectionLogs");
        return null;
    }

    public JsonArray addMultipleDevices(JsonArray arryOfDevicesToBeAdded) throws IoTFCReSTException {
        String METHOD = "bulkDevicesAdd";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/bulk/devices/add");
        int code = 0;
        JsonElement jsonResponse = null;
        HttpResponse response = null;
        try {
            response = this.connect("post", sb.toString(), arryOfDevicesToBeAdded.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code != 500) {
                String result = this.readContent(response, "bulkDevicesAdd");
                jsonResponse = new JsonParser().parse(result);
            }
            if (code == 201) {
                return jsonResponse.getAsJsonArray();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the Devices, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 202) {
            throw new IoTFCReSTException(202, "Some devices registered successfully", jsonResponse);
        }
        if (code == 400) {
            throw new IoTFCReSTException(400, "Invalid request (No body, invalid JSON, unexpected key, bad value)", jsonResponse);
        }
        if (code == 403) {
            throw new IoTFCReSTException(403, "Maximum number of devices exceeded", jsonResponse);
        }
        if (code == 413) {
            throw new IoTFCReSTException(413, "Request content exceeds 512Kb", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonArray deleteMultipleDevices(JsonArray arryOfDevicesToBeDeleted) throws IoTFCReSTException {
        String METHOD = "bulkDevicesRemove";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/bulk/devices/remove");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("post", sb.toString(), arryOfDevicesToBeDeleted.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code != 500) {
                String result = this.readContent(response, "bulkDevicesRemove");
                jsonResponse = new JsonParser().parse(result);
            }
            if (code == 201) {
                return jsonResponse.getAsJsonArray();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Devices, :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 202) {
            throw new IoTFCReSTException(202, "Some devices deleted successfully", jsonResponse);
        }
        if (code == 400) {
            throw new IoTFCReSTException(400, "Invalid request (No body, invalid JSON, unexpected key, bad value)", jsonResponse);
        }
        if (code == 413) {
            throw new IoTFCReSTException(413, "Request content exceeds 512Kb", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error");
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject getAllDeviceManagementRequests() throws IoTFCReSTException {
        return this.getAllDeviceManagementRequests(null);
    }

    public JsonObject getAllDeviceManagementRequests(List<NameValuePair> parameters) throws IoTFCReSTException {
        String METHOD = "getAllDeviceManagementRequests";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/requests");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = this.readContent(response, "getAllDeviceManagementRequests");
                jsonResponse = new JsonParser().parse(result);
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in getting the Device management Requests ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error", jsonResponse);
        }
        this.throwException(response, "getAllDeviceManagementRequests");
        return null;
    }

    public JsonObject addDeviceManagementExtension(JsonObject request) throws IoTFCReSTException {
        return this.addDeviceManagementExtension(request.toString());
    }

    public JsonObject addDeviceManagementExtension(String request) throws IoTFCReSTException {
        String METHOD = "addDeviceManagementExtension";
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        int code = 0;
        try {
            StringBuilder sb = new StringBuilder("https://");
            sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/custom/bundle");
            response = this.connect("post", sb.toString(), request, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 201 || code == 400 || code == 401 || code == 403 || code == 409 || code == 500) {
                String result = this.readContent(response, "addDeviceManagementExtension");
                jsonResponse = new JsonParser().parse(result);
                if (code == 201) {
                    return jsonResponse.getAsJsonObject();
                }
                String reason = null;
                switch (code) {
                    case 400: {
                        reason = new String("Invalid request");
                        break;
                    }
                    case 401: {
                        reason = new String("Unauthorized");
                        break;
                    }
                    case 403: {
                        reason = new String("Forbidden");
                        break;
                    }
                    case 409: {
                        reason = new String("Conflict");
                        break;
                    }
                    case 500: {
                        reason = new String("Internal server error");
                    }
                }
                throw new IoTFCReSTException(code, reason, jsonResponse);
            }
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the Device Management Extension ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public void deleteDeviceManagementExtension(String bundleId) throws IoTFCReSTException {
        String METHOD = "deleteDeviceManagementExtension";
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        int code = 0;
        try {
            StringBuilder sb = new StringBuilder("https://");
            sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/custom/bundle/" + bundleId);
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return;
            }
            if (code == 400 || code == 401 || code == 403 || code == 500) {
                String result = this.readContent(response, "deleteDeviceManagementExtension");
                jsonResponse = new JsonParser().parse(result);
                String reason = null;
                switch (code) {
                    case 400: {
                        reason = new String("Invalid request");
                        break;
                    }
                    case 401: {
                        reason = new String("Unauthorized");
                        break;
                    }
                    case 403: {
                        reason = new String("Forbidden");
                        break;
                    }
                    case 500: {
                        reason = new String("Internal server error");
                    }
                }
                throw new IoTFCReSTException(code, reason, jsonResponse);
            }
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the Device Management Extension ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public JsonObject getDeviceManagementExtension(String bundleId) throws IoTFCReSTException {
        String METHOD = "addDeviceManagementExtension";
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        int code = 0;
        try {
            StringBuilder sb = new StringBuilder("https://");
            sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/custom/bundle/" + bundleId);
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 200 || code == 400 || code == 401 || code == 403 || code == 404 || code == 500) {
                String result = this.readContent(response, "addDeviceManagementExtension");
                jsonResponse = new JsonParser().parse(result);
                if (code == 200) {
                    return jsonResponse.getAsJsonObject();
                }
                String reason = null;
                switch (code) {
                    case 400: {
                        reason = new String("Invalid request");
                        break;
                    }
                    case 401: {
                        reason = new String("Unauthorized");
                        break;
                    }
                    case 403: {
                        reason = new String("Forbidden");
                        break;
                    }
                    case 404: {
                        reason = new String("Not Found");
                        break;
                    }
                    case 500: {
                        reason = new String("Internal server error");
                    }
                }
                throw new IoTFCReSTException(code, reason, jsonResponse);
            }
            throw new IoTFCReSTException(code, "Unexpected error");
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in adding the Device Management Extension ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean initiateDeviceManagementRequest(JsonObject request) throws IoTFCReSTException {
        String METHOD = "initiateDeviceManagementRequest";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/requests");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("post", sb.toString(), request.toString(), null);
            code = response.getStatusLine().getStatusCode();
            if (code == 202) {
                return true;
            }
            String result = this.readContent(response, "initiateDeviceManagementRequest");
            jsonResponse = new JsonParser().parse(result);
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in initiating the Device management Request ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error", jsonResponse);
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public boolean deleteDeviceManagementRequest(String requestId) throws IoTFCReSTException {
        String METHOD = "deleteDeviceManagementRequest";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/requests/").append(requestId);
        int code = 0;
        JsonElement jsonResponse = null;
        HttpResponse response = null;
        try {
            response = this.connect("delete", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            if (code == 204) {
                return true;
            }
            String result = this.readContent(response, METHOD);
            jsonResponse = new JsonParser().parse(result);
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Device management Request ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error", jsonResponse);
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject getDeviceManagementRequest(String requestId) throws IoTFCReSTException {
        String METHOD = "getDeviceManagementRequest";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/requests/").append(requestId);
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getDeviceManagementRequest");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in deleting the Device management Request ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error", jsonResponse);
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Request status not found");
        }
        this.throwException(response, "getDeviceManagementRequest");
        return null;
    }

    public JsonObject getDeviceManagementRequestStatus(String requestId, List<NameValuePair> parameters) throws IoTFCReSTException {
        String METHOD = "getDeviceManagementRequestStatus";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/requests/").append(requestId).append("/deviceStatus");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getDeviceManagementRequestStatus");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the Device management Request ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error", jsonResponse);
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Request status not found", jsonResponse);
        }
        this.throwException(response, "getDeviceManagementRequestStatus");
        return null;
    }

    public JsonObject getDeviceManagementRequestStatus(String requestId) throws IoTFCReSTException {
        return this.getDeviceManagementRequestStatus(requestId, null);
    }

    public JsonObject getDeviceManagementRequestStatusByDevice(String requestId, String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getDeviceManagementRequestStatusByDevice";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/mgmt/requests/").append(requestId).append("/deviceStatus/").append(deviceType).append('/').append(deviceId);
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getDeviceManagementRequestStatusByDevice");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the Device management Request ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error", jsonResponse);
        }
        if (code == 404) {
            throw new IoTFCReSTException(code, "Request status not found", jsonResponse);
        }
        this.throwException(response, "getDeviceManagementRequestStatusByDevice");
        return null;
    }

    public JsonObject getActiveDevices(String startDate, String endDate, boolean detail) throws IoTFCReSTException {
        String METHOD = "getActiveDevices";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/usage/active-devices");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (startDate != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("start", startDate));
        }
        if (endDate != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("end", endDate));
        }
        parameters.add((NameValuePair)new BasicNameValuePair("detail", Boolean.toString(detail)));
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getActiveDevices");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the Active Devices ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 400) {
            throw new IoTFCReSTException(code, "Bad Request", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(code, "Unexpected error", jsonResponse);
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject getHistoricalDataUsage(String startDate, String endDate, boolean detail) throws IoTFCReSTException {
        String METHOD = "getHistoricalDataUsage";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/usage/historical-data");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (startDate != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("start", startDate));
        }
        if (endDate != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("end", endDate));
        }
        parameters.add((NameValuePair)new BasicNameValuePair("detail", Boolean.toString(detail)));
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getHistoricalDataUsage");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the historical data storage ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 400) {
            throw new IoTFCReSTException(code, "Bad Request", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error", jsonResponse);
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject getDataTraffic(String startDate, String endDate, boolean detail) throws IoTFCReSTException {
        String METHOD = "getDataTraffic";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/usage/data-traffic");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (startDate != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("start", startDate));
        }
        if (endDate != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("end", endDate));
        }
        parameters.add((NameValuePair)new BasicNameValuePair("detail", Boolean.toString(detail)));
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, parameters);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getDataTraffic");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the data traffic ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 400) {
            throw new IoTFCReSTException(code, "Bad Request", jsonResponse);
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error", jsonResponse);
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject getServiceStatus() throws IoTFCReSTException {
        String METHOD = "getServiceStatus";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/service-status");
        int code = 0;
        HttpResponse response = null;
        JsonElement jsonResponse = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, "getServiceStatus");
            jsonResponse = new JsonParser().parse(result);
            if (code == 200) {
                return jsonResponse.getAsJsonObject();
            }
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException("Failure in retrieving the service status ::" + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (code == 500) {
            throw new IoTFCReSTException(500, "Unexpected error", jsonResponse);
        }
        throw new IoTFCReSTException(code, "", jsonResponse);
    }

    public JsonObject registerDeviceUnderGateway(String deviceType, String deviceId, String gwTypeId, String gwDeviceId) throws IoTFCReSTException {
        JsonObject deviceObj = new JsonObject();
        deviceObj.addProperty("deviceId", deviceId);
        deviceObj.addProperty("gatewayId", gwDeviceId);
        deviceObj.addProperty("gatewayTypeId", gwTypeId);
        return this.registerDevice(deviceType, (JsonElement)deviceObj);
    }

    public JsonElement getLastEvents(String deviceType, String deviceId) throws IoTFCReSTException {
        String METHOD = "getLastEvents(2)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device");
        if (deviceType != null) {
            sb.append("/types/").append(deviceType);
        }
        if (deviceId != null) {
            sb.append("/devices/").append(deviceId);
        }
        sb.append("/events");
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            String result = this.readContent(response, METHOD);
            JsonElement jsonResponse = new JsonParser().parse(result);
            code = response.getStatusLine().getStatusCode();
            if (code == 400) {
                throw new IoTFCReSTException(400, "Invalid request", jsonResponse);
            }
            if (code == 403) {
                throw new IoTFCReSTException(403, "Forbidden", jsonResponse);
            }
            if (code == 500) {
                throw new IoTFCReSTException(500, "Internal server error", jsonResponse);
            }
            return jsonResponse;
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException(code, "Failure in retrieving the last events. :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public JsonElement getLastEvent(String deviceType, String deviceId, String eventId) throws IoTFCReSTException {
        String METHOD = "getLastEvent(3)";
        StringBuilder sb = new StringBuilder("https://");
        sb.append(this.orgId).append('.').append(this.domain).append(BASIC_API_V0002_URL).append("/device");
        if (deviceType != null) {
            sb.append("/types/").append(deviceType);
        }
        if (deviceId != null) {
            sb.append("/devices/").append(deviceId);
        }
        if (eventId != null) {
            sb.append("/events/").append(eventId);
        }
        int code = 0;
        HttpResponse response = null;
        try {
            response = this.connect("get", sb.toString(), null, null);
            code = response.getStatusLine().getStatusCode();
            String result = this.readContent(response, METHOD);
            JsonElement jsonResponse = new JsonParser().parse(result);
            if (code == 400) {
                throw new IoTFCReSTException(400, "Invalid request", jsonResponse);
            }
            if (code == 403) {
                throw new IoTFCReSTException(403, "Forbidden", jsonResponse);
            }
            if (code == 500) {
                throw new IoTFCReSTException(500, "Internal server error", jsonResponse);
            }
            return jsonResponse;
        }
        catch (Exception e) {
            IoTFCReSTException ex = new IoTFCReSTException(code, "Failure in retrieving the last event. :: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }
}

