/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client.app;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.iotf.client.AbstractClient;
import com.ibm.iotf.client.api.APIClient;
import com.ibm.iotf.client.app.ApplicationStatus;
import com.ibm.iotf.client.app.Command;
import com.ibm.iotf.client.app.DeviceStatus;
import com.ibm.iotf.client.app.Event;
import com.ibm.iotf.client.app.EventCallback;
import com.ibm.iotf.client.app.StatusCallback;
import com.ibm.iotf.util.LoggerUtility;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

public class ApplicationClient
extends AbstractClient
implements MqttCallback {
    private static final String CLASS_NAME = ApplicationClient.class.getName();
    private static final Pattern DEVICE_EVENT_PATTERN = Pattern.compile("iot-2/type/(.+)/id/(.+)/evt/(.+)/fmt/(.+)");
    private static final Pattern DEVICE_STATUS_PATTERN = Pattern.compile("iot-2/type/(.+)/id/(.+)/mon");
    private static final Pattern APP_STATUS_PATTERN = Pattern.compile("iot-2/app/(.+)/mon");
    private static final Pattern DEVICE_COMMAND_PATTERN = Pattern.compile("iot-2/type/(.+)/id/(.+)/cmd/(.+)/fmt/(.+)");
    private EventCallback eventCallback = null;
    private StatusCallback statusCallback = null;
    private APIClient apiClient = null;
    private HashMap<String, Integer> subscriptions = new HashMap();

    public ApplicationClient(Properties options) throws Exception {
        super(options);
        if (this.getOrgId() == null) {
            throw new Exception("Invalid Auth Key");
        }
        this.clientId = this.isSharedSubscriptionEnabled() ? "A:" + this.getOrgId() + ":" + this.getAppId() : "a:" + this.getOrgId() + ":" + this.getAppId();
        if (this.getAuthMethod() == null) {
            this.clientUsername = null;
            this.clientPassword = null;
        } else {
            if (!this.getAuthMethod().equals("apikey")) {
                throw new Exception("Unsupported Authentication Method: " + this.getAuthMethod());
            }
            this.clientUsername = this.getAuthKey();
            this.clientPassword = this.getAuthToken();
        }
        this.createClient(this);
        this.apiClient = new APIClient(options);
    }

    public APIClient api() {
        return this.apiClient;
    }

    private boolean isSharedSubscriptionEnabled() {
        boolean enabled = false;
        String value = this.options.getProperty("Shared-Subscription");
        if (value == null) {
            value = this.options.getProperty("shared-subscription");
        }
        if (value != null) {
            enabled = Boolean.parseBoolean(ApplicationClient.trimedValue(value));
        }
        return enabled;
    }

    @Override
    public String getOrgId() {
        String orgid = super.getOrgId();
        if (orgid == null || orgid.equals("")) {
            String authKeyPassed = this.getAuthKey();
            if (authKeyPassed != null && !authKeyPassed.trim().equals("") && !authKeyPassed.equals("quickstart")) {
                if (authKeyPassed.length() >= 8) {
                    return authKeyPassed.substring(2, 8);
                }
                return null;
            }
            return "quickstart";
        }
        return orgid;
    }

    public String getAppId() {
        return ApplicationClient.trimedValue(this.options.getProperty("id"));
    }

    public String getAuthKey() {
        String authKeyPassed = this.options.getProperty("auth-key");
        if (authKeyPassed == null) {
            authKeyPassed = this.options.getProperty("API-Key");
        }
        return ApplicationClient.trimedValue(authKeyPassed);
    }

    public void connect() throws MqttException {
        super.connect(true);
    }

    public boolean publishEvent(String deviceType, String deviceId, String event, Object data) {
        return this.publishEvent(deviceType, deviceId, event, data, 0);
    }

    public boolean publishEvent(String deviceType, String deviceId, String event, Object data, int qos) {
        if (!this.isConnected()) {
            return false;
        }
        String METHOD = "publishEvent(5)";
        JsonObject payload = new JsonObject();
        String timestamp = ISO8601_DATE_FORMAT.format(new Date());
        payload.addProperty("ts", timestamp);
        if (data == null) {
            data = new JsonObject();
        }
        JsonElement dataElement = gson.toJsonTree(data);
        payload.add("d", dataElement);
        String topic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/json";
        LoggerUtility.fine(CLASS_NAME, "publishEvent(5)", "Topic   = " + topic);
        LoggerUtility.fine(CLASS_NAME, "publishEvent(5)", "Payload = " + payload.toString());
        MqttMessage msg = new MqttMessage(payload.toString().getBytes(Charset.forName("UTF-8")));
        msg.setQos(qos);
        msg.setRetained(false);
        try {
            this.mqttAsyncClient.publish(topic, msg).waitForCompletion();
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            return false;
        }
        catch (MqttException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean publishCommand(String deviceType, String deviceId, String command, Object data) {
        return this.publishCommand(deviceType, deviceId, command, data, 0);
    }

    public boolean publishCommand(String deviceType, String deviceId, String command, Object data, int qos) {
        if (!this.isConnected()) {
            return false;
        }
        String METHOD = "publishCommand(5)";
        JsonObject payload = new JsonObject();
        String timestamp = ISO8601_DATE_FORMAT.format(new Date());
        payload.addProperty("ts", timestamp);
        if (data == null) {
            data = new JsonObject();
        }
        JsonElement dataElement = gson.toJsonTree(data);
        payload.add("d", dataElement);
        String topic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/json";
        LoggerUtility.fine(CLASS_NAME, "publishCommand(5)", "Topic   = " + topic);
        LoggerUtility.fine(CLASS_NAME, "publishCommand(5)", "Payload = " + payload.toString());
        MqttMessage msg = new MqttMessage(payload.toString().getBytes(Charset.forName("UTF-8")));
        msg.setQos(qos);
        msg.setRetained(false);
        try {
            this.mqttAsyncClient.publish(topic, msg).waitForCompletion();
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            return false;
        }
        catch (MqttException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void subscribeToDeviceEvents() {
        this.subscribeToDeviceEvents("+", "+", "+", 0);
    }

    public void subscribeToDeviceEvents(String deviceType) {
        this.subscribeToDeviceEvents(deviceType, "+", "+", 0);
    }

    public void subscribeToDeviceEvents(String deviceType, String deviceId) {
        this.subscribeToDeviceEvents(deviceType, deviceId, "+", 0);
    }

    public void unsubscribeFromDeviceEvents(String deviceType, String deviceId) {
        this.unsubscribeFromDeviceEvents(deviceType, deviceId, "+");
    }

    public void subscribeToDeviceEvents(String deviceType, String deviceId, String event) {
        this.subscribeToDeviceEvents(deviceType, deviceId, event, 0);
    }

    public void subscribeToDeviceEvents(String deviceType, String deviceId, String event, int qos) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/json";
            this.subscriptions.put(newTopic, new Integer(qos));
            this.mqttAsyncClient.subscribe(newTopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceEvents(String deviceType, String deviceId, String event, String format) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/" + format;
            this.subscriptions.put(newTopic, new Integer(0));
            this.mqttAsyncClient.subscribe(newTopic, 0);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceEvents(String deviceType, String deviceId, String event, String format, int qos) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/" + format;
            this.subscriptions.put(newTopic, new Integer(qos));
            this.mqttAsyncClient.subscribe(newTopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeFromDeviceEvents(String deviceType, String deviceId, String event) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/json";
            this.subscriptions.remove(newTopic);
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeFromDeviceEvents(String deviceType, String deviceId, String event, String format) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/" + format;
            this.subscriptions.remove(newTopic);
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeFromDeviceCommands(String deviceType, String deviceId) {
        this.unsubscribeFromDeviceCommands(deviceType, deviceId, "+");
    }

    public void unsubscribeFromDeviceCommands(String deviceType, String deviceId, String command, String format) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/" + format;
            this.subscriptions.remove(newTopic);
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeFromDeviceCommands(String deviceType, String deviceId, String command) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/json";
            this.subscriptions.remove(newTopic);
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceCommands() {
        this.subscribeToDeviceCommands("+", "+", "+", 0);
    }

    public void subscribeToDeviceCommands(String deviceType) {
        this.subscribeToDeviceCommands(deviceType, "+", "+", 0);
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId) {
        this.subscribeToDeviceCommands(deviceType, deviceId, "+", 0);
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command) {
        this.subscribeToDeviceCommands(deviceType, deviceId, command, 0);
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command, int qos) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/json";
            this.subscriptions.put(newTopic, new Integer(qos));
            this.mqttAsyncClient.subscribe(newTopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command, String format) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/" + format;
            this.subscriptions.put(newTopic, new Integer(0));
            this.mqttAsyncClient.subscribe(newTopic, 0);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command, String format, int qos) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/" + format;
            this.subscriptions.put(newTopic, new Integer(qos));
            this.mqttAsyncClient.subscribe(newTopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceStatus() {
        this.subscribeToDeviceStatus("+", "+");
    }

    public void subscribeToDeviceStatus(String deviceType) {
        this.subscribeToDeviceStatus(deviceType, "+");
    }

    public void subscribeToDeviceStatus(String deviceType, String deviceId) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/mon";
            this.subscriptions.put(newTopic, new Integer(0));
            this.mqttAsyncClient.subscribe(newTopic, 0);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unSubscribeFromDeviceStatus(String deviceType, String deviceId) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/mon";
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToApplicationStatus() {
        this.subscribeToApplicationStatus("+");
    }

    public void subscribeToApplicationStatus(String appId) {
        try {
            String newTopic = "iot-2/app/" + appId + "/mon";
            this.subscriptions.put(newTopic, new Integer(0));
            this.mqttAsyncClient.subscribe(newTopic, 0);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unSubscribeFromApplicationStatus(String appId) {
        try {
            String newTopic = "iot-2/app/" + appId + "/mon";
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void connectionLost(Throwable e) {
        String METHOD = "connectionLost";
        LoggerUtility.log(Level.SEVERE, CLASS_NAME, "connectionLost", e.getMessage(), e);
        try {
            this.connect();
            Iterator<Map.Entry<String, Integer>> iterator = this.subscriptions.entrySet().iterator();
            LoggerUtility.info(CLASS_NAME, "connectionLost", "Resubscribing....");
            while (iterator.hasNext() && this.isConnected()) {
                Map.Entry<String, Integer> pairs = iterator.next();
                LoggerUtility.info(CLASS_NAME, "connectionLost", pairs.getKey() + " = " + pairs.getValue());
                try {
                    this.mqttAsyncClient.subscribe(pairs.getKey().toString(), Integer.parseInt(pairs.getValue().toString()));
                }
                catch (NumberFormatException | MqttException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (MqttException e2) {
            e2.printStackTrace();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        String METHOD = "deliveryComplete";
        LoggerUtility.fine(CLASS_NAME, "deliveryComplete", "token = " + token.getMessageId());
        ++this.messageCount;
    }

    public void messageArrived(String topic, MqttMessage msg) throws Exception {
        Matcher matcher;
        String METHOD = "messageArrived";
        if (this.eventCallback != null) {
            matcher = DEVICE_EVENT_PATTERN.matcher(topic);
            if (matcher.matches()) {
                String format;
                String event;
                String id;
                String type = matcher.group(1);
                Event evt = new Event(type, id = matcher.group(2), event = matcher.group(3), format = matcher.group(4), msg);
                if (evt.getTimestamp() != null) {
                    LoggerUtility.fine(CLASS_NAME, "messageArrived", "Event received: " + evt.toString());
                    this.eventCallback.processEvent(evt);
                } else {
                    LoggerUtility.warn(CLASS_NAME, "messageArrived", "Event is not formatted properly, so not processing");
                }
                return;
            }
            matcher = DEVICE_COMMAND_PATTERN.matcher(topic);
            if (matcher.matches()) {
                String format;
                String command;
                String id;
                String type = matcher.group(1);
                Command cmd = new Command(type, id = matcher.group(2), command = matcher.group(3), format = matcher.group(4), msg);
                if (cmd.getTimestamp() != null) {
                    LoggerUtility.fine(CLASS_NAME, "messageArrived", "Command received: " + cmd.toString());
                    this.eventCallback.processCommand(cmd);
                } else {
                    LoggerUtility.warn(CLASS_NAME, "messageArrived", "Command is not formatted properly, so not processing");
                }
                return;
            }
        }
        if (this.statusCallback != null) {
            matcher = DEVICE_STATUS_PATTERN.matcher(topic);
            if (matcher.matches()) {
                String type = matcher.group(1);
                String id = matcher.group(2);
                DeviceStatus status = new DeviceStatus(type, id, msg);
                LoggerUtility.fine(CLASS_NAME, "messageArrived", "Device status received: " + status.toString());
                this.statusCallback.processDeviceStatus(status);
            }
            if ((matcher = APP_STATUS_PATTERN.matcher(topic)).matches()) {
                String id = matcher.group(1);
                ApplicationStatus status = new ApplicationStatus(id, msg);
                LoggerUtility.fine(CLASS_NAME, "messageArrived", "Application status received: " + status.toString());
                this.statusCallback.processApplicationStatus(status);
            }
        }
    }

    public void setEventCallback(EventCallback callback) {
        this.eventCallback = callback;
    }

    public void setStatusCallback(StatusCallback callback) {
        this.statusCallback = callback;
    }

    public int publishEventOverHTTP(String deviceType, String deviceId, String eventName, Object payload) throws Exception {
        return ApplicationClient.publishEventsThroughHttps(this.getOrgId(), this.getDomain(), deviceType, deviceId, eventName, false, this.getAuthKey(), this.getAuthToken(), payload);
    }
}

