/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client.app;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class Status {
    protected static final JsonParser JSON_PARSER = new JsonParser();
    protected static final DateTimeFormatter DT_PARSER = ISODateTimeFormat.dateTimeParser();
    private String clientAddr;
    private String protocol;
    private String clientId;
    private String user;
    private String action;
    private String connectTime;
    private int port;
    private DateTime time;
    private int writeMsg = 0;
    private int readMsg = 0;
    private int readBytes = 0;
    private int writeBytes = 0;
    private String reason;
    private String payload;

    public String getClientAddr() {
        return this.clientAddr;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUser() {
        return this.user;
    }

    public String getAction() {
        return this.action;
    }

    public String getConnectTime() {
        return this.connectTime;
    }

    public int getPort() {
        return this.port;
    }

    public DateTime getTime() {
        return this.time;
    }

    public int getWriteMsg() {
        return this.writeMsg;
    }

    public int getReadMsg() {
        return this.readMsg;
    }

    public int getReadBytes() {
        return this.readBytes;
    }

    public int getWriteBytes() {
        return this.writeBytes;
    }

    public String getReason() {
        return this.reason;
    }

    public Status(MqttMessage msg) throws UnsupportedEncodingException {
        this.payload = new String(msg.getPayload(), "UTF8");
        JsonObject payloadJson = JSON_PARSER.parse(this.payload).getAsJsonObject();
        this.clientAddr = payloadJson.get("ClientAddr").getAsString();
        this.protocol = payloadJson.get("Protocol").getAsString();
        this.clientId = payloadJson.get("ClientID").getAsString();
        this.time = DT_PARSER.parseDateTime(payloadJson.get("Time").getAsString());
        this.action = payloadJson.get("Action").getAsString();
        this.port = payloadJson.get("Port").getAsInt();
        if (this.action.equals("Disconnect")) {
            this.user = payloadJson.has("User") ? payloadJson.get("User").getAsString() : new String();
            this.connectTime = payloadJson.get("ConnectTime").getAsString();
            this.writeMsg = payloadJson.get("WriteMsg").getAsInt();
            this.readMsg = payloadJson.get("ReadMsg").getAsInt();
            this.readBytes = payloadJson.get("ReadBytes").getAsInt();
            this.writeBytes = payloadJson.get("WriteBytes").getAsInt();
            this.reason = payloadJson.has("Reason") ? payloadJson.get("Reason").getAsString() : new String();
        }
    }

    public String getPayload() {
        return this.payload;
    }

    public String toString() {
        if (this.action.equals("Disconnect")) {
            return "Status [" + this.time.toString() + "] " + this.clientId + ":" + this.action + " (" + this.reason + ")";
        }
        return "Status [" + this.time.toString() + "] " + this.clientId + ":" + this.action;
    }
}

