/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client.device;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.iotf.client.AbstractClient;
import com.ibm.iotf.client.device.Command;
import com.ibm.iotf.client.device.CommandCallback;
import com.ibm.iotf.util.LoggerUtility;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

public class DeviceClient
extends AbstractClient {
    private static final String CLASS_NAME = DeviceClient.class.getName();
    private static final Pattern COMMAND_PATTERN = Pattern.compile("iot-2/cmd/(.+)/fmt/(.+)");
    private CommandCallback commandCallback = null;

    protected DeviceClient(MqttAsyncClient mqttAsyncClient) {
        super(mqttAsyncClient);
    }

    protected DeviceClient(MqttClient mqttClient) {
        super(mqttClient);
    }

    public DeviceClient(Properties options) throws Exception {
        super(options);
        LoggerUtility.fine(CLASS_NAME, "DeviceClient", "options   = " + options);
        this.clientId = "d:" + this.getOrgId() + ":" + this.getDeviceType() + ":" + this.getDeviceId();
        if (this.getAuthMethod() == null) {
            this.clientUsername = null;
            this.clientPassword = null;
        } else {
            if (!this.getAuthMethod().equals("token")) {
                throw new Exception("Unsupported Authentication Method: " + this.getAuthMethod());
            }
            this.clientUsername = "use-token-auth";
            this.clientPassword = this.getAuthToken();
        }
        this.createClient(new MqttDeviceCallBack());
    }

    public String getDeviceType() {
        String type = this.options.getProperty("type");
        if (type == null) {
            type = this.options.getProperty("Device-Type");
        }
        return DeviceClient.trimedValue(type);
    }

    public String getFormat() {
        String format = this.options.getProperty("format");
        if (format != null && !format.equals("")) {
            return format;
        }
        return "json";
    }

    public void connect() throws MqttException {
        super.connect(true);
        if (!this.getOrgId().equals("quickstart")) {
            this.subscribeToCommands();
        }
    }

    @Override
    public void connect(boolean autoRetry) throws MqttException {
        super.connect(autoRetry);
        if (!this.getOrgId().equals("quickstart")) {
            this.subscribeToCommands();
        }
    }

    @Override
    public void connect(int numberOfRetryAttempts) throws MqttException {
        super.connect(numberOfRetryAttempts);
        if (!this.getOrgId().equals("quickstart")) {
            this.subscribeToCommands();
        }
    }

    protected void reconnect() throws MqttException {
        super.connect(true);
        if (!this.getOrgId().equals("quickstart")) {
            this.subscribeToCommands();
        }
    }

    private void subscribeToCommands() {
        try {
            this.mqttAsyncClient.subscribe("iot-2/cmd/+/fmt/" + this.getFormat(), 2);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public boolean publishEvent(String event, Object data) {
        return this.publishEvent(event, data, 0);
    }

    public boolean publishEvent(String event, Object data, int qos) {
        if (!this.isConnected()) {
            return false;
        }
        String METHOD = "publishEvent(2)";
        JsonObject payload = new JsonObject();
        String timestamp = ISO8601_DATE_FORMAT.format(new Date());
        payload.addProperty("ts", timestamp);
        if (data == null) {
            data = new JsonObject();
        }
        JsonElement dataElement = gson.toJsonTree(data);
        payload.add("d", dataElement);
        String topic = "iot-2/evt/" + event + "/fmt/json";
        LoggerUtility.fine(CLASS_NAME, "publishEvent(2)", "Topic   = " + topic);
        LoggerUtility.fine(CLASS_NAME, "publishEvent(2)", "Payload = " + payload.toString());
        MqttMessage msg = new MqttMessage(payload.toString().getBytes(Charset.forName("UTF-8")));
        msg.setQos(qos);
        msg.setRetained(false);
        try {
            this.mqttAsyncClient.publish(topic, msg).waitForCompletion();
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            return false;
        }
        catch (MqttException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setCommandCallback(CommandCallback callback) {
        this.commandCallback = callback;
    }

    public int publishEventOverHTTP(String eventName, Object payload) throws Exception {
        String authKey = "use-token-auth";
        return DeviceClient.publishEventsThroughHttps(this.getOrgId(), this.getDomain(), this.getDeviceType(), this.getDeviceId(), eventName, true, authKey, this.getAuthToken(), payload);
    }

    private class MqttDeviceCallBack
    implements MqttCallback {
        private MqttDeviceCallBack() {
        }

        public void connectionLost(Throwable exception) {
            String METHOD = "connectionLost";
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "connectionLost", exception.getMessage(), exception);
            try {
                DeviceClient.this.reconnect();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
            String METHOD = "deliveryComplete";
            LoggerUtility.fine(CLASS_NAME, "deliveryComplete", "token " + token.getMessageId());
            DeviceClient.this.messageCount++;
        }

        public void messageArrived(String topic, MqttMessage msg) throws Exception {
            Matcher matcher;
            String METHOD = "messageArrived";
            if (DeviceClient.this.commandCallback != null && (matcher = COMMAND_PATTERN.matcher(topic)).matches()) {
                String command = matcher.group(1);
                String format = matcher.group(2);
                Command cmd = new Command(command, format, msg);
                LoggerUtility.fine(CLASS_NAME, "messageArrived", "Event received: " + cmd.toString());
                DeviceClient.this.commandCallback.processCommand(cmd);
            }
        }
    }
}

