/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.client.gateway;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.iotf.client.AbstractClient;
import com.ibm.iotf.client.api.APIClient;
import com.ibm.iotf.client.gateway.Command;
import com.ibm.iotf.client.gateway.GatewayCallback;
import com.ibm.iotf.util.LoggerUtility;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

public class GatewayClient
extends AbstractClient
implements MqttCallback {
    private static final String CLASS_NAME = GatewayClient.class.getName();
    private static final Pattern GATEWAY_NOTIFICATION_PATTERN = Pattern.compile("iot-2/type/(.+)/id/(.+)/notify");
    private static final Pattern GATEWAY_COMMAND_PATTERN = Pattern.compile("iot-2/type/(.+)/id/(.+)/cmd/(.+)/fmt/(.+)");
    private GatewayCallback gwCommandCallback = null;
    private HashMap<String, Integer> subscriptions = new HashMap();
    private APIClient apiClient = null;

    public GatewayClient(Properties options) throws Exception {
        super(options);
        if (this.getOrgId() == null) {
            throw new Exception("Invalid Auth Key");
        }
        if (this.getOrgId().equalsIgnoreCase("quickstart")) {
            throw new Exception("There is no quickstart support for Gateways");
        }
        this.clientId = "g:" + this.getOrgId() + ":" + this.getGWDeviceType() + ":" + this.getGWDeviceId();
        if (this.getAuthMethod() == null) {
            this.clientUsername = null;
            this.clientPassword = null;
        } else {
            if (!this.getAuthMethod().equals("token")) {
                throw new Exception("Unsupported Authentication Method: " + this.getAuthMethod());
            }
            this.clientUsername = "use-token-auth";
            this.clientPassword = this.getAuthToken();
        }
        this.createClient(this);
        options.setProperty("auth-method", "gateway");
        this.apiClient = new APIClient(options);
    }

    protected GatewayClient(MqttAsyncClient mqttAsyncClient) {
        super(mqttAsyncClient);
    }

    protected GatewayClient(MqttClient mqttClient) {
        super(mqttClient);
    }

    public APIClient api() {
        return this.apiClient;
    }

    @Override
    public String getOrgId() {
        String orgid = super.getOrgId();
        if (orgid == null || orgid.equals("")) {
            String authKeyPassed = this.getAuthKey();
            if (authKeyPassed != null && !authKeyPassed.trim().equals("") && !authKeyPassed.equals("quickstart")) {
                if (authKeyPassed.length() >= 8) {
                    return authKeyPassed.substring(2, 8);
                }
                return null;
            }
            return "quickstart";
        }
        return orgid;
    }

    public String getGWDeviceId() {
        String id = this.options.getProperty("Gateway-ID");
        if (id == null) {
            return this.getDeviceId();
        }
        return GatewayClient.trimedValue(id);
    }

    public String getGWDeviceType() {
        String type = this.options.getProperty("Gateway-Type");
        if (type == null) {
            type = this.options.getProperty("type");
        }
        if (type == null) {
            type = this.options.getProperty("Device-Type");
        }
        return GatewayClient.trimedValue(type);
    }

    private String getAuthKey() {
        String authKeyPassed = this.options.getProperty("auth-key");
        if (authKeyPassed == null) {
            authKeyPassed = this.options.getProperty("API-Key");
        }
        return GatewayClient.trimedValue(authKeyPassed);
    }

    public void connect() throws MqttException {
        super.connect(true);
        this.subscribeToGatewayCommands();
    }

    @Override
    public void connect(boolean autoRetry) throws MqttException {
        super.connect(autoRetry);
        this.subscribeToGatewayCommands();
    }

    @Override
    public void connect(int numberOfRetryAttempts) throws MqttException {
        super.connect(numberOfRetryAttempts);
        this.subscribeToGatewayCommands();
    }

    public boolean publishGatewayEvent(String event, Object data) {
        return this.publishDeviceEvent(this.getGWDeviceType(), this.getGWDeviceId(), event, data, 0);
    }

    public boolean publishGatewayEvent(String event, Object data, int qos) {
        return this.publishDeviceEvent(this.getGWDeviceType(), this.getGWDeviceId(), event, data, qos);
    }

    public boolean publishDeviceEvent(String deviceType, String deviceId, String event, Object data) {
        return this.publishDeviceEvent(deviceType, deviceId, event, data, 0);
    }

    public boolean publishDeviceEvent(String deviceType, String deviceId, String event, Object data, int qos) {
        if (!this.isConnected()) {
            return false;
        }
        String METHOD = "publishEvent(5)";
        JsonObject payload = new JsonObject();
        String timestamp = ISO8601_DATE_FORMAT.format(new Date());
        payload.addProperty("ts", timestamp);
        JsonElement dataElement = gson.toJsonTree(data);
        payload.add("d", dataElement);
        String topic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/evt/" + event + "/fmt/json";
        LoggerUtility.fine(CLASS_NAME, "publishEvent(5)", "Topic   = " + topic);
        LoggerUtility.fine(CLASS_NAME, "publishEvent(5)", "Payload = " + payload.toString());
        MqttMessage msg = new MqttMessage(payload.toString().getBytes(Charset.forName("UTF-8")));
        msg.setQos(qos);
        msg.setRetained(false);
        try {
            this.mqttAsyncClient.publish(topic, msg).waitForCompletion();
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            return false;
        }
        catch (MqttException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void reconnect() {
        try {
            super.connect(true);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        this.subscribeToGatewayCommands();
    }

    private void subscribeToGatewayCommands() {
        this.subscribeToDeviceCommands(this.getGWDeviceType(), this.getGWDeviceId());
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId) {
        this.subscribeToDeviceCommands(deviceType, deviceId, "+", 0);
    }

    public void unsubscribeFromDeviceCommands(String deviceType, String deviceId) {
        this.unsubscribeFromDeviceCommands(deviceType, deviceId, "+");
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command) {
        this.subscribeToDeviceCommands(deviceType, deviceId, command, 0);
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command, int qos) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/json";
            this.subscriptions.put(newTopic, new Integer(qos));
            this.mqttAsyncClient.subscribe(newTopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeFromDeviceCommands(String deviceType, String deviceId, String command) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/json";
            this.subscriptions.remove(newTopic);
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToGatewayNotification() {
        String newTopic = "iot-2/type/" + this.getGWDeviceType() + "/id/" + this.getGWDeviceId() + "/notify";
        this.subscriptions.put(newTopic, 0);
        try {
            this.mqttAsyncClient.subscribe(newTopic, 0);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command, String format) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/" + format;
            this.subscriptions.put(newTopic, new Integer(0));
            this.mqttAsyncClient.subscribe(newTopic, 0);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeToDeviceCommands(String deviceType, String deviceId, String command, String format, int qos) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/" + format;
            this.subscriptions.put(newTopic, new Integer(qos));
            this.mqttAsyncClient.subscribe(newTopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeFromDeviceCommands(String deviceType, String deviceId, String command, String format) {
        try {
            String newTopic = "iot-2/type/" + deviceType + "/id/" + deviceId + "/cmd/" + command + "/fmt/" + format;
            this.subscriptions.remove(newTopic);
            this.mqttAsyncClient.unsubscribe(newTopic);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void connectionLost(Throwable e) {
        String METHOD = "connectionLost";
        LoggerUtility.info(CLASS_NAME, "connectionLost", "Connection lost: " + e.getMessage());
        try {
            this.connect();
            Iterator<Map.Entry<String, Integer>> iterator = this.subscriptions.entrySet().iterator();
            LoggerUtility.info(CLASS_NAME, "connectionLost", "Resubscribing....");
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> pairs = iterator.next();
                LoggerUtility.info(CLASS_NAME, "connectionLost", pairs.getKey() + " = " + pairs.getValue());
                try {
                    this.mqttAsyncClient.subscribe(pairs.getKey().toString(), Integer.parseInt(pairs.getValue().toString()));
                }
                catch (NumberFormatException | MqttException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (MqttException e2) {
            e2.printStackTrace();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        String METHOD = "deliveryComplete";
        LoggerUtility.fine(CLASS_NAME, "deliveryComplete", "token = " + token.getMessageId());
        ++this.messageCount;
    }

    public void messageArrived(String topic, MqttMessage msg) throws Exception {
        String METHOD = "messageArrived";
        if (this.gwCommandCallback != null) {
            Matcher matcher = GATEWAY_COMMAND_PATTERN.matcher(topic);
            if (matcher.matches()) {
                String format;
                String command;
                String id;
                String type = matcher.group(1);
                Command cmd = new Command(type, id = matcher.group(2), command = matcher.group(3), format = matcher.group(4), msg);
                if (cmd.getTimestamp() != null) {
                    LoggerUtility.fine(CLASS_NAME, "messageArrived", "Command received: " + cmd.toString());
                    this.gwCommandCallback.processCommand(cmd);
                } else {
                    LoggerUtility.warn(CLASS_NAME, "messageArrived", "Command is not formatted properly, so not processing");
                }
                return;
            }
            matcher = GATEWAY_NOTIFICATION_PATTERN.matcher(topic);
            if (matcher.matches()) {
                String type = matcher.group(1);
                String string = matcher.group(2);
            }
        }
    }

    public void setGatewayCallback(GatewayCallback callback) {
        this.gwCommandCallback = callback;
    }
}

