/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt;

import com.ibm.internal.iotf.devicemgmt.ConcreteDeviceAction;
import com.ibm.internal.iotf.devicemgmt.DeviceMgmt;
import com.ibm.iotf.devicemgmt.DeviceAction;
import com.ibm.iotf.devicemgmt.DeviceFirmware;
import com.ibm.iotf.devicemgmt.DeviceInfo;
import com.ibm.iotf.devicemgmt.DeviceLocation;
import com.ibm.iotf.devicemgmt.DeviceMetadata;
import com.ibm.iotf.devicemgmt.resource.Resource;
import com.ibm.iotf.devicemgmt.resource.StringResource;

public class DeviceData {
    private static String CLASS_NAME = DeviceData.class.getName();
    private String typeId = null;
    private String deviceId = null;
    private DeviceInfo deviceInfo = null;
    private DeviceLocation deviceLocation = null;
    private DeviceMgmt mgmt = null;
    private DeviceMetadata metadata = null;
    private DeviceAction deviceAction = null;
    private Resource root = new StringResource("root", "");

    private DeviceData(Builder builder) {
        this.typeId = builder.typeId;
        this.deviceId = builder.deviceId;
        this.deviceInfo = builder.deviceInfo;
        this.deviceLocation = new DeviceLocation();
        this.metadata = builder.metadata;
        DeviceFirmware firmware = builder.deviceFirmware;
        if (builder.deviceFirmware != null) {
            this.mgmt = new DeviceMgmt(builder.deviceFirmware);
        } else {
            firmware = new DeviceFirmware.Builder().build();
            this.mgmt = new DeviceMgmt(firmware);
        }
        firmware.setDeviceId(this.deviceId);
        firmware.setTypeId(this.typeId);
        this.root.add(this.mgmt);
        if (this.deviceLocation != null) {
            this.root.add(this.deviceLocation);
        }
        if (this.deviceInfo == null) {
            this.deviceInfo = new DeviceInfo.Builder().build();
        }
        this.root.add(this.deviceInfo);
        if (this.metadata != null) {
            this.root.add(this.metadata);
        }
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public DeviceLocation getDeviceLocation() {
        return this.deviceLocation;
    }

    public DeviceFirmware getDeviceFirmware() {
        if (this.mgmt != null) {
            return this.mgmt.getDeviceFirmware();
        }
        return null;
    }

    public DeviceAction getDeviceAction() {
        if (this.deviceAction == null) {
            this.deviceAction = new ConcreteDeviceAction(this.typeId, this.deviceId);
        }
        return this.deviceAction;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
        if (this.mgmt != null && this.mgmt.getDeviceFirmware() != null) {
            this.mgmt.getDeviceFirmware().setTypeId(typeId);
        }
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        if (this.mgmt != null && this.mgmt.getDeviceFirmware() != null) {
            this.mgmt.getDeviceFirmware().setDeviceId(deviceId);
        }
    }

    public Resource getResource(String name) {
        String[] token = name.split("\\.");
        Resource resource = this.root;
        for (int i = 0; i < token.length; ++i) {
            resource = resource.getChild(token[i]);
        }
        return resource;
    }

    public DeviceMetadata getMetadata() {
        return this.metadata;
    }

    public void setLocation(DeviceLocation location) {
        this.deviceLocation = location;
        this.root.add(location);
    }

    public static class Builder {
        private String typeId = null;
        private String deviceId = null;
        private DeviceInfo deviceInfo = null;
        private DeviceFirmware deviceFirmware = null;
        private DeviceMetadata metadata = null;

        public Builder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder deviceFirmware(DeviceFirmware deviceFirmware) {
            this.deviceFirmware = deviceFirmware;
            return this;
        }

        public Builder metadata(DeviceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public DeviceData build() {
            return new DeviceData(this);
        }
    }
}

