/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.iotf.devicemgmt.DeviceInfo;
import com.ibm.iotf.devicemgmt.resource.NumberResource;
import com.ibm.iotf.devicemgmt.resource.Resource;
import com.ibm.iotf.devicemgmt.resource.StringResource;
import java.util.Map;

public class DeviceFirmware
extends Resource {
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String URL = "uri";
    private static final String VERIFIER = "verifier";
    private static final String STATE = "state";
    private static final String UPDATE_STATUS = "updateStatus";
    public static final String RESOURCE_NAME = "firmware";
    private StringResource version;
    private StringResource name;
    private StringResource url;
    private StringResource verifier;
    private NumberResource state;
    private NumberResource updateStatus;
    private String deviceId;
    private String typeId;

    private DeviceFirmware(Builder builder) {
        super(RESOURCE_NAME);
        this.setVersion(builder.version, false);
        this.setUrl(builder.url, false);
        this.setVerifier(builder.verifier, false);
        this.setState(builder.state, false);
        this.setName(builder.name, false);
        this.setUpdateStatus(builder.updateStatus, false);
    }

    public int update(DeviceFirmware firmware) {
        return this.update((JsonElement)firmware.toJsonObject(), true);
    }

    @Override
    public int update(JsonElement firmware) {
        return this.update(firmware, true);
    }

    @Override
    public int update(JsonElement firmware, boolean fireEvent) {
        JsonObject json = (JsonObject)firmware;
        for (Map.Entry e : json.entrySet()) {
            Resource child = this.getChild((String)e.getKey());
            if (child != null) {
                child.update((JsonElement)e.getValue(), fireEvent);
                continue;
            }
            switch ((String)e.getKey()) {
                case "version": {
                    this.setVersion(((JsonElement)e.getValue()).getAsString(), fireEvent);
                    break;
                }
                case "name": {
                    this.setName(((JsonElement)e.getValue()).getAsString(), fireEvent);
                    break;
                }
                case "uri": {
                    this.setUrl(((JsonElement)e.getValue()).getAsString(), fireEvent);
                    break;
                }
                case "verifier": {
                    this.setVerifier(((JsonElement)e.getValue()).getAsString(), fireEvent);
                }
            }
        }
        this.fireEvent(fireEvent);
        return this.getRC();
    }

    public String getVersion() {
        if (this.version != null) {
            return (String)this.version.getValue();
        }
        return null;
    }

    public void setVersion(String version) {
        this.setVersion(version, true);
    }

    private void setVersion(String version, boolean fireEvent) {
        if (version == null) {
            return;
        }
        if (this.version == null) {
            this.version = new StringResource(VERSION, version);
            this.add(this.version);
        } else {
            this.version.setValue(version);
        }
        this.fireEvent(fireEvent);
    }

    public String getUrl() {
        if (this.url != null) {
            return (String)this.url.getValue();
        }
        return null;
    }

    public void setUrl(String url) {
        this.setUrl(url, true);
    }

    private void setUrl(String url, boolean fireEvent) {
        if (url == null) {
            return;
        }
        if (this.url == null) {
            this.url = new StringResource(URL, url);
            this.add(this.url);
        } else {
            this.url.setValue(url);
        }
        this.fireEvent(fireEvent);
    }

    public String getVerifier() {
        if (this.verifier != null) {
            return (String)this.verifier.getValue();
        }
        return null;
    }

    public void setVerifier(String verifier) {
        this.setVerifier(verifier, true);
    }

    private void setVerifier(String verifier, boolean fireEvent) {
        if (verifier == null) {
            return;
        }
        if (this.verifier == null) {
            this.verifier = new StringResource(VERIFIER, verifier);
            this.add(this.verifier);
        } else {
            this.verifier.setValue(verifier);
        }
        this.fireEvent(fireEvent);
    }

    public int getState() {
        return ((Number)this.state.getValue()).intValue();
    }

    public void setState(FirmwareState state) {
        this.setState(state, true);
    }

    private void setState(FirmwareState state, boolean fireEvent) {
        if (this.state == null) {
            this.state = state != null ? new NumberResource(STATE, state.getState()) : new NumberResource(STATE, FirmwareState.IDLE.getState());
            this.add(this.state);
        } else {
            this.state.setValue(state.getState());
        }
        this.fireEvent(fireEvent);
    }

    public String getName() {
        if (this.name != null) {
            return (String)this.name.getValue();
        }
        return null;
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean fireEvent) {
        if (name == null) {
            return;
        }
        if (this.name == null) {
            this.name = new StringResource(NAME, name);
            this.add(this.name);
        } else {
            this.name.setValue(name);
        }
        this.fireEvent(fireEvent);
    }

    public int getUpdateStatus() {
        return ((Number)this.updateStatus.getValue()).intValue();
    }

    public void setUpdateStatus(FirmwareUpdateStatus updateStatus) {
        this.setUpdateStatus(updateStatus, true);
        if (updateStatus == FirmwareUpdateStatus.SUCCESS) {
            Resource mgmt;
            Resource root;
            Resource deviceInfo;
            if (null != this.version && !"".equals(this.version) && (deviceInfo = (root = (mgmt = this.getParent()).getParent()).getChild("deviceInfo")) != null) {
                ((DeviceInfo)deviceInfo).setFwVersion(this.getVersion());
            }
            this.setVerifier(null, false);
        }
    }

    private void setUpdateStatus(FirmwareUpdateStatus updateStatus, boolean fireEvent) {
        if (this.updateStatus == null) {
            this.updateStatus = updateStatus != null ? new NumberResource(UPDATE_STATUS, updateStatus.getStatus()) : new NumberResource(UPDATE_STATUS, FirmwareUpdateStatus.SUCCESS.getStatus());
            this.add(this.updateStatus);
        } else {
            this.updateStatus.setValue(updateStatus.getStatus());
        }
        this.fireEvent(fireEvent);
    }

    public JsonObject toJsonObject() {
        JsonObject json = new JsonObject();
        if (this.name != null) {
            json.addProperty(this.name.getResourceName(), (String)this.name.getValue());
        }
        if (this.version != null) {
            json.addProperty(this.version.getResourceName(), (String)this.version.getValue());
        }
        if (this.url != null) {
            json.addProperty(this.url.getResourceName(), (String)this.url.getValue());
        }
        if (this.verifier != null) {
            json.addProperty(this.verifier.getResourceName(), (String)this.verifier.getValue());
        }
        if (this.state != null) {
            json.addProperty(this.state.getResourceName(), (Number)this.state.getValue());
        }
        if (this.updateStatus != null) {
            json.addProperty(this.updateStatus.getResourceName(), (Number)this.updateStatus.getValue());
        }
        return json;
    }

    public String toString() {
        return this.toJsonObject().toString();
    }

    void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public static class Builder {
        private String version;
        private String name;
        private String url;
        private String verifier;
        private FirmwareState state;
        private FirmwareUpdateStatus updateStatus;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder verifier(String verifier) {
            this.verifier = verifier;
            return this;
        }

        public Builder state(FirmwareState state) {
            this.state = state;
            return this;
        }

        public Builder updateStatus(FirmwareUpdateStatus updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        public DeviceFirmware build() {
            DeviceFirmware firmware = new DeviceFirmware(this);
            return firmware;
        }
    }

    public static enum FirmwareUpdateStatus {
        SUCCESS(0),
        IN_PROGRESS(1),
        OUT_OF_MEMORY(2),
        CONNECTION_LOST(3),
        VERIFICATION_FAILED(4),
        UNSUPPORTED_IMAGE(5),
        INVALID_URI(6);

        private final int status;

        private FirmwareUpdateStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static enum FirmwareState {
        IDLE(0),
        DOWNLOADING(1),
        DOWNLOADED(2);

        private final int state;

        private FirmwareState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }
}

