/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.iotf.devicemgmt.resource.Resource;
import com.ibm.iotf.devicemgmt.resource.StringResource;
import java.util.Map;

public class DeviceInfo
extends Resource {
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String MANUFACTURER = "manufacturer";
    private static final String MODEL = "model";
    private static final String DEVICE_CLASS = "deviceClass";
    private static final String DESCRIPTION = "description";
    private static final String FIRMWARE_VERSION = "fwVersion";
    private static final String HARDWARE_VERSION = "hwVersion";
    private static final String DESCRIPTIVE_LOCATION = "descriptiveLocation";
    private StringResource serialNumber;
    private StringResource manufacturer;
    private StringResource model;
    private StringResource deviceClass;
    private StringResource description;
    private StringResource fwVersion;
    private StringResource hwVersion;
    private StringResource descriptiveLocation;
    public static final String RESOURCE_NAME = "deviceInfo";

    private DeviceInfo(Builder builder) {
        super(RESOURCE_NAME);
        this.setSerialNumber(builder.serialNumber);
        this.setManufacturer(builder.manufacturer);
        this.setModel(builder.model);
        this.setDeviceClass(builder.deviceClass);
        this.setDescription(builder.description);
        this.setFwVersion(builder.fwVersion);
        this.setHwVersion(builder.hwVersion);
        this.setDescriptiveLocation(builder.descriptiveLocation);
    }

    public int update(DeviceInfo deviceInfo) {
        return this.update((JsonElement)deviceInfo.toJsonObject(), true);
    }

    @Override
    public int update(JsonElement deviceInfo) {
        return this.update(deviceInfo, true);
    }

    @Override
    public int update(JsonElement deviceInfo, boolean fireEvent) {
        JsonObject json = (JsonObject)deviceInfo;
        for (Map.Entry e : json.entrySet()) {
            Resource child = this.getChild((String)e.getKey());
            if (child != null) {
                child.update((JsonElement)e.getValue(), fireEvent);
                continue;
            }
            switch ((String)e.getKey()) {
                case "serialNumber": {
                    this.setSerialNumber(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "manufacturer": {
                    this.setManufacturer(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "deviceClass": {
                    this.setDeviceClass(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "fwVersion": {
                    this.setFwVersion(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "hwVersion": {
                    this.setHwVersion(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "model": {
                    this.setModel(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "description": {
                    this.setDescription(((JsonElement)e.getValue()).getAsString());
                    break;
                }
                case "descriptiveLocation": {
                    this.setDescriptiveLocation(((JsonElement)e.getValue()).getAsString());
                }
            }
        }
        this.fireEvent(fireEvent);
        return this.getRC();
    }

    public String getSerialNumber() {
        if (this.serialNumber == null) {
            return "";
        }
        return (String)this.serialNumber.getValue();
    }

    public void setSerialNumber(String serialNumber) {
        this.setSerialNumber(serialNumber, true);
    }

    private void setSerialNumber(String serialNumber, boolean fireEvent) {
        if (null == serialNumber) {
            return;
        }
        if (this.serialNumber == null) {
            this.serialNumber = new StringResource(SERIAL_NUMBER, serialNumber);
            this.add(this.serialNumber);
        }
        this.serialNumber.setValue(serialNumber);
        this.fireEvent(fireEvent);
    }

    public String getManufacturer() {
        if (this.manufacturer == null) {
            return "";
        }
        return (String)this.manufacturer.getValue();
    }

    public void setManufacturer(String manufacturer) {
        this.setManufacturer(manufacturer, true);
    }

    private void setManufacturer(String manufacturer, boolean fireEvent) {
        if (null == manufacturer) {
            return;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new StringResource(MANUFACTURER, manufacturer);
            this.add(this.manufacturer);
        }
        this.manufacturer.setValue(manufacturer);
        this.fireEvent(fireEvent);
    }

    public String getModel() {
        if (this.model == null) {
            return "";
        }
        return (String)this.model.getValue();
    }

    public void setModel(String model) {
        this.setModel(model, true);
    }

    private void setModel(String model, boolean fireEvent) {
        if (null == model) {
            return;
        }
        if (this.model == null) {
            this.model = new StringResource(MODEL, model);
            this.add(this.model);
        }
        this.model.setValue(model);
        this.fireEvent(fireEvent);
    }

    public String getDeviceClass() {
        if (this.deviceClass == null) {
            return "";
        }
        return (String)this.deviceClass.getValue();
    }

    public void setDeviceClass(String deviceClass) {
        this.setDeviceClass(deviceClass, true);
    }

    private void setDeviceClass(String deviceClass, boolean fireEvent) {
        if (null == deviceClass) {
            return;
        }
        if (this.deviceClass == null) {
            this.deviceClass = new StringResource(DEVICE_CLASS, deviceClass);
            this.add(this.deviceClass);
        }
        this.deviceClass.setValue(deviceClass);
        this.fireEvent(fireEvent);
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return (String)this.description.getValue();
    }

    public void setDescription(String description) {
        this.setDescription(description, true);
    }

    private void setDescription(String description, boolean fireEvent) {
        if (null == description) {
            return;
        }
        if (this.description == null) {
            this.description = new StringResource(DESCRIPTION, description);
            this.add(this.description);
        }
        this.description.setValue(description);
        this.fireEvent(fireEvent);
    }

    public String getFwVersion() {
        if (this.fwVersion == null) {
            return "";
        }
        return (String)this.fwVersion.getValue();
    }

    public void setFwVersion(String fwVersion) {
        this.setFwVersion(fwVersion, true);
    }

    private void setFwVersion(String fwVersion, boolean fireEvent) {
        if (null == fwVersion) {
            return;
        }
        if (this.fwVersion == null) {
            this.fwVersion = new StringResource(FIRMWARE_VERSION, fwVersion);
            this.add(this.fwVersion);
        }
        this.fwVersion.setValue(fwVersion);
        this.fireEvent(fireEvent);
    }

    public String getHwVersion() {
        if (this.hwVersion == null) {
            return "";
        }
        return (String)this.hwVersion.getValue();
    }

    public void setHwVersion(String hwVersion) {
        this.setHwVersion(hwVersion, true);
    }

    private void setHwVersion(String hwVersion, boolean fireEvent) {
        if (null == hwVersion) {
            return;
        }
        if (this.hwVersion == null) {
            this.hwVersion = new StringResource(HARDWARE_VERSION, hwVersion);
            this.add(this.hwVersion);
        }
        this.hwVersion.setValue(hwVersion);
        this.fireEvent(fireEvent);
    }

    public String getDescriptiveLocation() {
        if (this.descriptiveLocation == null) {
            return "";
        }
        return (String)this.descriptiveLocation.getValue();
    }

    public void setDescriptiveLocation(String descriptiveLocation) {
        this.setDescriptiveLocation(descriptiveLocation, true);
    }

    private void setDescriptiveLocation(String descriptiveLocation, boolean fireEvent) {
        if (descriptiveLocation == null) {
            return;
        }
        if (this.descriptiveLocation == null) {
            this.descriptiveLocation = new StringResource(DESCRIPTIVE_LOCATION, descriptiveLocation);
            this.add(this.descriptiveLocation);
        }
        this.descriptiveLocation.setValue(descriptiveLocation);
        this.fireEvent(fireEvent);
    }

    public JsonObject toJsonObject() {
        JsonObject json = new JsonObject();
        if (this.serialNumber != null) {
            json.add(this.serialNumber.getResourceName(), (JsonElement)new JsonPrimitive((String)this.serialNumber.getValue()));
        }
        if (this.manufacturer != null) {
            json.add(this.manufacturer.getResourceName(), (JsonElement)new JsonPrimitive((String)this.manufacturer.getValue()));
        }
        if (this.model != null) {
            json.add(this.model.getResourceName(), (JsonElement)new JsonPrimitive((String)this.model.getValue()));
        }
        if (this.deviceClass != null) {
            json.add(this.deviceClass.getResourceName(), (JsonElement)new JsonPrimitive((String)this.deviceClass.getValue()));
        }
        if (this.description != null) {
            json.add(this.description.getResourceName(), (JsonElement)new JsonPrimitive((String)this.description.getValue()));
        }
        if (this.fwVersion != null) {
            json.add(this.fwVersion.getResourceName(), (JsonElement)new JsonPrimitive((String)this.fwVersion.getValue()));
        }
        if (this.hwVersion != null) {
            json.add(this.hwVersion.getResourceName(), (JsonElement)new JsonPrimitive((String)this.hwVersion.getValue()));
        }
        if (this.descriptiveLocation != null) {
            json.add(this.descriptiveLocation.getResourceName(), (JsonElement)new JsonPrimitive((String)this.descriptiveLocation.getValue()));
        }
        return json;
    }

    public String toString() {
        return this.toJsonObject().toString();
    }

    public static class Builder {
        private String serialNumber;
        private String manufacturer;
        private String model;
        private String deviceClass;
        private String description;
        private String fwVersion;
        private String hwVersion;
        private String descriptiveLocation;

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder deviceClass(String deviceClass) {
            this.deviceClass = deviceClass;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder fwVersion(String fwVersion) {
            this.fwVersion = fwVersion;
            return this;
        }

        public Builder hwVersion(String hwVersion) {
            this.hwVersion = hwVersion;
            return this;
        }

        public Builder descriptiveLocation(String descriptiveLocation) {
            this.descriptiveLocation = descriptiveLocation;
            return this;
        }

        public DeviceInfo build() {
            DeviceInfo info = new DeviceInfo(this);
            return info;
        }
    }
}

