/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.iotf.devicemgmt.resource.DateResource;
import com.ibm.iotf.devicemgmt.resource.NumberResource;
import com.ibm.iotf.devicemgmt.resource.Resource;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DeviceLocation
extends Resource {
    public static final String RESOURCE_NAME = "location";
    private NumberResource latitude;
    private NumberResource longitude;
    private NumberResource elevation;
    private DateResource measuredDateTime;
    private NumberResource accuracy;
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String ELEVATION = "elevation";
    private static final String MEASUREDDATETIME = "measuredDateTime";
    private static final String ACCURACY = "accuracy";

    public DeviceLocation() {
        super(RESOURCE_NAME);
    }

    public double getLatitude() {
        return ((Number)this.latitude.getValue()).doubleValue();
    }

    public double getLongitude() {
        return ((Number)this.longitude.getValue()).doubleValue();
    }

    public double getElevation() {
        if (this.elevation != null) {
            return ((Number)this.elevation.getValue()).doubleValue();
        }
        return 0.0;
    }

    public Date getMeasuredDateTime() {
        return (Date)this.measuredDateTime.getValue();
    }

    public double getAccuracy() {
        if (this.accuracy != null) {
            return ((Number)this.accuracy.getValue()).doubleValue();
        }
        return 0.0;
    }

    public String toString() {
        return this.toJsonObject().toString();
    }

    @Override
    public int update(JsonElement fromLocation) {
        return this.update(fromLocation, true);
    }

    @Override
    public int update(JsonElement fromLocation, boolean fireEvent) {
        JsonObject json = (JsonObject)fromLocation;
        for (Map.Entry e : json.entrySet()) {
            Resource child = this.getChild((String)e.getKey());
            if (child != null) {
                child.update((JsonElement)e.getValue(), fireEvent);
                continue;
            }
            switch ((String)e.getKey()) {
                case "latitude": {
                    this.latitude = new NumberResource(LATITUDE, ((JsonElement)e.getValue()).getAsNumber());
                    this.add(this.latitude);
                    break;
                }
                case "longitude": {
                    this.longitude = new NumberResource(LONGITUDE, ((JsonElement)e.getValue()).getAsNumber());
                    this.add(this.longitude);
                    break;
                }
                case "elevation": {
                    this.elevation = new NumberResource(ELEVATION, ((JsonElement)e.getValue()).getAsNumber());
                    this.add(this.elevation);
                    break;
                }
                case "measuredDateTime": {
                    this.measuredDateTime = new DateResource(ACCURACY, new Date(((JsonElement)e.getValue()).getAsString()));
                    this.add(this.measuredDateTime);
                    break;
                }
                case "accuracy": {
                    this.accuracy = new NumberResource(ACCURACY, ((JsonElement)e.getValue()).getAsNumber());
                    this.add(this.accuracy);
                }
            }
        }
        this.fireEvent(true);
        return this.getRC();
    }

    public JsonObject toJsonObject() {
        JsonObject json = new JsonObject();
        json.addProperty(this.latitude.getResourceName(), (Number)this.latitude.getValue());
        json.addProperty(this.longitude.getResourceName(), (Number)this.longitude.getValue());
        if (this.elevation != null) {
            json.addProperty(this.elevation.getResourceName(), (Number)this.elevation.getValue());
        }
        String utcTime = DateFormatUtils.formatUTC((Date)((Date)this.measuredDateTime.getValue()), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        json.addProperty(this.measuredDateTime.getResourceName(), utcTime);
        if (this.accuracy != null) {
            json.addProperty(this.accuracy.getResourceName(), (Number)this.accuracy.getValue());
        }
        return json;
    }
}

