/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt.device;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.DMAgentTopic;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.device.DeviceDMAgentTopic;
import com.ibm.internal.iotf.devicemgmt.device.DeviceDMServerTopic;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.client.device.DeviceClient;
import com.ibm.iotf.devicemgmt.DeviceActionHandler;
import com.ibm.iotf.devicemgmt.DeviceData;
import com.ibm.iotf.devicemgmt.DeviceFirmwareHandler;
import com.ibm.iotf.devicemgmt.LogSeverity;
import com.ibm.iotf.util.LoggerUtility;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class ManagedDevice
extends DeviceClient
implements IMqttMessageListener,
Runnable {
    private static final String CLASS_NAME = ManagedDevice.class.getName();
    private static final int REGISTER_TIMEOUT_VALUE = 120000;
    private final SynchronousQueue<JsonObject> queue = new SynchronousQueue();
    private volatile boolean running = false;
    private BlockingQueue<JsonObject> publishQueue;
    JsonObject dummy = new JsonObject();
    private DeviceFirmwareHandler fwHandler = null;
    private DeviceActionHandler actionHandler = null;
    private Map<String, MqttMessage> requests = new HashMap<String, MqttMessage>();
    private DeviceData deviceData = null;
    private boolean supportDeviceActions = false;
    private boolean supportFirmwareActions = false;
    private boolean bManaged = false;
    private Date dormantTime;
    private String responseSubscription = null;
    private ManagedDeviceClient client;

    public ManagedDevice(Properties options, DeviceData deviceData) throws Exception {
        super(options);
        String METHOD = "constructor";
        if (deviceData == null) {
            LoggerUtility.log(Level.FINE, CLASS_NAME, "constructor", "Could not create Managed Client without DeviceInformations !");
            throw new Exception("Could not create Managed Client without DeviceInformations !");
        }
        String typeId = this.getDeviceType();
        String deviceId = this.getDeviceId();
        if (typeId == null || deviceId == null) {
            LoggerUtility.log(Level.FINE, CLASS_NAME, "constructor", "Could not create Managed Client without Device Type or Device ID !");
            throw new Exception("Could not create Managed Client without Device Type or Device ID!, Please specify the same in properties");
        }
        deviceData.setTypeId(typeId);
        deviceData.setDeviceId(deviceId);
        this.deviceData = deviceData;
        this.client = new ManagedDeviceClient(this);
    }

    public ManagedDevice(MqttClient client, DeviceData deviceData) throws Exception {
        super(client);
        this.client = new ManagedDeviceClient(this);
        this.setDeviceData(deviceData);
    }

    public ManagedDevice(MqttAsyncClient client, DeviceData deviceData) throws Exception {
        super(client);
        this.client = new ManagedDeviceClient(this);
        this.setDeviceData(deviceData);
    }

    private void setDeviceData(DeviceData deviceData) throws Exception {
        String METHOD = "setDeviceData";
        if (deviceData == null) {
            LoggerUtility.log(Level.FINE, CLASS_NAME, "setDeviceData", "Could not create Managed Client without DeviceInformations !");
            throw new Exception("Could not create Managed Client without DeviceInformations !");
        }
        String typeId = deviceData.getTypeId();
        String deviceId = deviceData.getDeviceId();
        if (typeId == null || deviceId == null) {
            LoggerUtility.log(Level.FINE, CLASS_NAME, "setDeviceData", "Could not create Managed Client without Device Type or Device ID!");
            throw new Exception("Could not create Managed Client without Device Type or Device ID!, Please specify the same in DeviceData");
        }
        this.deviceData = deviceData;
    }

    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    @Override
    public void connect() throws MqttException {
        String METHOD = "connect";
        if (this.isConnected()) {
            LoggerUtility.log(Level.WARNING, CLASS_NAME, "connect", "Device is already connected");
            return;
        }
        super.connect();
    }

    public boolean sendManageRequest(long lifetime, boolean supportFirmwareActions, boolean supportDeviceActions) throws MqttException {
        String METHOD = "manage";
        LoggerUtility.log(Level.FINE, CLASS_NAME, "manage", "lifetime(" + lifetime + "), supportFirmwareActions(" + supportFirmwareActions + "), supportDeviceActions(" + supportDeviceActions + ")");
        boolean success = false;
        String topic = this.client.getDMAgentTopic().getManageTopic();
        if (!this.isConnected()) {
            this.connect();
        }
        this.supportDeviceActions = supportDeviceActions;
        this.supportFirmwareActions = supportFirmwareActions;
        JsonObject jsonPayload = new JsonObject();
        JsonObject supports = new JsonObject();
        supports.add("deviceActions", (JsonElement)new JsonPrimitive(Boolean.valueOf(supportDeviceActions)));
        supports.add("firmwareActions", (JsonElement)new JsonPrimitive(Boolean.valueOf(supportFirmwareActions)));
        JsonObject data = new JsonObject();
        data.add("supports", (JsonElement)supports);
        if (this.deviceData.getDeviceInfo() != null) {
            data.add("deviceInfo", (JsonElement)this.deviceData.getDeviceInfo().toJsonObject());
        }
        if (this.deviceData.getMetadata() != null) {
            data.add("metadata", (JsonElement)this.deviceData.getMetadata().getMetadata());
        }
        if (lifetime > 0L) {
            data.add("lifetime", (JsonElement)new JsonPrimitive((Number)lifetime));
        }
        jsonPayload.add("d", (JsonElement)data);
        JsonObject jsonResponse = this.sendAndWait(topic, jsonPayload, 120000L);
        if (jsonResponse != null && jsonResponse.get("rc").getAsInt() == ResponseCode.DM_SUCCESS.getCode()) {
            DMRequestHandler.setRequestHandlers(this.client);
            if (!this.running) {
                this.publishQueue = new LinkedBlockingQueue<JsonObject>();
                Thread t = new Thread(this);
                t.start();
                this.running = true;
            }
            if (lifetime > 0L) {
                Date currentTime = new Date();
                this.dormantTime = new Date(currentTime.getTime() + lifetime * 1000L);
            }
            success = true;
        }
        LoggerUtility.log(Level.FINE, CLASS_NAME, "manage", "Success (" + success + ")");
        this.bManaged = success;
        return success;
    }

    public int updateLocation(Double latitude, Double longitude, Double elevation) {
        return this.updateLocation(latitude, longitude, elevation, new Date());
    }

    public int updateLocation(Double latitude, Double longitude, Double elevation, Date measuredDateTime) {
        return this.updateLocation(latitude, longitude, elevation, measuredDateTime, null);
    }

    public int updateLocation(Double latitude, Double longitude, Double elevation, Date measuredDateTime, Double accuracy) {
        String METHOD = "updateLocation";
        JsonObject jsonData = new JsonObject();
        JsonObject json = new JsonObject();
        json.addProperty("longitude", (Number)longitude);
        json.addProperty("latitude", (Number)latitude);
        if (elevation != null) {
            json.addProperty("elevation", (Number)elevation);
        }
        String utcTime = DateFormatUtils.formatUTC((Date)measuredDateTime, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        json.addProperty("measuredDateTime", utcTime);
        if (accuracy != null) {
            json.addProperty("accuracy", (Number)accuracy);
        }
        jsonData.add("d", (JsonElement)json);
        try {
            JsonObject response = this.sendAndWait(this.client.getDMAgentTopic().getUpdateLocationTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "updateLocation", e.toString());
        }
        return 0;
    }

    public int clearErrorCodes() {
        String METHOD = "clearErrorCodes";
        JsonObject jsonData = new JsonObject();
        try {
            JsonObject response = this.sendAndWait(this.client.getDMAgentTopic().getClearDiagErrorCodesTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "clearErrorCodes", e.toString());
        }
        return 0;
    }

    public int clearLogs() {
        String METHOD = "clearLogs";
        JsonObject jsonData = new JsonObject();
        try {
            JsonObject response = this.sendAndWait(this.client.getDMAgentTopic().getClearDiagLogsTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "clearLogs", e.toString());
        }
        return 0;
    }

    public int addErrorCode(int errorCode) {
        String METHOD = "addErrorCode";
        JsonObject jsonData = new JsonObject();
        JsonObject errorObj = new JsonObject();
        errorObj.addProperty("errorCode", (Number)errorCode);
        jsonData.add("d", (JsonElement)errorObj);
        try {
            JsonObject response = this.sendAndWait(this.client.getDMAgentTopic().getAddErrorCodesTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "addErrorCode", e.toString());
        }
        return 0;
    }

    public int addLog(String message, Date timestamp, LogSeverity severity) {
        return this.addLog(message, timestamp, severity, null);
    }

    public int addLog(String message, Date timestamp, LogSeverity severity, String data) {
        String METHOD = "addLog";
        JsonObject jsonData = new JsonObject();
        JsonObject log = new JsonObject();
        log.add("message", (JsonElement)new JsonPrimitive(message));
        log.add("severity", (JsonElement)new JsonPrimitive((Number)severity.getSeverity()));
        String utcTime = DateFormatUtils.formatUTC((Date)timestamp, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        log.add("timestamp", (JsonElement)new JsonPrimitive(utcTime));
        if (data != null) {
            byte[] encodedBytes = Base64.encodeBase64((byte[])data.getBytes());
            log.add("data", (JsonElement)new JsonPrimitive(new String(encodedBytes)));
        }
        jsonData.add("d", (JsonElement)log);
        try {
            JsonObject response = this.sendAndWait(this.client.getDMAgentTopic().getAddDiagLogTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "addLog", e.toString());
        }
        return 0;
    }

    public boolean sendUnmanageRequest() throws MqttException {
        JsonObject jsonPayload;
        String METHOD = "unmanage";
        boolean success = false;
        String topic = this.client.getDMAgentTopic().getUnmanageTopic();
        JsonObject jsonResponse = this.sendAndWait(topic, jsonPayload = new JsonObject(), 120000L);
        if (jsonResponse != null && jsonResponse.get("rc").getAsInt() == ResponseCode.DM_SUCCESS.getCode()) {
            success = true;
        }
        this.terminate();
        DMRequestHandler.clearRequestHandlers(this.client);
        this.terminateHandlers();
        if (this.responseSubscription != null) {
            this.unsubscribe(this.responseSubscription);
            this.responseSubscription = null;
        }
        LoggerUtility.log(Level.FINE, CLASS_NAME, "unmanage", "Success (" + success + ")");
        if (success) {
            this.bManaged = false;
        }
        return success;
    }

    public void subscribe(String topic, int qos, IMqttMessageListener listener) throws MqttException {
        String METHOD = "subscribe";
        LoggerUtility.fine(CLASS_NAME, "subscribe", "Topic(" + topic + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.subscribe(topic, qos, listener).waitForCompletion();
            } else if (this.mqttClient != null) {
                this.mqttClient.subscribe(topic, qos, listener);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "subscribe", "Will not subscribe to topic(" + topic + ") because MQTT client is not connected.");
        }
    }

    public void subscribe(String[] topics, int[] qos, IMqttMessageListener[] listeners) throws MqttException {
        String METHOD = "subscribe#2";
        LoggerUtility.fine(CLASS_NAME, "subscribe#2", "Topics(" + topics + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.subscribe(topics, qos, listeners).waitForCompletion();
            } else if (this.mqttClient != null) {
                this.mqttClient.subscribe(topics, qos, listeners);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "subscribe#2", "Will not subscribe to topics(" + topics + ") because MQTT client is not connected.");
        }
    }

    public void unsubscribe(String topic) throws MqttException {
        String METHOD = "unsubscribe";
        LoggerUtility.fine(CLASS_NAME, "unsubscribe", "Topic(" + topic + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.unsubscribe(topic);
            } else if (this.mqttClient != null) {
                this.mqttClient.unsubscribe(topic);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "unsubscribe", "Will not unsubscribe from topic(" + topic + ") because MQTT client is not connected.");
        }
    }

    public void unsubscribe(String[] topics) throws MqttException {
        String METHOD = "unsubscribe#2";
        LoggerUtility.fine(CLASS_NAME, "unsubscribe#2", "Topics(" + topics + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.unsubscribe(topics);
            } else if (this.mqttClient != null) {
                this.mqttClient.unsubscribe(topics);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "unsubscribe#2", "Will not unsubscribe from topics(" + topics + ") because MQTT client is not connected.");
        }
    }

    protected IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException {
        String METHOD = "publish";
        IMqttDeliveryToken token = null;
        LoggerUtility.fine(CLASS_NAME, "publish", "Topic(" + topic + ")");
        while (true) {
            if (this.isConnected()) {
                block15: {
                    try {
                        if (this.mqttAsyncClient != null) {
                            token = this.mqttAsyncClient.publish(topic, message);
                        } else if (this.mqttClient != null) {
                            this.mqttClient.publish(topic, message);
                        }
                    }
                    catch (MqttException ex) {
                        String payload = null;
                        try {
                            payload = new String(message.getPayload(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        if (!this.mqttAsyncClient.isConnected()) {
                            LoggerUtility.log(Level.WARNING, CLASS_NAME, "publish", " Connection Lost retrying to publish MSG :" + payload + " on topic " + topic + " every 5 seconds");
                            try {
                                Thread.sleep(5000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                break block15;
                            }
                        }
                        throw ex;
                    }
                }
                if (!this.isConnected()) {
                    LoggerUtility.log(Level.WARNING, CLASS_NAME, "publish", "MQTT got disconnected after publish to Topic(" + topic + ")");
                }
                return token;
            }
            LoggerUtility.warn(CLASS_NAME, "publish", ": Will not publish to topic(" + topic + ") because MQTT client is not connected.");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void publish(String topic, JsonObject payload, int qos) throws MqttException {
        String METHOD = "publish3";
        JsonObject jsonPubMsg = new JsonObject();
        jsonPubMsg.addProperty("topic", topic);
        jsonPubMsg.add("qos", (JsonElement)new JsonPrimitive((Number)qos));
        jsonPubMsg.add("payload", (JsonElement)payload);
        this.publishQueue.add(jsonPubMsg);
        LoggerUtility.log(Level.FINE, CLASS_NAME, "publish3", ": Queued Topic(" + topic + ") qos=" + qos + " payload (" + payload.toString() + ")");
    }

    private void publish(JsonObject jsonPubMsg) throws MqttException, UnsupportedEncodingException {
        String METHOD = "publish1";
        String topic = jsonPubMsg.get("topic").getAsString();
        int qos = jsonPubMsg.get("qos").getAsInt();
        JsonObject payload = jsonPubMsg.getAsJsonObject("payload");
        LoggerUtility.log(Level.FINE, CLASS_NAME, "publish1", ": Topic(" + topic + ") qos=" + qos + " payload (" + payload.toString() + ")");
        MqttMessage message = new MqttMessage();
        message.setPayload(payload.toString().getBytes("UTF-8"));
        message.setQos(qos);
        this.publish(topic, message);
    }

    public JsonObject sendAndWait(String topic, JsonObject jsonPayload, long timeout) throws MqttException {
        String METHOD = "sendAndWait";
        String uuid = UUID.randomUUID().toString();
        jsonPayload.add("reqId", (JsonElement)new JsonPrimitive(uuid));
        LoggerUtility.fine(CLASS_NAME, "sendAndWait", "Topic (" + topic + ") payload (" + jsonPayload.toString() + ") reqId (" + uuid + ")");
        if (this.responseSubscription == null) {
            this.responseSubscription = this.client.getDMServerTopic().getDMServerTopic();
            this.subscribe(this.responseSubscription, 1, this);
        }
        MqttMessage message = new MqttMessage();
        try {
            message.setPayload(jsonPayload.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "sendAndWait", "Error setting payload for topic: " + topic, e);
            return null;
        }
        message.setQos(1);
        this.requests.put(uuid, message);
        this.publish(topic, message);
        JsonObject jsonResponse = null;
        while (jsonResponse == null) {
            try {
                jsonResponse = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
                if (jsonResponse == null) break;
                if (jsonResponse.get("reqId").getAsString().equals(uuid)) {
                    LoggerUtility.fine(CLASS_NAME, "sendAndWait", "This response is for me reqId:" + jsonResponse.toString());
                    break;
                }
                LoggerUtility.warn(CLASS_NAME, "sendAndWait", "This response is NOT for me reqId:" + jsonResponse.toString());
                this.queue.add(jsonResponse);
                jsonResponse = null;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (jsonResponse == null) {
            LoggerUtility.warn(CLASS_NAME, "sendAndWait", "NO RESPONSE from Watson IoT Platform for request: " + jsonPayload.toString());
            LoggerUtility.warn(CLASS_NAME, "sendAndWait", "Connected(" + this.isConnected() + ")");
        }
        return jsonResponse;
    }

    @Override
    public void disconnect() {
        if (this.bManaged) {
            try {
                this.sendUnmanageRequest();
            }
            catch (MqttException mqttException) {
                // empty catch block
            }
            this.bManaged = false;
        }
        super.disconnect();
    }

    @Override
    protected void reconnect() {
        String METHOD = "reconnect";
        IMqttDeliveryToken[] tokens = this.mqttAsyncClient.getPendingDeliveryTokens();
        try {
            super.connect();
        }
        catch (MqttException e1) {
            e1.printStackTrace();
        }
        this.responseSubscription = null;
        if (this.isConnected() && this.bManaged) {
            long lifetime = 0L;
            if (this.dormantTime != null) {
                Date currentTime = new Date();
                lifetime = (this.dormantTime.getTime() - currentTime.getTime()) / 1000L;
                if (lifetime < 0L) {
                    lifetime = 0L;
                }
            }
            try {
                LoggerUtility.log(Level.FINE, CLASS_NAME, METHOD, "lifetime (" + lifetime + ")");
                this.sendManageRequest(lifetime, this.supportFirmwareActions, this.supportDeviceActions);
                if (tokens != null) {
                    LoggerUtility.log(Level.FINE, CLASS_NAME, METHOD, "Republishing messages start");
                    for (int i = 0; i < tokens.length; ++i) {
                        try {
                            MqttMessage msg = tokens[i].getMessage();
                            this.mqttAsyncClient.publish(tokens[i].getTopics()[0], msg);
                            continue;
                        }
                        catch (MqttException e) {
                            e.printStackTrace();
                        }
                    }
                    LoggerUtility.log(Level.FINE, CLASS_NAME, METHOD, "Republishing messages End");
                }
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        block6: {
            String METHOD = "messageArrived";
            if (topic.equals(this.client.getDMServerTopic().getDMServerTopic())) {
                LoggerUtility.log(Level.FINE, CLASS_NAME, "messageArrived", "Received response from Watson IoT Platform, topic (" + topic + ")");
                String responsePayload = new String(message.getPayload(), "UTF-8");
                JsonObject jsonResponse = new JsonParser().parse(responsePayload).getAsJsonObject();
                try {
                    String reqId = jsonResponse.get("reqId").getAsString();
                    LoggerUtility.fine(CLASS_NAME, "messageArrived", "reqId (" + reqId + "): " + jsonResponse.toString());
                    MqttMessage sentMsg = this.requests.remove(reqId);
                    if (sentMsg != null) {
                        this.queue.put(jsonResponse);
                    }
                }
                catch (Exception e) {
                    if (jsonResponse.get("reqId") == null) {
                        LoggerUtility.warn(CLASS_NAME, "messageArrived", "The response does not contain 'reqId' field (" + responsePayload + ")");
                        break block6;
                    }
                    LoggerUtility.log(Level.SEVERE, CLASS_NAME, "messageArrived", "Unexpected exception", e);
                }
            } else {
                LoggerUtility.warn(CLASS_NAME, "messageArrived", "Unknown topic (" + topic + ")");
            }
        }
    }

    @Override
    public void run() {
        String METHOD = "run";
        this.running = true;
        LoggerUtility.log(Level.FINE, CLASS_NAME, "run", "Running...");
        while (this.running) {
            try {
                JsonObject o = this.publishQueue.take();
                if (o.equals((Object)this.dummy)) {
                    LoggerUtility.log(Level.FINE, CLASS_NAME, "run", "It is time to quit.");
                    continue;
                }
                this.publish(o);
            }
            catch (Exception e) {
                LoggerUtility.log(Level.SEVERE, CLASS_NAME, "run", e.toString());
                e.printStackTrace();
                this.running = false;
            }
        }
        LoggerUtility.log(Level.FINE, CLASS_NAME, "run", "Exiting...");
    }

    private void terminate() {
        this.running = false;
        try {
            this.publishQueue.put(this.dummy);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addFirmwareHandler(DeviceFirmwareHandler fwHandler) throws Exception {
        String METHOD = "addFirmwareHandler";
        if (this.fwHandler != null) {
            LoggerUtility.severe(CLASS_NAME, "addFirmwareHandler", "Firmware Handler is already set, so can not add the new firmware handler !");
            throw new Exception("Firmware Handler is already set, so can not add the new firmware handler !");
        }
        this.fwHandler = fwHandler;
    }

    public void addDeviceActionHandler(DeviceActionHandler actionHandler) throws Exception {
        String METHOD = "addDeviceActionHandler";
        if (this.actionHandler != null) {
            LoggerUtility.severe(CLASS_NAME, "addDeviceActionHandler", "Action Handler is already set, so can not add the new Action handler !");
            throw new Exception("Action Handler is already set, so can not add the new Action handler !");
        }
        this.actionHandler = actionHandler;
    }

    private void terminateHandlers() {
        this.fwHandler = null;
        this.actionHandler = null;
    }

    private class ManagedDeviceClient
    implements ManagedClient {
        private ManagedDevice dmClient;
        private DMAgentTopic deviceDMAgentTopic;
        private DMServerTopic deviceDMServerTopic;

        private ManagedDeviceClient(ManagedDevice dmClient) {
            this.dmClient = dmClient;
            this.deviceDMAgentTopic = DeviceDMAgentTopic.getInstance();
            this.deviceDMServerTopic = DeviceDMServerTopic.getInstance();
        }

        @Override
        public void subscribe(String topic, int qos, IMqttMessageListener iMqttMessageListener) throws MqttException {
            this.dmClient.subscribe(topic, qos, iMqttMessageListener);
        }

        @Override
        public void unsubscribe(String topic) throws MqttException {
            this.dmClient.unsubscribe(topic);
        }

        @Override
        public void publish(String response, JsonObject payload, int qos) throws MqttException {
            this.dmClient.publish(response, payload, qos);
        }

        @Override
        public DeviceData getDeviceData() {
            return this.dmClient.getDeviceData();
        }

        @Override
        public void subscribe(String[] topics, int[] qos, IMqttMessageListener[] listener) throws MqttException {
            this.dmClient.subscribe(topics, qos, listener);
        }

        @Override
        public void unsubscribe(String[] topics) throws MqttException {
            this.dmClient.unsubscribe(topics);
        }

        @Override
        public DMAgentTopic getDMAgentTopic() {
            return this.deviceDMAgentTopic;
        }

        @Override
        public DMServerTopic getDMServerTopic() {
            return this.deviceDMServerTopic;
        }

        @Override
        public DeviceActionHandler getActionHandler() {
            return this.dmClient.actionHandler;
        }

        @Override
        public DeviceFirmwareHandler getFirmwareHandler() {
            return this.dmClient.fwHandler;
        }
    }
}

