/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt.gateway;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.internal.iotf.devicemgmt.DMAgentTopic;
import com.ibm.internal.iotf.devicemgmt.DMServerTopic;
import com.ibm.internal.iotf.devicemgmt.ManagedClient;
import com.ibm.internal.iotf.devicemgmt.ResponseCode;
import com.ibm.internal.iotf.devicemgmt.gateway.GatewayDMAgentTopic;
import com.ibm.internal.iotf.devicemgmt.gateway.GatewayDMServerTopic;
import com.ibm.internal.iotf.devicemgmt.handler.DMRequestHandler;
import com.ibm.iotf.client.gateway.GatewayClient;
import com.ibm.iotf.devicemgmt.DeviceActionHandler;
import com.ibm.iotf.devicemgmt.DeviceData;
import com.ibm.iotf.devicemgmt.DeviceFirmwareHandler;
import com.ibm.iotf.devicemgmt.LogSeverity;
import com.ibm.iotf.util.LoggerUtility;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class ManagedGateway
extends GatewayClient
implements IMqttMessageListener,
Runnable {
    private static final String CLASS_NAME = ManagedGateway.class.getName();
    private static final int REGISTER_TIMEOUT_VALUE = 120000;
    private final BlockingQueue<JsonObject> queue = new LinkedBlockingQueue<JsonObject>();
    private final Map<String, ManagedClient> devicesMap = new HashMap<String, ManagedClient>();
    private final BlockingQueue<JsonObject> publishQueue = new LinkedBlockingQueue<JsonObject>();
    private static final Pattern GATEWAY_COMMAND_PATTERN = Pattern.compile("iot-2/type/(.+)/id/(.+)/cmd/(.+)/fmt/(.+)");
    private static final Pattern GATEWAY_RESPONSE_PATTERN = Pattern.compile("iotdm-1/type/(.+)/id/(.+)/response");
    private static final String GATEWAY_RESPONSE_TOPIC = "iotdm-1/type/+/id/+/response";
    private volatile boolean running = false;
    private JsonObject dummy = new JsonObject();
    private ManagedGatewayDevice gateway;
    private final String gatewayKey;
    private DeviceFirmwareHandler fwHandler = null;
    private DeviceActionHandler actionHandler = null;
    private Map<String, MqttMessage> requests = new HashMap<String, MqttMessage>();
    private boolean reponseSubscription;

    public ManagedGateway(Properties options, DeviceData deviceData) throws Exception {
        super(options);
        ManagedGatewayDevice mc;
        String METHOD = "constructor";
        if (deviceData == null) {
            LoggerUtility.log(Level.FINE, CLASS_NAME, "constructor", "Could not create Managed Client without DeviceInformations !");
            throw new Exception("Could not create Managed Client without DeviceInformations !");
        }
        String typeId = this.getGWDeviceType();
        String deviceId = this.getGWDeviceId();
        if (typeId == null || deviceId == null) {
            LoggerUtility.log(Level.FINE, CLASS_NAME, "constructor", "Could not create Managed Client without Device Type or Device ID !");
            throw new Exception("Could not create Managed Client without Device Type or Device ID!, Please specify the same in properties");
        }
        deviceData.setTypeId(typeId);
        deviceData.setDeviceId(deviceId);
        this.gateway = mc = new ManagedGatewayDevice(this, deviceData);
        this.gatewayKey = typeId + ':' + deviceId;
    }

    public ManagedGateway(MqttClient client, DeviceData deviceData) throws Exception {
        super(client);
        this.gateway = new ManagedGatewayDevice(this, deviceData);
        this.gatewayKey = deviceData.getTypeId() + ':' + deviceData.getDeviceId();
    }

    public ManagedGateway(MqttAsyncClient client, DeviceData deviceData) throws Exception {
        super(client);
        this.gateway = new ManagedGatewayDevice(this, deviceData);
        this.gatewayKey = deviceData.getTypeId() + ':' + deviceData.getDeviceId();
    }

    @Override
    public void connect() throws MqttException {
        String METHOD = "connect";
        if (this.isConnected()) {
            LoggerUtility.log(Level.WARNING, CLASS_NAME, "connect", "Gateway device is already connected");
            return;
        }
        super.connect();
    }

    public DeviceData getGatewayDeviceData() {
        if (this.gateway != null) {
            return this.gateway.getDeviceData();
        }
        return null;
    }

    public DeviceData getAttachedDeviceData(String typeId, String deviceId) {
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            return null;
        }
        return mc.getDeviceData();
    }

    public boolean sendGatewayManageRequest(long lifetime, boolean supportFirmwareActions, boolean supportDeviceActions) throws MqttException {
        if (!this.devicesMap.containsKey(this.gatewayKey)) {
            this.devicesMap.put(this.gatewayKey, this.gateway);
        }
        return this.sendDeviceManageRequest(this.getGWDeviceType(), this.getGWDeviceId(), this.gateway.getDeviceData(), lifetime, supportFirmwareActions, supportDeviceActions);
    }

    public boolean sendDeviceManageRequest(String typeId, String deviceId, long lifetime, boolean supportFirmwareActions, boolean supportDeviceActions) throws MqttException {
        return this.sendDeviceManageRequest(typeId, deviceId, null, lifetime, supportFirmwareActions, supportDeviceActions);
    }

    public boolean sendDeviceManageRequest(String typeId, String deviceId, DeviceData deviceData, long lifetime, boolean supportFirmwareActions, boolean supportDeviceActions) throws MqttException {
        String METHOD = "manage";
        LoggerUtility.log(Level.FINE, CLASS_NAME, "manage", "typeId(" + typeId + "), deviceId (" + deviceId + "), lifetime value(" + lifetime + ")");
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            if (deviceData == null) {
                deviceData = new DeviceData.Builder().typeId(typeId).deviceId(deviceId).build();
            }
            mc = new ManagedGatewayDevice(this, deviceData, supportFirmwareActions, supportDeviceActions);
        } else {
            mc.setSupportsFirmwareActions(supportFirmwareActions);
            mc.setSupportDeviceActions(supportDeviceActions);
        }
        if (!this.reponseSubscription) {
            this.subscribe(GATEWAY_RESPONSE_TOPIC, 1, this);
            this.reponseSubscription = true;
        }
        boolean success = false;
        String topic = mc.getDMAgentTopic().getManageTopic();
        if (!this.isConnected()) {
            this.connect();
        }
        JsonObject jsonPayload = new JsonObject();
        JsonObject supports = new JsonObject();
        supports.add("deviceActions", (JsonElement)new JsonPrimitive(Boolean.valueOf(supportDeviceActions)));
        supports.add("firmwareActions", (JsonElement)new JsonPrimitive(Boolean.valueOf(supportFirmwareActions)));
        JsonObject data = new JsonObject();
        data.add("supports", (JsonElement)supports);
        if (mc.getDeviceData().getDeviceInfo() != null) {
            data.add("deviceInfo", (JsonElement)mc.getDeviceData().getDeviceInfo().toJsonObject());
        }
        if (mc.getDeviceData().getMetadata() != null) {
            data.add("metadata", (JsonElement)mc.getDeviceData().getMetadata().getMetadata());
        }
        data.add("lifetime", (JsonElement)new JsonPrimitive((Number)lifetime));
        jsonPayload.add("d", (JsonElement)data);
        JsonObject jsonResponse = this.sendAndWait(topic, jsonPayload, 120000L);
        if (jsonResponse != null && jsonResponse.get("rc").getAsInt() == ResponseCode.DM_SUCCESS.getCode()) {
            DMRequestHandler.setRequestHandlers(mc);
            if (!this.running) {
                Thread t = new Thread(this);
                t.start();
                this.running = true;
            }
            if (lifetime > 0L) {
                Date currentTime = new Date();
                mc.setDormantTime(new Date(currentTime.getTime() + lifetime * 1000L));
            }
            success = true;
            this.devicesMap.put(key, mc);
        }
        LoggerUtility.log(Level.FINE, CLASS_NAME, "manage", "Success (" + success + ")");
        mc.setbManaged(success);
        return success;
    }

    public int updateGatewayLocation(Double latitude, Double longitude, Double elevation) {
        return this.updateDeviceLocation(this.getGWDeviceType(), this.getGWDeviceId(), latitude, longitude, elevation, new Date(), null, null);
    }

    public int updateDeviceLocation(String typeId, String deviceId, Double latitude, Double longitude, Double elevation) {
        return this.updateDeviceLocation(typeId, deviceId, latitude, longitude, elevation, new Date(), null, null);
    }

    public int updateGatewayLocation(Double latitude, Double longitude, Double elevation, Date measuredDateTime) {
        return this.updateDeviceLocation(this.getGWDeviceType(), this.getGWDeviceId(), latitude, longitude, elevation, measuredDateTime, null, null);
    }

    public int updateDeviceLocation(String typeId, String deviceId, Double latitude, Double longitude, Double elevation, Date measuredDateTime) {
        return this.updateDeviceLocation(typeId, deviceId, latitude, longitude, elevation, measuredDateTime, null, null);
    }

    public int updateGatewayLocation(Double latitude, Double longitude, Double elevation, Date measuredDateTime, Date updatedDateTime, Double accuracy) {
        return this.updateDeviceLocation(this.getGWDeviceType(), this.getGWDeviceId(), latitude, longitude, elevation, measuredDateTime, updatedDateTime, accuracy);
    }

    public int updateDeviceLocation(String typeId, String deviceId, Double latitude, Double longitude, Double elevation, Date measuredDateTime, Date updatedDateTime, Double accuracy) {
        String METHOD = "updateLocation";
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "updateLocation", "The device is not a managed device, so can not send the request");
            return -1;
        }
        JsonObject jsonData = new JsonObject();
        JsonObject json = new JsonObject();
        json.addProperty("longitude", (Number)longitude);
        json.addProperty("latitude", (Number)latitude);
        if (elevation != null) {
            json.addProperty("elevation", (Number)elevation);
        }
        String utcTime = DateFormatUtils.formatUTC((Date)measuredDateTime, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        json.addProperty("measuredDateTime", utcTime);
        if (updatedDateTime != null) {
            utcTime = DateFormatUtils.formatUTC((Date)updatedDateTime, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
            json.addProperty("updatedDateTime", utcTime);
        }
        if (accuracy != null) {
            json.addProperty("accuracy", (Number)accuracy);
        }
        jsonData.add("d", (JsonElement)json);
        try {
            JsonObject response = this.sendAndWait(mc.getDMAgentTopic().getUpdateLocationTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "updateLocation", e.toString());
        }
        return 0;
    }

    public int clearGatewayErrorCodes() {
        return this.clearDeviceErrorCodes(this.getGWDeviceType(), this.getGWDeviceId());
    }

    public int clearDeviceErrorCodes(String typeId, String deviceId) {
        String METHOD = "clearErrorCodes";
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "clearErrorCodes", "The device is not a managed device, so can not send the request");
            return -1;
        }
        JsonObject jsonData = new JsonObject();
        try {
            JsonObject response = this.sendAndWait(mc.getDMAgentTopic().getClearDiagErrorCodesTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "clearErrorCodes", e.toString());
        }
        return 0;
    }

    public int clearGatewayLogs() {
        return this.clearDeviceLogs(this.getGWDeviceType(), this.getGWDeviceId());
    }

    public int clearDeviceLogs(String typeId, String deviceId) {
        String METHOD = "clearLogs";
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "clearLogs", "The device is not a managed device, so can not send the request");
            return -1;
        }
        JsonObject jsonData = new JsonObject();
        try {
            JsonObject response = this.sendAndWait(mc.getDMAgentTopic().getClearDiagLogsTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "clearLogs", e.toString());
        }
        return 0;
    }

    public int addGatewayErrorCode(int errorCode) {
        return this.addDeviceErrorCode(this.getGWDeviceType(), this.getGWDeviceId(), errorCode);
    }

    public int addDeviceErrorCode(String typeId, String deviceId, int errorCode) {
        String METHOD = "addErrorCode";
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "addErrorCode", "The device is not a managed device, so can not send the request");
            return -1;
        }
        JsonObject jsonData = new JsonObject();
        JsonObject errorObj = new JsonObject();
        errorObj.addProperty("errorCode", (Number)errorCode);
        jsonData.add("d", (JsonElement)errorObj);
        try {
            JsonObject response = this.sendAndWait(mc.getDMAgentTopic().getAddErrorCodesTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "addErrorCode", e.toString());
        }
        return 0;
    }

    public int addGatewayLog(String message, Date timestamp, LogSeverity severity) {
        return this.addDeviceLog(this.getGWDeviceType(), this.getGWDeviceId(), message, timestamp, severity, null);
    }

    public int addGatewayLog(String message, Date timestamp, LogSeverity severity, String data) {
        return this.addDeviceLog(this.getGWDeviceType(), this.getGWDeviceId(), message, timestamp, severity, data);
    }

    public int addDeviceLog(String typeId, String deviceId, String message, Date timestamp, LogSeverity severity) {
        return this.addDeviceLog(typeId, deviceId, message, timestamp, severity, null);
    }

    public int addDeviceLog(String typeId, String deviceId, String message, Date timestamp, LogSeverity severity, String data) {
        String METHOD = "addDeviceLog";
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(key);
        if (mc == null) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "addDeviceLog", "The device is not a managed device, so can not send the request");
            return -1;
        }
        JsonObject jsonData = new JsonObject();
        JsonObject log = new JsonObject();
        log.add("message", (JsonElement)new JsonPrimitive(message));
        log.add("severity", (JsonElement)new JsonPrimitive((Number)severity.getSeverity()));
        String utcTime = DateFormatUtils.formatUTC((Date)timestamp, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        log.add("timestamp", (JsonElement)new JsonPrimitive(utcTime));
        if (data != null) {
            byte[] encodedBytes = Base64.encodeBase64((byte[])data.getBytes());
            log.add("data", (JsonElement)new JsonPrimitive(new String(encodedBytes)));
        }
        jsonData.add("d", (JsonElement)log);
        try {
            JsonObject response = this.sendAndWait(mc.getDMAgentTopic().getAddDiagLogTopic(), jsonData, 120000L);
            if (response != null) {
                return response.get("rc").getAsInt();
            }
        }
        catch (MqttException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "addDeviceLog", e.toString());
        }
        return 0;
    }

    public boolean sendGatewayUnmanageRequet() throws MqttException {
        return this.sendDeviceUnmanageRequet(this.getGWDeviceType(), this.getGWDeviceId());
    }

    public boolean sendDeviceUnmanageRequet(String typeId, String deviceId) throws MqttException {
        String METHOD = "unmanage";
        String key = typeId + ':' + deviceId;
        ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.remove(key);
        if (mc == null) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "unmanage", "The device is not a managed device, so can not send the request");
            return false;
        }
        return this.sendUnManageRequest(mc);
    }

    private boolean sendUnManageRequest(ManagedGatewayDevice mc) throws MqttException {
        JsonObject jsonPayload;
        String METHOD = "sendUnManageRequest";
        boolean success = false;
        String topic = mc.gatewayDMAgentTopic.getUnmanageTopic();
        JsonObject jsonResponse = this.sendAndWait(topic, jsonPayload = new JsonObject(), 120000L);
        if (jsonResponse != null && jsonResponse.get("rc").getAsInt() == ResponseCode.DM_SUCCESS.getCode()) {
            success = true;
        }
        DMRequestHandler.clearRequestHandlers(mc);
        if (this.devicesMap.size() == 0) {
            this.unsubscribe(GATEWAY_RESPONSE_TOPIC);
            this.terminate();
            this.reponseSubscription = false;
        }
        LoggerUtility.log(Level.FINE, CLASS_NAME, "sendUnManageRequest", "Success (" + success + ")");
        if (success) {
            mc.setbManaged(false);
        }
        return success;
    }

    private void subscribe(String topic, int qos, IMqttMessageListener listener) throws MqttException {
        String METHOD = "subscribe";
        LoggerUtility.fine(CLASS_NAME, "subscribe", "Topic(" + topic + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.subscribe(topic, qos, listener);
            } else if (this.mqttClient != null) {
                this.mqttClient.subscribe(topic, qos, listener);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "subscribe", "Will not subscribe to topic(" + topic + ") because MQTT client is not connected.");
        }
    }

    private void subscribe(String[] topics, int[] qos, IMqttMessageListener[] listeners) throws MqttException {
        String METHOD = "subscribe#2";
        LoggerUtility.fine(CLASS_NAME, "subscribe#2", "Topics(" + topics + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.subscribe(topics, qos, listeners);
            } else if (this.mqttClient != null) {
                this.mqttClient.subscribe(topics, qos, listeners);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "subscribe#2", "Will not subscribe to topics(" + topics + ") because MQTT client is not connected.");
        }
    }

    private void unsubscribe(String topic) throws MqttException {
        String METHOD = "unsubscribe";
        LoggerUtility.fine(CLASS_NAME, "unsubscribe", "Topic(" + topic + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.unsubscribe(topic);
            } else if (this.mqttClient != null) {
                this.mqttClient.unsubscribe(topic);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "unsubscribe", "Will not unsubscribe from topic(" + topic + ") because MQTT client is not connected.");
        }
    }

    private void unsubscribe(String[] topics) throws MqttException {
        String METHOD = "unsubscribe#2";
        LoggerUtility.fine(CLASS_NAME, "unsubscribe#2", "Topics(" + topics + ")");
        if (this.isConnected()) {
            if (this.mqttAsyncClient != null) {
                this.mqttAsyncClient.unsubscribe(topics);
            } else if (this.mqttClient != null) {
                this.mqttClient.unsubscribe(topics);
            }
        } else {
            LoggerUtility.warn(CLASS_NAME, "unsubscribe#2", "Will not unsubscribe from topics(" + topics + ") because MQTT client is not connected.");
        }
    }

    protected IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException {
        String METHOD = "publish";
        IMqttDeliveryToken token = null;
        LoggerUtility.fine(CLASS_NAME, "publish", "Topic(" + topic + ")");
        while (true) {
            if (this.isConnected()) {
                block15: {
                    try {
                        if (this.mqttAsyncClient != null) {
                            token = this.mqttAsyncClient.publish(topic, message);
                        } else if (this.mqttClient != null) {
                            this.mqttClient.publish(topic, message);
                        }
                    }
                    catch (MqttException ex) {
                        String payload = null;
                        try {
                            payload = new String(message.getPayload(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        if (!this.mqttAsyncClient.isConnected()) {
                            LoggerUtility.log(Level.WARNING, CLASS_NAME, "publish", " Connection Lost retrying to publish MSG :" + payload + " on topic " + topic + " every 5 seconds");
                            try {
                                Thread.sleep(5000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                break block15;
                            }
                        }
                        throw ex;
                    }
                }
                if (!this.isConnected()) {
                    LoggerUtility.log(Level.WARNING, CLASS_NAME, "publish", "MQTT got disconnected after publish to Topic(" + topic + ")");
                }
                return token;
            }
            LoggerUtility.warn(CLASS_NAME, "publish", ": Will not publish to topic(" + topic + ") because MQTT client is not connected.");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void publish(String topic, JsonObject payload, int qos) throws MqttException {
        String METHOD = "publish3";
        JsonObject jsonPubMsg = new JsonObject();
        jsonPubMsg.addProperty("topic", topic);
        jsonPubMsg.add("qos", (JsonElement)new JsonPrimitive((Number)qos));
        jsonPubMsg.add("payload", (JsonElement)payload);
        this.publishQueue.add(jsonPubMsg);
        LoggerUtility.log(Level.FINE, CLASS_NAME, "publish3", ": Queued Topic(" + topic + ") qos=" + qos + " payload (" + payload.toString() + ")");
    }

    private void publish(JsonObject jsonPubMsg) throws MqttException, UnsupportedEncodingException {
        String METHOD = "publish1";
        String topic = jsonPubMsg.get("topic").getAsString();
        int qos = jsonPubMsg.get("qos").getAsInt();
        JsonObject payload = jsonPubMsg.getAsJsonObject("payload");
        LoggerUtility.log(Level.FINE, CLASS_NAME, "publish1", ": Topic(" + topic + ") qos=" + qos + " payload (" + payload.toString() + ")");
        MqttMessage message = new MqttMessage();
        message.setPayload(payload.toString().getBytes("UTF-8"));
        message.setQos(qos);
        this.publish(topic, message);
    }

    private JsonObject sendAndWait(String topic, JsonObject jsonPayload, long timeout) throws MqttException {
        String METHOD = "sendAndWait";
        String uuid = UUID.randomUUID().toString();
        jsonPayload.add("reqId", (JsonElement)new JsonPrimitive(uuid));
        LoggerUtility.fine(CLASS_NAME, "sendAndWait", "Topic (" + topic + ") payload (" + jsonPayload.toString() + ") reqId (" + uuid + ")");
        MqttMessage message = new MqttMessage();
        try {
            message.setPayload(jsonPayload.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtility.log(Level.SEVERE, CLASS_NAME, "sendAndWait", "Error setting payload for topic: " + topic, e);
            return null;
        }
        message.setQos(1);
        this.requests.put(uuid, message);
        this.publish(topic, message);
        JsonObject jsonResponse = null;
        while (jsonResponse == null) {
            try {
                jsonResponse = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
                if (jsonResponse == null) break;
                if (jsonResponse.get("reqId").getAsString().equals(uuid)) {
                    LoggerUtility.fine(CLASS_NAME, "sendAndWait", "This response is for me reqId:" + jsonResponse.toString());
                    break;
                }
                this.queue.add(jsonResponse);
                jsonResponse = null;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (jsonResponse == null) {
            LoggerUtility.warn(CLASS_NAME, "sendAndWait", "NO RESPONSE from Watson IoT Platform for request: " + jsonPayload.toString());
            LoggerUtility.warn(CLASS_NAME, "sendAndWait", "Connected(" + this.isConnected() + ")");
        }
        return jsonResponse;
    }

    @Override
    public void disconnect() {
        Set<String> devices = this.devicesMap.keySet();
        Iterator<String> itr = devices.iterator();
        while (itr.hasNext()) {
            ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(itr.next());
            if (mc == null || !mc.bManaged) continue;
            try {
                this.sendUnManageRequest(mc);
                itr.remove();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
        this.terminateHandlers();
        super.disconnect();
    }

    @Override
    protected void reconnect() {
        String METHOD = "reconnect";
        IMqttDeliveryToken[] tokens = this.mqttAsyncClient.getPendingDeliveryTokens();
        try {
            super.connect();
        }
        catch (MqttException e1) {
            e1.printStackTrace();
        }
        this.reponseSubscription = false;
        if (this.isConnected()) {
            Set<String> devices = this.devicesMap.keySet();
            Iterator<String> itr = devices.iterator();
            while (itr.hasNext()) {
                ManagedGatewayDevice mc = (ManagedGatewayDevice)this.devicesMap.get(itr.next());
                if (mc == null || !mc.bManaged) continue;
                try {
                    long lifetime = 0L;
                    if (mc.getDormantTime() != null) {
                        Date currentTime = new Date();
                        lifetime = (mc.getDormantTime().getTime() - currentTime.getTime()) / 1000L;
                        if (lifetime < 0L) {
                            lifetime = 0L;
                        }
                    }
                    LoggerUtility.log(Level.FINE, CLASS_NAME, METHOD, "lifetime (" + lifetime + ")");
                    this.sendDeviceManageRequest(mc.getTypeId(), mc.getDeviceId(), lifetime, mc.isFirmwareActions(), mc.isDeviceActions());
                }
                catch (MqttException e) {
                    e.printStackTrace();
                }
            }
            if (tokens != null) {
                LoggerUtility.log(Level.FINE, CLASS_NAME, METHOD, "Republishing messages start");
                for (int i = 0; i < tokens.length; ++i) {
                    try {
                        MqttMessage msg = tokens[i].getMessage();
                        this.mqttAsyncClient.publish(tokens[i].getTopics()[0], msg);
                        continue;
                    }
                    catch (MqttException e) {
                        e.printStackTrace();
                    }
                }
                LoggerUtility.log(Level.FINE, CLASS_NAME, METHOD, "Republishing messages End");
            }
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        block7: {
            String METHOD = "messageArrived";
            Matcher matcher = GATEWAY_RESPONSE_PATTERN.matcher(topic);
            if (matcher.matches()) {
                LoggerUtility.log(Level.FINE, CLASS_NAME, "messageArrived", "Received response from IBM Watson IoT Platform, topic (" + topic + ")");
                String responsePayload = new String(message.getPayload(), "UTF-8");
                JsonObject jsonResponse = new JsonParser().parse(responsePayload).getAsJsonObject();
                try {
                    String reqId = jsonResponse.get("reqId").getAsString();
                    LoggerUtility.fine(CLASS_NAME, "messageArrived", "reqId (" + reqId + "): " + jsonResponse.toString());
                    MqttMessage sentMsg = this.requests.remove(reqId);
                    if (sentMsg != null) {
                        this.queue.put(jsonResponse);
                    }
                }
                catch (Exception e) {
                    if (jsonResponse.get("reqId") == null) {
                        LoggerUtility.warn(CLASS_NAME, "messageArrived", "The response does not contain 'reqId' field (" + responsePayload + ")");
                        break block7;
                    }
                    LoggerUtility.log(Level.SEVERE, CLASS_NAME, "messageArrived", "Unexpected exception", e);
                }
            } else {
                matcher = GATEWAY_COMMAND_PATTERN.matcher(topic);
                if (matcher.matches()) {
                    super.messageArrived(topic, message);
                    return;
                }
                LoggerUtility.warn(CLASS_NAME, "messageArrived", "Unknown topic (" + topic + ")");
            }
        }
    }

    @Override
    public void run() {
        String METHOD = "run";
        this.running = true;
        LoggerUtility.log(Level.FINE, CLASS_NAME, "run", "Running...");
        while (this.running) {
            try {
                JsonObject o = this.publishQueue.take();
                if (o.equals((Object)this.dummy)) {
                    LoggerUtility.log(Level.FINE, CLASS_NAME, "run", "It is time to quit.");
                    continue;
                }
                this.publish(o);
            }
            catch (Exception e) {
                LoggerUtility.log(Level.SEVERE, CLASS_NAME, "run", e.toString());
                e.printStackTrace();
                this.running = false;
            }
        }
        LoggerUtility.log(Level.FINE, CLASS_NAME, "run", "Exiting...");
    }

    private void terminate() {
        this.running = false;
        try {
            this.publishQueue.put(this.dummy);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addFirmwareHandler(DeviceFirmwareHandler fwHandler) throws Exception {
        String METHOD = "addFirmwareHandler";
        if (this.fwHandler != null) {
            LoggerUtility.warn(CLASS_NAME, "addFirmwareHandler", "Firmware Handler is already set, so can not add the new firmware handler !");
            throw new Exception("Firmware Handler is already set, so can not add the new firmware handler !");
        }
        this.fwHandler = fwHandler;
    }

    public void addDeviceActionHandler(DeviceActionHandler actionHandler) throws Exception {
        String METHOD = "addDeviceActionHandler";
        if (this.actionHandler != null) {
            LoggerUtility.severe(CLASS_NAME, "addDeviceActionHandler", "Action Handler is already set, so can not add the new Action handler !");
            throw new Exception("Action Handler is already set, so can not add the new Action handler !");
        }
        this.actionHandler = actionHandler;
    }

    private void terminateHandlers() {
        this.fwHandler = null;
        this.actionHandler = null;
    }

    private class ManagedGatewayDevice
    implements ManagedClient {
        private ManagedGateway gwClient;
        private DMAgentTopic gatewayDMAgentTopic;
        private DMServerTopic gatewayDMServerTopic;
        private DeviceData deviceData = null;
        private boolean deviceActions = false;
        private boolean firmwareActions = false;
        private boolean bManaged = false;
        private Date dormantTime;

        public Date getDormantTime() {
            return this.dormantTime;
        }

        public void setDormantTime(Date dormantTime) {
            this.dormantTime = dormantTime;
        }

        public boolean isDeviceActions() {
            return this.deviceActions;
        }

        public boolean isFirmwareActions() {
            return this.firmwareActions;
        }

        private ManagedGatewayDevice(ManagedGateway gwClient, DeviceData deviceData) {
            this.gwClient = gwClient;
            this.deviceData = deviceData;
            this.gatewayDMAgentTopic = new GatewayDMAgentTopic(deviceData.getTypeId(), deviceData.getDeviceId());
            this.gatewayDMServerTopic = new GatewayDMServerTopic(deviceData.getTypeId(), deviceData.getDeviceId());
        }

        public ManagedGatewayDevice(ManagedGateway gwClient, DeviceData deviceData, boolean supportsFirmwareActions, boolean supportDeviceActions) {
            this.gwClient = gwClient;
            this.deviceData = deviceData;
            this.gatewayDMAgentTopic = new GatewayDMAgentTopic(deviceData.getTypeId(), deviceData.getDeviceId());
            this.gatewayDMServerTopic = new GatewayDMServerTopic(deviceData.getTypeId(), deviceData.getDeviceId());
            this.firmwareActions = supportsFirmwareActions;
            this.deviceActions = supportDeviceActions;
        }

        @Override
        public void subscribe(String topic, int qos, IMqttMessageListener iMqttMessageListener) throws MqttException {
            this.gwClient.subscribe(topic, qos, iMqttMessageListener);
        }

        @Override
        public void unsubscribe(String topic) throws MqttException {
            this.gwClient.unsubscribe(topic);
        }

        @Override
        public void publish(String response, JsonObject payload, int qos) throws MqttException {
            this.gwClient.publish(response, payload, qos);
        }

        @Override
        public DeviceData getDeviceData() {
            return this.deviceData;
        }

        @Override
        public void subscribe(String[] topics, int[] qos, IMqttMessageListener[] listener) throws MqttException {
            this.gwClient.subscribe(topics, qos, listener);
        }

        @Override
        public void unsubscribe(String[] topics) throws MqttException {
            this.gwClient.unsubscribe(topics);
        }

        @Override
        public DMAgentTopic getDMAgentTopic() {
            return this.gatewayDMAgentTopic;
        }

        @Override
        public DMServerTopic getDMServerTopic() {
            return this.gatewayDMServerTopic;
        }

        public void setbManaged(boolean bManaged) {
            this.bManaged = bManaged;
        }

        public String getTypeId() {
            return this.deviceData.getTypeId();
        }

        public String getDeviceId() {
            return this.deviceData.getDeviceId();
        }

        public void setSupportsFirmwareActions(boolean supportsFirmwareActions) {
            this.firmwareActions = supportsFirmwareActions;
        }

        public void setSupportDeviceActions(boolean supportDeviceActions) {
            this.deviceActions = supportDeviceActions;
        }

        @Override
        public DeviceActionHandler getActionHandler() {
            return this.gwClient.actionHandler;
        }

        @Override
        public DeviceFirmwareHandler getFirmwareHandler() {
            return this.gwClient.fwHandler;
        }
    }
}

