/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.ibm.iotf.devicemgmt.resource.Resource;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;

public class DateResource
extends Resource<Date> {
    public DateResource(String name, Date value) {
        super(name, value);
    }

    @Override
    public JsonElement toJsonObject() {
        String utcTime = DateFormatUtils.formatUTC((Date)((Date)this.getValue()), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        return new JsonPrimitive(utcTime);
    }

    @Override
    public int update(JsonElement json, boolean fireEvent) {
        DateTime dt = new DateTime((Object)json.getAsString());
        super.setValue(new Date(dt.getMillis()), fireEvent);
        return this.getRC();
    }

    @Override
    public int update(JsonElement json) {
        return this.update(json, true);
    }
}

