/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iotf.devicemgmt.resource;

import com.google.gson.JsonElement;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;

public abstract class Resource<T> {
    public static final String ROOT_RESOURCE_NAME = "root";
    public static final int RESPONSE_TIMEOUT = 120000;
    private PropertyChangeSupport pcsInternal = new PropertyChangeSupport(this);
    private PropertyChangeSupport pcsExternal = new PropertyChangeSupport(this);
    private String resourceName;
    private String canonicalName;
    private T value;
    private Resource parent;
    private boolean responseRequired = true;
    private int rc = 0;
    private HashMap<String, Resource> children;

    public Resource(String resourceResourceName) {
        this(resourceResourceName, null);
    }

    public Resource(String resourceResourceName, T value) {
        this.resourceName = resourceResourceName;
        this.value = value;
        this.children = new HashMap();
        this.canonicalName = resourceResourceName;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.setValue(value, true);
    }

    public void setValue(T value, boolean fireEvent) {
        this.value = value;
        if (fireEvent) {
            this.pcsInternal.firePropertyChange(this.canonicalName, null, this);
        }
    }

    protected void fireEvent(boolean fire) {
        if (fire) {
            this.pcsInternal.firePropertyChange(this.canonicalName, null, this);
        }
    }

    public void fireEvent(String event) {
        this.pcsInternal.firePropertyChange(event, null, this);
    }

    public void notifyExternalListeners() {
        this.pcsExternal.firePropertyChange(this.canonicalName, null, this);
    }

    public void add(Resource child) {
        if (child.resourceName == null) {
            throw new NullPointerException("Child must have a resourceResourceName");
        }
        if (child.getParent() != null) {
            child.getParent().remove(child);
        }
        this.children.put(child.resourceName, child);
        child.setParent(this);
        if (!this.resourceName.equals(ROOT_RESOURCE_NAME)) {
            child.canonicalName = this.canonicalName + "." + child.resourceName;
        }
    }

    private void setCanonicalResourceName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public boolean remove(Resource child) {
        Resource removed = this.remove(child.resourceName);
        if (removed == child) {
            child.setParent(null);
            return true;
        }
        return false;
    }

    public Resource remove(String resourceResourceName) {
        return this.children.remove(resourceResourceName);
    }

    public Resource getParent() {
        return this.parent;
    }

    public void setParent(Resource parent) {
        this.parent = parent;
    }

    public Resource getChild(String resourceResourceName) {
        return this.children.get(resourceResourceName);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public Collection<Resource> getChildren() {
        return this.children.values();
    }

    public abstract JsonElement toJsonObject();

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsExternal.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(ChangeListenerType type, PropertyChangeListener listener) {
        if (type == ChangeListenerType.INTERNAL) {
            this.pcsInternal.addPropertyChangeListener(listener);
        } else {
            this.pcsExternal.addPropertyChangeListener(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsInternal.removePropertyChangeListener(listener);
    }

    public abstract int update(JsonElement var1);

    public abstract int update(JsonElement var1, boolean var2);

    public void waitForResponse(boolean responseRequired) {
        this.responseRequired = responseRequired;
    }

    public int getRC() {
        return this.rc;
    }

    public void setRC(int rc) {
        this.rc = rc;
    }

    public boolean getResponseRequired() {
        return this.responseRequired;
    }

    public static enum ChangeListenerType {
        INTERNAL("Internal"),
        EXTERNAL("External");

        private final String name;

        private ChangeListenerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

