/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="ibm.mq")
public class MQConfigurationProperties {
    private String queueManager = "QM1";
    private String channel = "DEV.ADMIN.SVRCONN";
    private String connName = "localhost(1414)";
    private String clientId;
    private String user = "admin";
    private String password = "passw0rd";
    private boolean userAuthenticationMQCSP = true;
    private String sslCipherSuite;
    private String sslCipherSpec;
    private String sslPeerName;
    private boolean useIBMCipherMappings = true;
    private String ccdtUrl;
    @NestedConfigurationProperty
    private PoolProperties pool = new PoolProperties();

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String connName) {
        this.connName = connName;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSslCipherSuite() {
        return this.sslCipherSuite;
    }

    public void setSslCipherSuite(String sslCipherSuite) {
        this.sslCipherSuite = sslCipherSuite;
    }

    public String getSslCipherSpec() {
        return this.sslCipherSpec;
    }

    public void setSslCipherSpec(String sslCipherSpec) {
        this.sslCipherSpec = sslCipherSpec;
    }

    public boolean isUseIBMCipherMappings() {
        return this.useIBMCipherMappings;
    }

    public void setUseIBMCipherMappings(boolean useIBMCipherMappings) {
        System.setProperty("com.ibm.mq.cfg.useIBMCipherMappings", Boolean.toString(useIBMCipherMappings));
        this.useIBMCipherMappings = useIBMCipherMappings;
    }

    public boolean isUserAuthenticationMQCSP() {
        return this.userAuthenticationMQCSP;
    }

    public void setUserAuthenticationMQCSP(boolean userAuthenticationMQCSP) {
        this.userAuthenticationMQCSP = userAuthenticationMQCSP;
    }

    public String getSslPeerName() {
        return this.sslPeerName;
    }

    public void setSslPeerName(String sslPeerName) {
        this.sslPeerName = sslPeerName;
    }

    public String getCcdtUrl() {
        return this.ccdtUrl;
    }

    public void setCcdtUrl(String ccdtUrl) {
        this.ccdtUrl = ccdtUrl;
    }

    public PoolProperties getPool() {
        return this.pool;
    }

    class PoolProperties {
        private boolean enabled;
        private boolean blockIfFull = true;
        private Duration blockIfFullTimeout = Duration.ofMillis(-1L);
        private Duration idleTimeout = Duration.ofSeconds(30L);
        private int maxConnections = 1;
        private int maxSessionsPerConnection = 500;
        private Duration timeBetweenExpirationCheck = Duration.ofMillis(-1L);
        private boolean useAnonymousProducers = true;

        PoolProperties() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isBlockIfFull() {
            return this.blockIfFull;
        }

        public void setBlockIfFull(boolean blockIfFull) {
            this.blockIfFull = blockIfFull;
        }

        public Duration getBlockIfFullTimeout() {
            return this.blockIfFullTimeout;
        }

        public void setBlockIfFullTimeout(Duration blockIfFullTimeout) {
            this.blockIfFullTimeout = blockIfFullTimeout;
        }

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getMaxSessionsPerConnection() {
            return this.maxSessionsPerConnection;
        }

        public void setMaxSessionsPerConnection(int maxSessionsPerConnection) {
            this.maxSessionsPerConnection = maxSessionsPerConnection;
        }

        public Duration getTimeBetweenExpirationCheck() {
            return this.timeBetweenExpirationCheck;
        }

        public void setTimeBetweenExpirationCheck(Duration timeBetweenExpirationCheck) {
            this.timeBetweenExpirationCheck = timeBetweenExpirationCheck;
        }

        public boolean isUseAnonymousProducers() {
            return this.useAnonymousProducers;
        }

        public void setUseAnonymousProducers(boolean useAnonymousProducers) {
            this.useAnonymousProducers = useAnonymousProducers;
        }
    }
}

