/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import com.ibm.mq.spring.boot.MQConnectionFactoryFactory;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class MQConnectionFactoryConfiguration {
    MQConnectionFactoryConfiguration() {
    }

    @Configuration
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    static class PooledMQConnectionFactoryConfiguration {
        PooledMQConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public JmsPoolConnectionFactory pooledJmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            MQConnectionFactory connectionFactory = new MQConnectionFactoryFactory(properties, (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQConnectionFactory.class);
            return this.create((ConnectionFactory)connectionFactory, properties.getPool());
        }

        private JmsPoolConnectionFactory create(ConnectionFactory connectionFactory, MQConfigurationProperties.PoolProperties poolProperties) {
            JmsPoolConnectionFactory pooledConnectionFactory = new JmsPoolConnectionFactory();
            pooledConnectionFactory.setConnectionFactory((Object)connectionFactory);
            pooledConnectionFactory.setBlockIfSessionPoolIsFull(poolProperties.isBlockIfFull());
            if (poolProperties.getBlockIfFullTimeout() != null) {
                pooledConnectionFactory.setBlockIfSessionPoolIsFullTimeout(poolProperties.getBlockIfFullTimeout().toMillis());
            }
            if (poolProperties.getIdleTimeout() != null) {
                pooledConnectionFactory.setConnectionIdleTimeout((int)poolProperties.getIdleTimeout().toMillis());
            }
            pooledConnectionFactory.setMaxConnections(poolProperties.getMaxConnections());
            pooledConnectionFactory.setMaxSessionsPerConnection(poolProperties.getMaxSessionsPerConnection());
            if (poolProperties.getTimeBetweenExpirationCheck() != null) {
                pooledConnectionFactory.setConnectionCheckInterval(poolProperties.getTimeBetweenExpirationCheck().toMillis());
            }
            pooledConnectionFactory.setUseAnonymousProducers(poolProperties.isUseAnonymousProducers());
            return pooledConnectionFactory;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class RegularMQConnectionFactoryConfiguration {
        RegularMQConnectionFactoryConfiguration() {
        }

        @Bean
        public MQConnectionFactory jmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            return new MQConnectionFactoryFactory(properties, (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQConnectionFactory.class);
        }
    }
}

