/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.spring.boot.MQConfigurationPropertiesJks;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesJndi;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="ibm.mq")
public class MQConfigurationProperties {
    private static Logger logger = LoggerFactory.getLogger(MQConfigurationProperties.class);
    private static final String PROPERTY_USE_IBM_CIPHER_MAPPINGS = "com.ibm.mq.cfg.useIBMCipherMappings";
    private static final String PROPERTY_OUTBOUND_SNI = "com.ibm.mq.cfg.SSL.outboundSNI";
    private static final String PROPERTY_CHANNEL_SHARING = "com.ibm.mq.jms.channel.sharing";
    private String queueManager = "QM1";
    private String channel = "DEV.ADMIN.SVRCONN";
    private String connName = "localhost(1414)";
    private String clientId;
    private String applicationName;
    private String user = "admin";
    private String password = "passw0rd";
    private boolean userAuthenticationMQCSP;
    private boolean useAuthenticationMQCSP;
    private boolean authCSP = true;
    private String sslCipherSuite;
    private String sslCipherSpec;
    private String sslPeerName;
    private boolean useIBMCipherMappings = true;
    private String outboundSNI = "";
    private String channelSharing = "";
    private String reconnect = "";
    private String defaultReconnect = null;
    private String ccdtUrl;
    private String tempQPrefix = null;
    private String tempTopicPrefix = null;
    private String tempModel = null;
    private boolean sslFIPSRequired = false;
    private int sslKeyResetCount = -1;
    private String sslBundle;
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    @NestedConfigurationProperty
    private JmsPoolConnectionFactoryProperties pool = new JmsPoolConnectionFactoryProperties();
    @NestedConfigurationProperty
    private MQConfigurationPropertiesJndi jndi = new MQConfigurationPropertiesJndi();
    @NestedConfigurationProperty
    private MQConfigurationPropertiesJks jks = new MQConfigurationPropertiesJks();

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String connName) {
        this.connName = connName;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSslCipherSuite() {
        return this.sslCipherSuite;
    }

    public void setSslCipherSuite(String sslCipherSuite) {
        this.sslCipherSuite = sslCipherSuite;
    }

    public String getSslCipherSpec() {
        return this.sslCipherSpec;
    }

    public void setSslCipherSpec(String sslCipherSpec) {
        this.sslCipherSpec = sslCipherSpec;
    }

    public boolean isUseIBMCipherMappings() {
        return this.useIBMCipherMappings;
    }

    public void setUseIBMCipherMappings(boolean useIBMCipherMappings) {
        System.setProperty(PROPERTY_USE_IBM_CIPHER_MAPPINGS, Boolean.toString(useIBMCipherMappings));
        this.useIBMCipherMappings = useIBMCipherMappings;
    }

    public String getOutboundSNI() {
        return this.outboundSNI;
    }

    public void setOutboundSNI(String outboundSNI) {
        System.setProperty(PROPERTY_OUTBOUND_SNI, outboundSNI);
        this.outboundSNI = outboundSNI;
    }

    public String getChannelSharing() {
        return this.channelSharing;
    }

    public void setChannelSharing(String channelSharing) {
        System.setProperty(PROPERTY_CHANNEL_SHARING, channelSharing);
        this.channelSharing = channelSharing;
    }

    public boolean isUseAuthenticationMQCSP() {
        return this.authCSP;
    }

    public void setUserAuthenticationMQCSP(boolean userAuthenticationMQCSP) {
        this.authCSP = userAuthenticationMQCSP;
    }

    public void setUseAuthenticationMQCSP(boolean useAuthenticationMQCSP) {
        this.authCSP = useAuthenticationMQCSP;
    }

    public String getSslPeerName() {
        return this.sslPeerName;
    }

    public void setSslPeerName(String sslPeerName) {
        this.sslPeerName = sslPeerName;
    }

    public String getCcdtUrl() {
        return this.ccdtUrl;
    }

    public void setCcdtUrl(String ccdtUrl) {
        this.ccdtUrl = ccdtUrl;
    }

    public JmsPoolConnectionFactoryProperties getPool() {
        return this.pool;
    }

    public MQConfigurationPropertiesJndi getJndi() {
        return this.jndi;
    }

    public MQConfigurationPropertiesJks getJks() {
        return this.jks;
    }

    public String getTempQPrefix() {
        return this.tempQPrefix;
    }

    public void setTempQPrefix(String tempQPrefix) {
        this.tempQPrefix = tempQPrefix;
    }

    public String getTempTopicPrefix() {
        return this.tempTopicPrefix;
    }

    public void setTempTopicPrefix(String tempTopicPrefix) {
        this.tempTopicPrefix = tempTopicPrefix;
    }

    public String getTempModel() {
        return this.tempModel;
    }

    public void setTempModel(String tempModel) {
        this.tempModel = tempModel;
    }

    public boolean isSslFIPSRequired() {
        return this.sslFIPSRequired;
    }

    public void setSslFIPSRequired(boolean sslFIPSRequired) {
        this.sslFIPSRequired = sslFIPSRequired;
    }

    public int getSslKeyResetCount() {
        return this.sslKeyResetCount;
    }

    public void setSslKeyResetCount(int sslKeyResetCount) {
        this.sslKeyResetCount = sslKeyResetCount;
    }

    public String getSslBundle() {
        return this.sslBundle;
    }

    public void setSslBundle(String sslBundle) {
        this.sslBundle = sslBundle;
    }

    public int getReconnectValue() {
        int rc = 0;
        switch (this.reconnect.toUpperCase()) {
            case "QMGR": {
                rc = 0x4000000;
                break;
            }
            case "DISABLED": 
            case "NO": {
                rc = 0x2000000;
                break;
            }
            case "YES": 
            case "ANY": {
                rc = 0x1000000;
                break;
            }
            default: {
                rc = 0;
            }
        }
        return rc;
    }

    public String getReconnect() {
        return this.reconnect;
    }

    public void setDefaultReconnect(String defaultReconnect) {
        this.reconnect = defaultReconnect;
    }

    public void setReconnect(String reconnect) {
        this.reconnect = reconnect;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> properties) {
        this.additionalProperties = properties;
    }

    public void traceProperties() {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("queueManager    : {}", (Object)this.getQueueManager());
        logger.trace("applicationName : {}", (Object)this.getApplicationName());
        logger.trace("ccdtUrl         : {}", (Object)this.getCcdtUrl());
        logger.trace("channel         : {}", (Object)this.getChannel());
        logger.trace("clientId        : {}", (Object)this.getClientId());
        logger.trace("connName        : {}", (Object)this.getConnName());
        logger.trace("reconnectOption : '{}' [{}]", (Object)this.getReconnect(), (Object)String.format("0x%08X", this.getReconnectValue()));
        logger.trace("sslCipherSpec   : {}", (Object)this.getSslCipherSpec());
        logger.trace("sslCipherSuite  : {}", (Object)this.getSslCipherSuite());
        logger.trace("sslKeyresetcount: {}", (Object)this.getSslKeyResetCount());
        logger.trace("sslPeerName     : {}", (Object)this.getSslPeerName());
        logger.trace("sslBundle       : {}", (Object)this.getSslBundle());
        logger.trace("tempModel       : {}", (Object)this.getTempModel());
        logger.trace("tempQPrefix     : {}", (Object)this.getTempQPrefix());
        logger.trace("tempTopicPrefix : {}", (Object)this.getTempTopicPrefix());
        logger.trace("user            : '{}'", (Object)this.getUser());
        logger.trace("password set    : {}", (Object)(this.getPassword() != null && this.getPassword().length() > 0 ? "YES" : "NO"));
        logger.trace("sslFIPSRequired        : {}", (Object)this.isSslFIPSRequired());
        logger.trace("useIBMCipherMappings   : {}", (Object)this.isUseIBMCipherMappings());
        logger.trace("userAuthenticationMQCSP: {}", (Object)this.isUseAuthenticationMQCSP());
        logger.trace("outboundSNI            : '{}'", (Object)this.getOutboundSNI());
        logger.trace("channelSharing         : '{}'", (Object)this.getChannelSharing());
        logger.trace("jndiCF          : {}", (Object)this.getJndi().getProviderContextFactory());
        logger.trace("jndiProviderUrl : {}", (Object)this.getJndi().getProviderUrl());
        String pw = this.getJks().getKeyStorePassword();
        logger.trace("JKS keystore           : {}", (Object)this.getJks().getKeyStore());
        logger.trace("JKS keystore pw set    : {}", (Object)(pw != null && pw.length() > 0 ? "YES" : "NO"));
        pw = this.getJks().getTrustStorePassword();
        logger.trace("JKS truststore         : {}", (Object)this.getJks().getTrustStore());
        logger.trace("JKS truststore pw set  : {}", (Object)(pw != null && pw.length() > 0 ? "YES" : "NO"));
        if (this.additionalProperties.size() > 0) {
            for (String s : this.additionalProperties.keySet()) {
                logger.trace("Additional Property - {} : {}", (Object)s, (Object)this.additionalProperties.get(s));
            }
        } else {
            logger.trace("No additional properties defined");
        }
        if (this.pool.isEnabled()) {
            logger.trace("Pool blockIfFullTimeout         : {}", (Object)this.pool.getBlockIfFullTimeout().toString());
            logger.trace("Pool idleTimeout                : {}", (Object)this.pool.getIdleTimeout().toString());
            logger.trace("Pool maxConnections             : {}", (Object)this.pool.getMaxConnections());
            logger.trace("Pool maxSessionsPerConn         : {}", (Object)this.pool.getMaxSessionsPerConnection());
            logger.trace("Pool timeBetweenExpirationCheck : {}", (Object)this.pool.getTimeBetweenExpirationCheck().toString());
        } else {
            logger.trace("Pooling is disabled");
        }
    }
}

