/*
 * Copyright © 2023 IBM Corp. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */


/*
 * This is a dummy file with just enough in it to allow the Spring Boot 2/JMS2 common code to compile.
 * The real version of this class is only available with Spring Boot 3. 
 */
package com.ibm.mq.spring.boot;

import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQConfigurationSslBundles {
  private static Logger logger = LoggerFactory.getLogger(MQConfigurationSslBundles.class);
  
  static boolean isSupported() {
    logger.trace("SSLBundles are not supported");
    return false;
  }

  /* This should never actually be called */
  public static SSLSocketFactory getSSLSocketFactory(String b) {
    logger.trace("getSSLSocketFactory returning null for bundle {}", b);
    return null;
  }
}
