/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.stereotype.Component;

@Component
public class MQConfigurationSslBundles {
    private static Logger logger = LoggerFactory.getLogger(MQConfigurationSslBundles.class);
    static SslBundles bundles = null;

    public MQConfigurationSslBundles(SslBundles sslBundles) {
        logger.trace("constructor - Bundles are {}", (Object)(sslBundles == null ? "null" : "not null"));
        bundles = sslBundles;
    }

    static boolean isSupported() {
        logger.trace("SSLBundles are supported");
        return true;
    }

    public static SSLSocketFactory getSSLSocketFactory(String b) {
        SSLSocketFactory sf = null;
        logger.trace("getSSLSocketFactory for {}", (Object)b);
        if (b == null || b.isEmpty()) {
            return sf;
        }
        if (bundles != null) {
            try {
                SslBundle sb = bundles.getBundle(b);
                sf = sb.createSslContext().getSocketFactory();
            }
            catch (NoSuchSslBundleException e) {
                logger.error("No SSL bundle found for {}", (Object)b);
            }
        }
        return sf;
    }
}

