/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jakarta.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesJks;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesJndi;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import com.ibm.mq.spring.boot.U;
import com.ibm.msg.client.jakarta.wmq.WMQConstants;
import jakarta.jms.JMSException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslManagerBundle;

public class MQConnectionFactoryFactory {
    private final MQConfigurationProperties properties;
    private final List<MQConnectionFactoryCustomizer> factoryCustomizers;
    private static Logger logger = LoggerFactory.getLogger(MQConnectionFactoryFactory.class);
    private SslBundles sslBundles;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public MQConnectionFactoryFactory(MQConfigurationProperties properties, SslBundles sslBundles, List<MQConnectionFactoryCustomizer> factoryCustomizers) {
        this.properties = properties;
        this.sslBundles = sslBundles;
        this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
        logger.trace("constructor");
    }

    public MQConnectionFactoryFactory(MQConfigurationProperties properties, List<MQConnectionFactoryCustomizer> factoryCustomizers) {
        this(properties, null, factoryCustomizers);
    }

    public <T extends MQConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        String err = null;
        MQConnectionFactory cf = null;
        SSLSocketFactory sf = null;
        String jndiProviderUrl = this.properties.getJndi().getProviderUrl();
        String jndiCF = this.properties.getJndi().getProviderContextFactory();
        logger.trace("createConnectionFactory for class " + factoryClass.getSimpleName());
        String sslBundle = this.properties.getSslBundle();
        this.properties.getTrace().setProperties();
        if (this.sslBundles != null && U.isNotNullOrEmpty(sslBundle)) {
            sf = this.getSSLSocketFactory(sslBundle);
        } else {
            MQConnectionFactoryFactory.configureTLSStores(this.properties);
        }
        if (U.isNotNullOrEmpty(jndiProviderUrl) && U.isNotNullOrEmpty(jndiCF)) {
            logger.trace("createConnectionFactory using JNDI");
            try {
                String cfName = this.properties.getQueueManager();
                this.properties.getJndi().traceProperties(cfName);
                Context ctx = MQConnectionFactoryFactory.getJndiContext(this.properties.getJndi());
                cf = jndiProviderUrl.toUpperCase().contains("LDAP") && !cfName.toUpperCase().startsWith("CN=") ? (MQConnectionFactory)ctx.lookup("cn=" + cfName) : (MQConnectionFactory)ctx.lookup(cfName);
                if (sf != null) {
                    cf.setSSLSocketFactory((Object)sf);
                } else if (this.properties.isSslCertificateValidationNone()) {
                    cf.setIntProperty("certificateValPolicy", 2);
                }
                this.customize(cf);
            }
            catch (JMSException | NamingException ex) {
                logger.trace("createConnectionFactory : exception " + ex.getMessage());
                throw new IllegalStateException("Unable to create MQConnectionFactory" + (String)(err != null ? ": " + err : ""), ex);
            }
        }
        try {
            cf = (MQConnectionFactory)this.createConnectionFactoryInstance(factoryClass);
            MQConnectionFactoryFactory.configureConnectionFactory(cf, this.properties, sf);
            this.customize(cf);
        }
        catch (JMSException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            logger.trace("createConnectionFactory : exception " + ex.getMessage());
            throw new IllegalStateException("Unable to create MQConnectionFactory" + (String)(err != null ? ": " + err : ""), ex);
        }
        return (T)cf;
    }

    public static void configureConnectionFactory(MQConnectionFactory cf, MQConfigurationProperties props, SSLSocketFactory sf) throws JMSException {
        String token;
        String applicationName;
        boolean bindingsMode = false;
        logger.trace("configureConnectionFactory");
        props.traceProperties();
        String qmName = props.getQueueManager();
        if (!U.isNullOrEmpty(qmName)) {
            cf.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", qmName);
        }
        String channel = props.getChannel();
        String connName = props.getConnName();
        String ccdtUrl = props.getCcdtUrl();
        if (!U.isNullOrEmpty(ccdtUrl)) {
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            cf.setStringProperty("XMSC_WMQ_CCDTURL", ccdtUrl);
        } else if (U.isNullOrEmpty(channel) || U.isNullOrEmpty(connName)) {
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 0);
            bindingsMode = true;
        } else {
            cf.setStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST", connName);
            cf.setStringProperty("XMSC_WMQ_CHANNEL", channel);
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
        }
        String clientId = props.getClientId();
        if (!U.isNullOrEmpty(clientId)) {
            cf.setStringProperty("XMSC_CLIENT_ID", clientId);
        }
        if (!bindingsMode) {
            if (!U.isNullOrEmpty(props.getReconnect())) {
                cf.setIntProperty("XMSC_WMQ_CLIENT_RECONNECT_OPTIONS", props.getReconnectValue());
            }
            cf.setIntProperty("XMSC_WMQ_CLIENT_RECONNECT_TIMEOUT", props.getReconnectTimeout());
            if (!U.isNullOrEmpty(props.getBalancingApplicationType())) {
                cf.setIntProperty("XMSC_WMQ_BALANCING_APPLICATION_TYPE", props.getBalancingApplicationTypeValue());
            }
            if (!U.isNullOrEmpty(props.getBalancingOptions())) {
                cf.setIntProperty("XMSC_WMQ_BALANCING_OPTIONS", props.getBalancingOptionsValue());
            }
            if (!U.isNullOrEmpty(props.getBalancingTimeout())) {
                cf.setIntProperty("XMSC_WMQ_BALANCING_TIMEOUT", props.getBalancingTimeoutValue());
            }
            if (sf != null) {
                cf.setSSLSocketFactory((Object)sf);
            } else if (props.isSslCertificateValidationNone()) {
                cf.setIntProperty("certificateValPolicy", 2);
            }
        }
        if (!U.isNullOrEmpty(applicationName = props.getApplicationName())) {
            cf.setAppName(applicationName);
        }
        if (!U.isNullOrEmpty(token = props.getToken())) {
            cf.setStringProperty("XMSC_PASSWORD", token);
            cf.setStringProperty("XMSC_USERID", "");
            cf.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", true);
        } else {
            String p;
            String u = props.getUser();
            if (!U.isNullOrEmpty(u)) {
                cf.setStringProperty("XMSC_USERID", u);
            }
            if (!U.isNullOrEmpty(p = props.getPassword())) {
                cf.setStringProperty("XMSC_PASSWORD", p);
                cf.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", props.isUseAuthenticationMQCSP());
            }
        }
        if (!U.isNullOrEmpty(props.getSslCipherSuite())) {
            cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE", props.getSslCipherSuite());
        }
        if (!U.isNullOrEmpty(props.getSslCipherSpec())) {
            cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SPEC", props.getSslCipherSpec());
        }
        if (!U.isNullOrEmpty(props.getSslPeerName())) {
            cf.setStringProperty("XMSC_WMQ_SSL_PEER_NAME", props.getSslPeerName());
        }
        cf.setBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED", props.isSslFIPSRequired());
        Integer vi = props.getSslKeyResetCount();
        if (vi != -1) {
            cf.setIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT", vi.intValue());
        }
        if (!U.isNullOrEmpty(props.getTempQPrefix())) {
            cf.setStringProperty("XMSC_WMQ_TEMP_Q_PREFIX", props.getTempQPrefix());
        }
        if (!U.isNullOrEmpty(props.getTempTopicPrefix())) {
            cf.setStringProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX", props.getTempTopicPrefix());
        }
        if (!U.isNullOrEmpty(props.getTempModel())) {
            cf.setStringProperty("XMSC_WMQ_TEMPORARY_MODEL", props.getTempModel());
        }
        Map<String, String> additionalProperties = props.getAdditionalProperties();
        for (String k : additionalProperties.keySet()) {
            String v = additionalProperties.get(k);
            Boolean vb = null;
            vi = null;
            String key = k;
            if (key.startsWith("WMQ_")) {
                try {
                    Object o;
                    Field f = WMQConstants.class.getField(key);
                    if (f != null && (o = f.get(new Object())) != null && o instanceof String) {
                        key = (String)o;
                        logger.trace("Successfully mapped {} to property name {}", (Object)k, (Object)key);
                    }
                }
                catch (Throwable e) {
                    logger.warn("Cannot find value of property " + k, e);
                }
            }
            try {
                vi = v.toUpperCase().startsWith("0X") ? Integer.decode(v) : Integer.valueOf(v);
                cf.setIntProperty(key, vi.intValue());
                logger.trace("Using setIntProperty with key {} and value {} [{}]", new Object[]{key, vi, String.format("0x%08X", vi)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (vi == null && (v.toUpperCase().equals("TRUE") || v.toUpperCase().equals("FALSE"))) {
                vb = Boolean.valueOf(v);
                cf.setBooleanProperty(key, vb.booleanValue());
                logger.trace("Using setBooleanProperty with key {} and value {}", (Object)key, (Object)vb);
            }
            if (vi != null || vb != null) continue;
            cf.setStringProperty(key, v);
            logger.trace("Using setStringProperty with key {} and value {}", (Object)key, (Object)v);
        }
    }

    public static void configureConnectionFactory(MQConnectionFactory cf, MQConfigurationProperties props) throws JMSException {
        MQConnectionFactoryFactory.configureConnectionFactory(cf, props, null);
    }

    private static void configureTLSStores(MQConfigurationProperties props) {
        String[] prefixes = new String[]{"javax.net.ssl.", "com.ibm.ssl."};
        logger.trace("configuring TLS Store system properties");
        MQConfigurationPropertiesJks jksProperties = props.getJks();
        for (String prefix : prefixes) {
            if (!U.isNullOrEmpty(jksProperties.getKeyStore())) {
                System.setProperty(prefix + "keyStore", jksProperties.getKeyStore());
            }
            if (!U.isNullOrEmpty(jksProperties.getKeyStorePassword())) {
                System.setProperty(prefix + "keyStorePassword", jksProperties.getKeyStorePassword());
            }
            if (!U.isNullOrEmpty(jksProperties.getTrustStore())) {
                System.setProperty(prefix + "trustStore", jksProperties.getTrustStore());
            }
            if (U.isNullOrEmpty(jksProperties.getTrustStorePassword())) continue;
            System.setProperty(prefix + "trustStorePassword", jksProperties.getTrustStorePassword());
        }
    }

    private <T extends MQConnectionFactory> T createConnectionFactoryInstance(Class<T> factoryClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        logger.trace("createConnectionFactoryInstance for class " + factoryClass.getSimpleName());
        return (T)((MQConnectionFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private void customize(MQConnectionFactory connectionFactory) {
        for (MQConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            logger.trace("Calling MQConnectionFactoryCustomizer from class {} ", (Object)factoryCustomizer.getClass().getName());
            factoryCustomizer.customize(connectionFactory);
        }
    }

    public static Context getJndiContext(MQConfigurationPropertiesJndi jproperties) throws NamingException {
        logger.trace("getJndiContext");
        String jndiProviderUrl = jproperties.getProviderUrl();
        String jndiCF = jproperties.getProviderContextFactory();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.provider.url", jndiProviderUrl);
        environment.put("java.naming.factory.initial", jndiCF);
        Map<String, String> additionalProperties = jproperties.getAdditionalProperties();
        for (String k : additionalProperties.keySet()) {
            String v = additionalProperties.get(k);
            try {
                Object o;
                Field f = Context.class.getField(k);
                if (f != null && (o = f.get(new Object())) != null && o instanceof String) {
                    k = (String)o;
                }
            }
            catch (Throwable e) {
                logger.warn("Cannot find value of property " + k);
            }
            logger.trace(String.format("getJndiContext: Using additional property '%s' with value '%s'", k, v));
            environment.put(k, v);
        }
        InitialDirContext ctx = new InitialDirContext(environment);
        return ctx;
    }

    private SSLSocketFactory getSSLSocketFactory(String b) {
        SSLSocketFactory sf = null;
        if (b == null || b.isEmpty()) {
            logger.trace("getSSLSocketFactory - null/empty bundle name requested");
            return sf;
        }
        if (this.sslBundles != null) {
            try {
                SslBundle sb = this.sslBundles.getBundle(b);
                logger.trace("SSL Bundle for {} - found", (Object)b);
                SSLContext sc = sb.createSslContext();
                if (this.properties.isSslCertificateValidationNone()) {
                    SslManagerBundle mgrs = sb.getManagers();
                    KeyManager[] keymanagers = mgrs.getKeyManagers();
                    String protocol = sb.getProtocol();
                    try {
                        sc = SSLContext.getInstance(protocol);
                        sc.init(keymanagers, trustAllCerts, null);
                        sf = sc.getSocketFactory();
                    }
                    catch (KeyManagementException | NoSuchAlgorithmException e) {
                        logger.error("Cannot set insecure mode: {}", (Throwable)e);
                    }
                } else {
                    sf = sc.getSocketFactory();
                }
            }
            catch (NoSuchSslBundleException e) {
                logger.error("SSL bundle for {} - not found", (Object)b);
            }
        }
        return sf;
    }
}

