/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.jms.annotation.JmsListener;

@ConditionalOnClass(value={JmsProperties.Listener.class, JmsListener.class})
@ConditionalOnMissingBean(value={JmsListener.class})
@Configuration
public class MQConfigurationListenerDefault
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static Logger logger = LoggerFactory.getLogger(MQConfigurationListenerDefault.class);
    @Autowired
    private final Long defaultReceiveTimeout = 30000L;
    private static String lcPrefix = "spring.jms.listener.";
    private static String ucPrefix = "SPRING_JMS_LISTENER_";
    private final String[] timeoutProperties = new String[]{lcPrefix + "receiveTimeout", lcPrefix + "receivetimeout", lcPrefix + "receive-timeout", lcPrefix + "receive_timeout", lcPrefix + "RECEIVE_TIMEOUT", ucPrefix + "RECEIVE_TIMEOUT"};

    @Bean
    @Lazy(value=false)
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        logger.trace("onApplicationEvent : {}", (Object)event.toString());
        try {
            ConfigurableEnvironment env;
            String foundProperty = null;
            String p = null;
            ConfigurableEnvironment configurableEnvironment = env = event != null ? event.getEnvironment() : null;
            if (env != null) {
                for (String timeoutProperty : this.timeoutProperties) {
                    p = env.getProperty(timeoutProperty);
                    if (p == null) continue;
                    foundProperty = timeoutProperty;
                    break;
                }
                if (foundProperty == null) {
                    Properties props = new Properties();
                    logger.trace("Setting receiveTimeout property {} to {}", (Object)this.timeoutProperties[0], (Object)this.defaultReceiveTimeout);
                    props.put(this.timeoutProperties[0], this.defaultReceiveTimeout);
                    env.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource(this.getClass().getName(), props));
                } else {
                    logger.trace("Not setting receiveTimeout as property {} was found", foundProperty);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

