/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jakarta.jms.MQConnectionFactory;
import com.ibm.mq.jakarta.jms.MQXAConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConnectionDetails;
import com.ibm.mq.spring.boot.MQConnectionFactoryConfiguration;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import com.ibm.mq.spring.boot.MQConnectionFactoryFactory;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import java.util.List;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolXAConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={XAConnectionFactoryWrapper.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class MQXAConnectionFactoryConfiguration {
    private static Logger logger = LoggerFactory.getLogger(MQXAConnectionFactoryConfiguration.class);

    MQXAConnectionFactoryConfiguration() {
    }

    @Primary
    @Bean(name={"jmsConnectionFactory", "xaJmsConnectionFactory"})
    public ConnectionFactory jmsConnectionFactory(MQConnectionDetails connectionDetails, MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<SslProperties> sslProperties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers, XAConnectionFactoryWrapper wrapper) throws Exception {
        logger.trace("Creating MQXAConnectionFactory");
        MQXAConnectionFactory connectionFactory = new MQConnectionFactoryFactory(connectionDetails, properties, (SslBundles)sslBundles.getIfAvailable(), (SslProperties)sslProperties.getIfAvailable(), (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQXAConnectionFactory.class);
        return wrapper.wrapConnectionFactory((XAConnectionFactory)connectionFactory);
    }

    @Bean
    public ConnectionFactory nonXaJmsConnectionFactory(MQConnectionDetails connectionDetails, MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<SslProperties> sslProperties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
        logger.trace("Creating non-XA MQConnectionFactory");
        return new MQConnectionFactoryFactory(connectionDetails, properties, (SslBundles)sslBundles.getIfAvailable(), (SslProperties)sslProperties.getIfAvailable(), (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQConnectionFactory.class);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolXAConnectionFactory.class, PooledObject.class})
    public static class PooledMQXAConnectionFactoryConfiguration {
        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="true", matchIfMissing=false)
        JmsPoolXAConnectionFactory pooledJmsXAConnectionFactory(MQConnectionDetails connectionDetails, MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<SslProperties> sslProperties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            logger.trace("Creating pooled MQXAConnectionFactory");
            MQXAConnectionFactory connectionFactory = new MQConnectionFactoryFactory(connectionDetails, properties, (SslBundles)sslBundles.getIfAvailable(), (SslProperties)sslProperties.getIfAvailable(), (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQXAConnectionFactory.class);
            return MQConnectionFactoryConfiguration.PooledMQConnectionFactoryConfiguration.createInstance(JmsPoolXAConnectionFactory.class, (ConnectionFactory)connectionFactory, properties.getPool());
        }
    }
}

