/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.spring.boot.MQConfigurationPropertiesJks;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesJndi;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesTokenServer;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesTrace;
import com.ibm.mq.spring.boot.MQConnectionDetails;
import com.ibm.mq.spring.boot.U;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.jms.autoconfigure.JmsPoolConnectionFactoryProperties;

@ConfigurationProperties(prefix="ibm.mq")
public class MQConfigurationProperties {
    private static Logger logger = LoggerFactory.getLogger(MQConfigurationProperties.class);
    private static final String PROPERTY_USE_IBM_CIPHER_MAPPINGS = "com.ibm.mq.cfg.useIBMCipherMappings";
    private static final String PROPERTY_OUTBOUND_SNI = "com.ibm.mq.cfg.SSL.outboundSNI";
    private static final String PROPERTY_CHANNEL_SHARING = "com.ibm.mq.jms.channel.sharing";
    private String queueManager = "QM1";
    private String channel = "DEV.ADMIN.SVRCONN";
    private String connName = "localhost(1414)";
    private String clientId;
    private String applicationName;
    private String user = "";
    private String password = "";
    private String token = "";
    private boolean userAuthenticationMQCSP;
    private boolean useAuthenticationMQCSP;
    private boolean authCSP = true;
    private String sslCipherSuite;
    private String sslCipherSpec;
    private String sslPeerName;
    private boolean useIBMCipherMappings = true;
    private String outboundSNI = "";
    private String channelSharing = "";
    private String reconnect = "";
    private int reconnectTimeout = 1800;
    private String defaultReconnect = null;
    private String ccdtUrl;
    private String tempQPrefix = null;
    private String tempTopicPrefix = null;
    private String tempModel = null;
    private boolean sslFIPSRequired = false;
    private int sslKeyResetCount = -1;
    private String sslCertificateValPolicy = "";
    private String sslBundle;
    private String balancingApplicationType = "";
    private String balancingTimeout = "";
    private String balancingOptions = "";
    private String balancingInstanceMode = "";
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    @NestedConfigurationProperty
    private JmsPoolConnectionFactoryProperties pool = new JmsPoolConnectionFactoryProperties();
    @NestedConfigurationProperty
    private MQConfigurationPropertiesJndi jndi = new MQConfigurationPropertiesJndi();
    @NestedConfigurationProperty
    private MQConfigurationPropertiesJks jks = new MQConfigurationPropertiesJks();
    @NestedConfigurationProperty
    private MQConfigurationPropertiesTrace trace = new MQConfigurationPropertiesTrace();
    @NestedConfigurationProperty
    private MQConfigurationPropertiesTokenServer tokenServer = new MQConfigurationPropertiesTokenServer();

    public MQConfigurationProperties() {
        logger.trace("constructor");
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String connName) {
        this.connName = connName;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSslCipherSuite() {
        return this.sslCipherSuite;
    }

    public void setSslCipherSuite(String sslCipherSuite) {
        this.sslCipherSuite = sslCipherSuite;
    }

    public String getSslCipherSpec() {
        return this.sslCipherSpec;
    }

    public void setSslCipherSpec(String sslCipherSpec) {
        this.sslCipherSpec = sslCipherSpec;
    }

    public boolean isUseIBMCipherMappings() {
        return this.useIBMCipherMappings;
    }

    public void setUseIBMCipherMappings(boolean useIBMCipherMappings) {
        System.setProperty(PROPERTY_USE_IBM_CIPHER_MAPPINGS, Boolean.toString(useIBMCipherMappings));
        this.useIBMCipherMappings = useIBMCipherMappings;
    }

    public String getOutboundSNI() {
        return this.outboundSNI;
    }

    public void setOutboundSNI(String outboundSNI) {
        System.setProperty(PROPERTY_OUTBOUND_SNI, outboundSNI);
        this.outboundSNI = outboundSNI;
    }

    public String getChannelSharing() {
        return this.channelSharing;
    }

    public void setChannelSharing(String channelSharing) {
        System.setProperty(PROPERTY_CHANNEL_SHARING, channelSharing);
        this.channelSharing = channelSharing;
    }

    public boolean isUseAuthenticationMQCSP() {
        return this.authCSP;
    }

    public void setUserAuthenticationMQCSP(boolean userAuthenticationMQCSP) {
        this.authCSP = userAuthenticationMQCSP;
    }

    public void setUseAuthenticationMQCSP(boolean useAuthenticationMQCSP) {
        this.authCSP = useAuthenticationMQCSP;
    }

    public String getSslPeerName() {
        return this.sslPeerName;
    }

    public void setSslPeerName(String sslPeerName) {
        this.sslPeerName = sslPeerName;
    }

    public String getCcdtUrl() {
        return this.ccdtUrl;
    }

    public void setCcdtUrl(String ccdtUrl) {
        this.ccdtUrl = ccdtUrl;
    }

    public JmsPoolConnectionFactoryProperties getPool() {
        return this.pool;
    }

    public MQConfigurationPropertiesJndi getJndi() {
        return this.jndi;
    }

    public MQConfigurationPropertiesJks getJks() {
        return this.jks;
    }

    public MQConfigurationPropertiesTrace getTrace() {
        return this.trace;
    }

    public MQConfigurationPropertiesTokenServer getTokenServer() {
        return this.tokenServer;
    }

    public String getTempQPrefix() {
        return this.tempQPrefix;
    }

    public void setTempQPrefix(String tempQPrefix) {
        this.tempQPrefix = tempQPrefix;
    }

    public String getTempTopicPrefix() {
        return this.tempTopicPrefix;
    }

    public void setTempTopicPrefix(String tempTopicPrefix) {
        this.tempTopicPrefix = tempTopicPrefix;
    }

    public String getTempModel() {
        return this.tempModel;
    }

    public void setTempModel(String tempModel) {
        this.tempModel = tempModel;
    }

    public boolean isSslFIPSRequired() {
        return this.sslFIPSRequired;
    }

    public void setSslFIPSRequired(boolean sslFIPSRequired) {
        this.sslFIPSRequired = sslFIPSRequired;
    }

    public String getSslCertificateValPolicy() {
        return this.sslCertificateValPolicy;
    }

    public void setSslCertificateValPolicy(String sslCertificateValPolicy) {
        this.sslCertificateValPolicy = sslCertificateValPolicy;
    }

    public boolean isSslCertificateValidationNone() {
        boolean rc = false;
        if (this.sslCertificateValPolicy != null && this.sslCertificateValPolicy.equalsIgnoreCase("none")) {
            rc = true;
        }
        return rc;
    }

    public int getSslKeyResetCount() {
        return this.sslKeyResetCount;
    }

    public void setSslKeyResetCount(int sslKeyResetCount) {
        this.sslKeyResetCount = sslKeyResetCount;
    }

    public String getSslBundle() {
        return this.sslBundle;
    }

    public void setSslBundle(String sslBundle) {
        this.sslBundle = sslBundle;
    }

    public int getReconnectValue() {
        int rc = 0;
        switch (this.reconnect.toUpperCase()) {
            case "QMGR": {
                rc = 0x4000000;
                break;
            }
            case "DISABLED": 
            case "NO": 
            case "FALSE": {
                rc = 0x2000000;
                break;
            }
            case "YES": 
            case "TRUE": 
            case "ANY": {
                rc = 0x1000000;
                break;
            }
            default: {
                rc = 0;
            }
        }
        return rc;
    }

    public void setDefaultReconnect(String defaultReconnect) {
        this.reconnect = defaultReconnect;
    }

    @DeprecatedConfigurationProperty(replacement="ibm.mq.reconnect")
    public String getDefaultReconnect() {
        return this.defaultReconnect;
    }

    public String getReconnect() {
        return this.reconnect;
    }

    public void setReconnect(String reconnect) {
        this.reconnect = reconnect;
    }

    public void setReconnectTimeout(int reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public int getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setBalancingTimeout(String balancingTimeout) {
        this.balancingTimeout = balancingTimeout;
    }

    public String getBalancingTimeout() {
        return this.balancingTimeout;
    }

    public void setBalancingApplicationType(String balancingApplicationType) {
        this.balancingApplicationType = balancingApplicationType;
    }

    public String getBalancingApplicationType() {
        return this.balancingApplicationType;
    }

    public void setBalancingOptions(String balancingOptions) {
        this.balancingOptions = balancingOptions;
    }

    public void setBalancingInstanceMode(String balancingInstanceMode) {
        this.balancingInstanceMode = balancingInstanceMode;
    }

    public String getBalancingOptions() {
        return this.balancingOptions;
    }

    public int getBalancingApplicationTypeValue() {
        String ba;
        int rc = 0;
        if (this.balancingApplicationType == null || this.balancingApplicationType.equals("")) {
            return rc;
        }
        switch (ba = this.balancingApplicationType.trim().toUpperCase().replaceAll("_", "")) {
            case "REQREP": 
            case "REQUESTREPLY": {
                rc = 1;
                break;
            }
            case "SIMPLE": {
                rc = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ApplicationType value '%s' not recognised", this.balancingApplicationType));
            }
        }
        return rc;
    }

    public int getBalancingTimeoutValue() {
        String ba;
        int rc = -1;
        if (this.balancingTimeout == null || this.balancingTimeout.equals("")) {
            return rc;
        }
        switch (ba = this.balancingTimeout.toUpperCase()) {
            case "DEFAULT": {
                rc = -1;
                break;
            }
            case "IMMEDIATE": {
                rc = 0;
                break;
            }
            case "NEVER": {
                rc = -2;
                break;
            }
            default: {
                try {
                    rc = (int)(Duration.parse(ba).toMillis() / 1000L);
                    break;
                }
                catch (DateTimeParseException e) {
                    if (ba.endsWith("S")) {
                        ba = ba.substring(0, ba.length() - 1);
                    }
                    rc = Integer.parseInt(ba);
                }
            }
        }
        return rc;
    }

    public int getBalancingOptionsValue() {
        String[] boArray;
        int rc = 0;
        if (this.balancingOptions == null || this.balancingOptions.isEmpty()) {
            return rc;
        }
        block10: for (String bo : boArray = this.balancingOptions.split(",")) {
            String boCanon = bo.trim().toUpperCase().replaceAll("_", "");
            try {
                int val = Integer.decode(boCanon);
                rc |= val;
            }
            catch (NumberFormatException e) {
                switch (boCanon) {
                    case "NONE": {
                        rc |= 0;
                        continue block10;
                    }
                    case "IGNORETRANS": {
                        rc |= 1;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Balancing Options value '%s' not recognised", bo));
                    }
                }
            }
        }
        return rc;
    }

    public String getBalancingInstanceMode() {
        return this.balancingInstanceMode;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> properties) {
        this.additionalProperties = properties;
    }

    public void traceProperties(MQConnectionDetails connectionDetails) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("queueManager    : {}", (Object)connectionDetails.getQueueManager());
        logger.trace("applicationName : {}", (Object)this.getApplicationName());
        logger.trace("ccdtUrl         : {}", (Object)this.getCcdtUrl());
        logger.trace("channel         : {}", (Object)connectionDetails.getChannel());
        logger.trace("clientId        : {}", (Object)this.getClientId());
        logger.trace("connName        : {}", (Object)connectionDetails.getConnName());
        logger.trace("reconnectOption : '{}' [{}]", (Object)this.getReconnect(), (Object)String.format("0x%08X", this.getReconnectValue()));
        logger.trace("reconnectTimeout: {}", (Object)this.getReconnectTimeout());
        logger.trace("sslCipherSpec   : {}", (Object)this.getSslCipherSpec());
        logger.trace("sslCipherSuite  : {}", (Object)this.getSslCipherSuite());
        logger.trace("sslKeyresetcount: {}", (Object)this.getSslKeyResetCount());
        logger.trace("sslPeerName     : {}", (Object)this.getSslPeerName());
        logger.trace("sslBundle       : {}", (Object)this.getSslBundle());
        logger.trace("tempModel       : {}", (Object)this.getTempModel());
        logger.trace("tempQPrefix     : {}", (Object)this.getTempQPrefix());
        logger.trace("tempTopicPrefix : {}", (Object)this.getTempTopicPrefix());
        logger.trace("user            : '{}'", (Object)connectionDetails.getUser());
        logger.trace("password set    : {}", (Object)(connectionDetails.getPassword() != null && connectionDetails.getPassword().length() > 0 ? "YES" : "NO"));
        logger.trace("token set       : {}", (Object)(this.getToken() != null && this.getToken().length() > 0 ? "YES" : "NO"));
        this.getTokenServer().traceProperties(logger);
        logger.trace("sslFIPSRequired        : {}", (Object)this.isSslFIPSRequired());
        logger.trace("sslCertValPolicy       : '{}'", (Object)this.getSslCertificateValPolicy());
        logger.trace("useIBMCipherMappings   : {}", (Object)this.isUseIBMCipherMappings());
        logger.trace("userAuthenticationMQCSP: {}", (Object)this.isUseAuthenticationMQCSP());
        logger.trace("outboundSNI            : '{}'", (Object)this.getOutboundSNI());
        logger.trace("channelSharing         : '{}'", (Object)this.getChannelSharing());
        logger.trace("balancingAppType       : '{}' [{}]", (Object)this.getBalancingApplicationType(), (Object)this.getBalancingApplicationTypeValue());
        logger.trace("balancingTimeout       : '{}' [{}]", (Object)this.getBalancingTimeout(), (Object)this.getBalancingTimeoutValue());
        logger.trace("balancingOptions       : '{}' [{}]", (Object)this.getBalancingOptions(), (Object)this.getBalancingOptionsValue());
        logger.trace("balancingInstanceMode  : '{}' ", (Object)this.getBalancingInstanceMode());
        logger.trace("jndiCF          : {}", (Object)this.getJndi().getProviderContextFactory());
        logger.trace("jndiProviderUrl : {}", (Object)this.getJndi().getProviderUrl());
        if (U.isNullOrEmpty(this.getSslBundle())) {
            String pw = this.getJks().getKeyStorePassword();
            logger.trace("JKS keystore           : {}", (Object)this.getJks().getKeyStore());
            logger.trace("JKS keystore pw set    : {}", (Object)(pw != null && pw.length() > 0 ? "YES" : "NO"));
            pw = this.getJks().getTrustStorePassword();
            logger.trace("JKS truststore         : {}", (Object)this.getJks().getTrustStore());
            logger.trace("JKS truststore pw set  : {}", (Object)(pw != null && pw.length() > 0 ? "YES" : "NO"));
        } else {
            logger.trace("JKS key/truststore overridden by sslBundle");
        }
        if (this.additionalProperties.size() > 0) {
            for (String s : this.additionalProperties.keySet()) {
                logger.trace("Additional Property - {} : {}", (Object)s, (Object)this.additionalProperties.get(s));
            }
        } else {
            logger.trace("No additional properties defined");
        }
        if (this.pool.isEnabled()) {
            logger.trace("Pool blockIfFullTimeout         : {}", (Object)this.pool.getBlockIfFullTimeout().toString());
            logger.trace("Pool idleTimeout                : {}", (Object)this.pool.getIdleTimeout().toString());
            logger.trace("Pool maxConnections             : {}", (Object)this.pool.getMaxConnections());
            logger.trace("Pool maxSessionsPerConn         : {}", (Object)this.pool.getMaxSessionsPerConnection());
            logger.trace("Pool timeBetweenExpirationCheck : {}", (Object)this.pool.getTimeBetweenExpirationCheck().toString());
        } else {
            logger.trace("Pooling is disabled");
        }
        this.getTrace().traceProperties(logger);
    }
}

