/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.testcontainers.service.connection;

import com.ibm.mq.spring.boot.MQConnectionDetails;
import com.ibm.mq.testcontainers.MQContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;

public class MQContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MQContainer, MQConnectionDetails> {
    private static Logger logger = LoggerFactory.getLogger(MQContainerConnectionDetailsFactory.class);

    protected MQConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MQContainer> source) {
        logger.trace("Source: {}", (Object)(source == null ? "null" : source.getOrigin().toString()));
        return new MQContainerConnectionDetails(source);
    }

    private static final class MQContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MQContainer>
    implements MQConnectionDetails {
        private static Logger logger = LoggerFactory.getLogger(MQContainerConnectionDetails.class);

        private MQContainerConnectionDetails(ContainerConnectionSource<MQContainer> source) {
            super(source);
            logger.trace("constructor");
        }

        public String getConnName() {
            return ((MQContainer)this.getContainer()).getConnName();
        }

        public String getQueueManager() {
            return ((MQContainer)this.getContainer()).getQueueManager();
        }

        public String getChannel() {
            return ((MQContainer)this.getContainer()).getChannel();
        }

        public String getUser() {
            return ((MQContainer)this.getContainer()).getAppUser();
        }

        public String getPassword() {
            return ((MQContainer)this.getContainer()).getAppPassword();
        }
    }
}

