/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import com.ibm.commons.util.EmptyIterator;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.io.FastBufferedOutputStream;
import com.ibm.commons.xml.Format;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.NodeListIterator;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XPathContext;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.drivers.AbstractJAXPDriver;
import com.ibm.commons.xml.drivers.JAXPDriverSun;
import com.ibm.commons.xml.drivers.JAXPDriverXerces;
import com.ibm.commons.xml.drivers.XMLParserDriver;
import com.ibm.commons.xml.drivers.XercesDriver;
import com.ibm.commons.xml.drivers.XercesSunDriver;
import com.ibm.commons.xml.util.XMIConverter;
import com.ibm.commons.xml.xpath.NodeListImpl;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.XPathExpression;
import com.ibm.commons.xml.xpath.XPathExpressionFactory;
import com.ibm.commons.xml.xpath.xml.XmlXPathExpressionFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtil {
    private static XMLParserDriver s_parserDriver;
    private static XmlXPathExpressionFactory s_xpathFactory;

    static {
        DOMUtil.loadDriver();
        s_xpathFactory = new XmlXPathExpressionFactory(s_parserDriver);
    }

    private static void loadDriver() {
        Object builder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (Throwable throwable) {}
        if (builder.getClass().getName().startsWith("org.apache.xerces")) {
            s_parserDriver = new XercesDriver();
            return;
        }
        if (builder.getClass().getName().startsWith("com.sun.org.apache.xerces")) {
            s_parserDriver = new XercesSunDriver();
            return;
        }
        try {
            Class.forName("org.apache.xpath.XPathAPI");
            s_parserDriver = new JAXPDriverXerces();
        }
        catch (Throwable throwable) {}
        try {
            Class.forName("com.sun.org.apache.xpath.internal.XPath");
            s_parserDriver = new JAXPDriverSun();
        }
        catch (Throwable throwable) {}
        s_parserDriver = new AbstractJAXPDriver(){

            @Override
            public Object createXPath(String xpath) throws XPathException {
                throw DOMUtil.noXpathAvail();
            }

            @Override
            public XResult evaluateXPath(Node node, Object xpath, NamespaceContext nsContext) throws XPathException {
                throw DOMUtil.noXpathAvail();
            }

            @Override
            public XResult evaluateXPath(NodeList nodeList, Object xpath, NamespaceContext nsContext) throws XPathException {
                throw DOMUtil.noXpathAvail();
            }
        };
    }

    private static XPathException noXpathAvail() {
        return new XPathException(null, "XPath engine is not available");
    }

    public static XMLParserDriver getParserDriver() {
        return s_parserDriver;
    }

    public static XPathExpressionFactory getXPathExpressionFactory() {
        return s_xpathFactory;
    }

    public static Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws XMLException {
        return s_parserDriver.createDocument(namespaceURI, qualifiedName, doctype);
    }

    public static Document createDocument(String namespaceURI, String qualifiedName) throws XMLException {
        return DOMUtil.createDocument(namespaceURI, qualifiedName, null);
    }

    public static Document createDocument(DocumentType docType) throws XMLException {
        return DOMUtil.createDocument(null, null, docType);
    }

    public static Document createDocument() throws XMLException {
        return DOMUtil.createDocument(null, null, null);
    }

    public static Document createDocument(InputStream is, boolean ignoreBlanks) throws XMLException {
        return s_parserDriver.parse(is, ignoreBlanks, true, false);
    }

    public static Document createDocument(InputStream is, boolean ignoreBlanks, boolean resolveEntities) throws XMLException {
        return s_parserDriver.parse(is, ignoreBlanks, resolveEntities, false);
    }

    public static Document createDocument(InputStream is, boolean ignoreBlanks, boolean resolveEntities, boolean validate) throws XMLException {
        return s_parserDriver.parse(is, ignoreBlanks, resolveEntities, validate);
    }

    public static Document createDocument(InputStream is) throws XMLException {
        return DOMUtil.createDocument(is, true);
    }

    public static Document createDocument(Reader is, boolean ignoreBlanks) throws XMLException {
        return s_parserDriver.parse(is, ignoreBlanks, true, false);
    }

    public static Document createDocument(Reader is, boolean ignoreBlanks, boolean resolveEntities) throws XMLException {
        return s_parserDriver.parse(is, ignoreBlanks, resolveEntities, false);
    }

    public static Document createDocument(Reader is, boolean ignoreBlanks, boolean resolveEntities, boolean validate) throws XMLException {
        return s_parserDriver.parse(is, ignoreBlanks, resolveEntities, validate);
    }

    public static Document createDocument(Reader is) throws XMLException {
        return DOMUtil.createDocument(is, true);
    }

    public static Document createDocument(String xmlText, boolean ignoreBlanks) throws XMLException {
        if (StringUtil.isEmpty((String)xmlText)) {
            return DOMUtil.createDocument();
        }
        return DOMUtil.createDocument(new StringReader(xmlText), ignoreBlanks);
    }

    public static Document createDocument(String xmlText) throws XMLException {
        return DOMUtil.createDocument(xmlText, true);
    }

    public static DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws XMLException {
        return s_parserDriver.createDocumentType(qualifiedName, publicId, systemId);
    }

    public static Element rootElement(Document document) {
        return document.getDocumentElement();
    }

    public static boolean hasRootElement(Document document) {
        if (document != null) {
            Element tmp = document.getDocumentElement();
            return tmp != null;
        }
        return false;
    }

    public static boolean hasChildren(Element element) {
        if (element != null) {
            return element.hasChildNodes();
        }
        return false;
    }

    public static void removeChildren(Node node) {
        if (node != null) {
            while (node.hasChildNodes()) {
                node.removeChild(node.getFirstChild());
            }
        }
    }

    public static Document emptyDocument(Document doc) {
        Element rootNode = doc.getDocumentElement();
        if (rootNode != null) {
            doc.removeChild(rootNode);
        }
        return doc;
    }

    public static String getTextValue(Node node) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                if (node.hasChildNodes()) {
                    NodeList l = node.getChildNodes();
                    int len = l.getLength();
                    if (len == 1) {
                        Node child = l.item(0);
                        if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                            return child.getNodeValue();
                        }
                        return null;
                    }
                    StringBuilder b = new StringBuilder(128);
                    int i = 0;
                    while (i < len) {
                        String s;
                        Node child = l.item(i);
                        if ((child.getNodeType() == 3 || child.getNodeType() == 4) && (s = child.getNodeValue()) != null) {
                            b.append(s);
                        }
                        ++i;
                    }
                    return b.toString();
                }
            } else if (node.getNodeType() == 3 || node.getNodeType() == 4 || node.getNodeType() == 2) {
                return node.getNodeValue();
            }
        }
        return null;
    }

    public static void setTextValue(Node node, String value) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 3) {
                        ((Text)child).setNodeValue(value);
                        return;
                    }
                    if (child.getNodeType() == 4) {
                        ((Text)child).setNodeValue(value);
                        return;
                    }
                    if ((child = child.getNextSibling()) == null) break;
                    child = child.getNextSibling();
                }
                if (node.hasChildNodes()) {
                    DOMUtil.removeChildren(node);
                }
                Text textNode = node.getOwnerDocument().createTextNode(value);
                node.appendChild(textNode);
            } else {
                node.setNodeValue(value);
            }
        }
    }

    public static void setTextValue(Node node, String value, boolean cdata) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 3 && !cdata) {
                        ((Text)child).setNodeValue(value);
                        return;
                    }
                    if (child.getNodeType() == 4 && cdata) {
                        ((Text)child).setNodeValue(value);
                        return;
                    }
                    child = child.getNextSibling();
                }
                if (node.hasChildNodes()) {
                    DOMUtil.removeChildren(node);
                }
                Text textNode = cdata ? node.getOwnerDocument().createCDATASection(value) : node.getOwnerDocument().createTextNode(value);
                node.appendChild(textNode);
            } else {
                node.setNodeValue(value);
            }
        }
    }

    public static Iterator getChildren(Node node) {
        if (node != null) {
            return new NodeListIterator(node.getChildNodes(), NodeListIterator.ELEMENT_FILTER);
        }
        return EmptyIterator.getInstance();
    }

    public static void serialize(File file, Node node, Format format) throws XMLException {
        try {
            FastBufferedOutputStream os = new FastBufferedOutputStream((OutputStream)new FileOutputStream(file));
            try {
                DOMUtil.serialize((OutputStream)os, node, format);
            }
            finally {
                os.close();
            }
        }
        catch (IOException e) {
            throw new XMLException(e, "JDOMUtil.XmlSavingToFile.Exception" + file.getPath());
        }
    }

    public static void serialize(OutputStream os, Node node, Format format) throws XMLException {
        s_parserDriver.serialize(os, node, format);
    }

    public static void serialize(OutputStream os, Node node, boolean compact, boolean xmldecl) throws XMLException {
        Format fmt = new Format(compact ? 0 : 2, xmldecl, "UTF-8");
        DOMUtil.serialize(os, node, fmt);
    }

    public static void serialize(Writer w, Node node, Format format) throws XMLException {
        s_parserDriver.serialize(w, node, format);
    }

    public static void serialize(Writer w, Node node, boolean compact, boolean xmldecl) throws XMLException {
        Format fmt = new Format(compact ? 0 : 2, xmldecl, "UTF-8");
        s_parserDriver.serialize(w, node, fmt);
    }

    public static String getXMLString(Node node, Format format) throws XMLException {
        StringWriter w = new StringWriter();
        DOMUtil.serialize(w, node, format);
        return w.toString();
    }

    public static String getXMLString(Node node, boolean compact, boolean xmldecl) throws XMLException {
        StringWriter w = new StringWriter();
        DOMUtil.serialize(w, node, compact, xmldecl);
        return w.toString();
    }

    public static String getXMLString(Node node, boolean compact) throws XMLException {
        return DOMUtil.getXMLString(node, compact, false);
    }

    public static String getXMLString(Node node) throws XMLException {
        return DOMUtil.getXMLString(node, false, false);
    }

    public static void setXMLString(Document target, String s) throws XMLException {
        Document source = DOMUtil.createDocument(s);
        DOMUtil.setDocument(source, target);
    }

    /*
     * Unable to fully structure code
     */
    public static void clearDocument(Document doc) {
        if (doc != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            doc.removeChild(doc.getFirstChild());
lbl5:
            // 2 sources

            ** while (doc.hasChildNodes())
        }
lbl6:
        // 1 sources

    }

    public static void setDocument(Document source, Document target) {
        if (source == null || target == null) {
            return;
        }
        DOMUtil.clearDocument(target);
        Node node = target.importNode(source.getDocumentElement(), true);
        target.appendChild(node);
    }

    public static void pushXPathContext(Document doc, String xPathContext) throws XMLException {
        s_parserDriver.pushXPathContext(doc, xPathContext);
    }

    public static void popXPathContext(Document doc) throws XMLException {
        s_parserDriver.popXPathContext(doc);
    }

    public static Object getContextNodes(Document doc) {
        XPathContext ctx = s_parserDriver.getXPathContext(doc);
        return ctx != null ? ctx.getContextNodes() : null;
    }

    public static XPathContext getXPathContext(Document doc) {
        return s_parserDriver.getXPathContext(doc);
    }

    public static void setFilterIndex(Document doc, int index) throws XMLException {
        XPathContext ctx = s_parserDriver.getXPathContext(doc);
        if (ctx == null) {
            throw new XMLException(null, "No current context defined for the document");
        }
        ctx.setFilterIndex(index);
    }

    public static void setSelectionNamespaces(Document doc, NamespaceContext selectionNS) {
        s_parserDriver.setNamespaceContext(doc, selectionNS);
    }

    public static NamespaceContext getSelectionNamespaces(Document doc) {
        return s_parserDriver.getNamespaceContext(doc);
    }

    public static String getNamespaceContextAsString(NamespaceContext namespaceContext) {
        StringBuffer b = new StringBuffer();
        boolean first = true;
        Iterator it = namespaceContext.getPrefixes();
        while (it.hasNext()) {
            String s = it.next().toString();
            if (!first) {
                b.append("\n");
            } else {
                first = false;
            }
            b.append(s);
            b.append("=");
            b.append(namespaceContext.getNamespaceURI(s));
        }
        return b.toString();
    }

    public static XPathExpression createXPath(String xpathExpr, boolean useCache) throws XMLException {
        return s_xpathFactory.createExpression(null, xpathExpr, useCache);
    }

    public static XPathExpression createXPath(String xpathExpr) throws XMLException {
        return s_xpathFactory.createExpression(null, xpathExpr, true);
    }

    public static XResult evaluateXPath(Node node, String xpathExpr, NamespaceContext nsContext, boolean useCache) throws XMLException {
        XPathExpression expr = DOMUtil.createXPath(xpathExpr, useCache);
        return expr.eval(node, nsContext);
    }

    public static XResult evaluateXPath(Node node, String xpathExpr, NamespaceContext nsContext) throws XMLException {
        return DOMUtil.evaluateXPath(node, xpathExpr, nsContext, true);
    }

    public static XResult evaluateXPath(Node node, String xpathExpr) throws XMLException {
        return DOMUtil.evaluateXPath(node, xpathExpr, null, true);
    }

    public static XResult evaluateXPath(Node node, String xpathExpr, boolean useCache) throws XMLException {
        return DOMUtil.evaluateXPath(node, xpathExpr, null, useCache);
    }

    public static Object createNodes(Node node, String xpathExpr, boolean useCache) throws XMLException {
        Document doc;
        XPathContext ctx;
        XPathExpression xp = DOMUtil.createXPath(xpathExpr);
        if (!xp.isFromRoot() && node instanceof Document && (ctx = s_parserDriver.getXPathContext(doc = (Document)node)) != null) {
            ctx.createNodes();
            return xp.createNodes(ctx.getUniqueContextNode(), null);
        }
        return xp.createNodes(node, null);
    }

    public static Object createNodes(Node node, String xpathExpr) throws XMLException {
        return DOMUtil.createNodes(node, xpathExpr, true);
    }

    public static Element createElement(Document document, Element parent, String name) {
        Element element = document.createElement(name);
        parent.appendChild(element);
        return element;
    }

    public static Element createElement(Document document, String name) {
        Element element = document.createElement(name);
        document.appendChild(element);
        return element;
    }

    public static Object[] nodes(Node node, String xpath) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath);
        return r.getNodes();
    }

    public static Object node(Node node, String xpath) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath);
        return r.getSingleNode();
    }

    public static Object[] nodes(Node node, String xpath, NamespaceContext selectionNS) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath, selectionNS);
        return r.getNodes();
    }

    public static Object node(Node node, String xpath, NamespaceContext selectionNS) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath, selectionNS);
        return r.getSingleNode();
    }

    public static String value(Node node, String xpath) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath);
        return r.getStringValue();
    }

    public static String value(Node node, String xpath, NamespaceContext selectionNS) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath, selectionNS);
        return r.getStringValue();
    }

    public static String[] values(Node node, String xpath) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath);
        return r.getValues();
    }

    public static String[] values(Node node, String xpath, NamespaceContext selectionNS) throws XMLException {
        XResult r = DOMUtil.evaluateXPath(node, xpath, selectionNS);
        return r.getValues();
    }

    public static void setValue(Node node, String path, String value) throws XMLException {
        DOMUtil.setValue(node, path, value, null);
    }

    public static void setValue(Node node, String path, String value, NamespaceContext selectionNS) throws XMLException {
        Document doc;
        XPathContext ctx;
        XPathExpression xp = DOMUtil.createXPath(path);
        if (!xp.isFromRoot() && node instanceof Document && (ctx = s_parserDriver.getXPathContext(doc = (Document)node)) != null) {
            ctx.createNodes();
            xp.setValue(ctx.getUniqueContextNode(), value, selectionNS, true);
            return;
        }
        xp.setValue(node, value, selectionNS, true);
    }

    public static Element getFirstElementByName(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Element e;
            String localName;
            Node n = l.item(i);
            if (n.getNodeType() == 1 && (localName = (e = (Element)n).getLocalName()) == null && name.equals(e.getNodeName())) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public static Element getFirstElementByNameNS(Element parent, String namespaceURI, String name) {
        NodeList l = parent.getChildNodes();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                String elemNsURI;
                Element e = (Element)n;
                String localName = e.getLocalName();
                if (localName == null && name.equals(e.getNodeName())) {
                    return e;
                }
                if (namespaceURI != null && name.equals(localName) && namespaceURI.equals(elemNsURI = e.getNamespaceURI())) {
                    return e;
                }
            }
            ++i;
        }
        return null;
    }

    public static NodeList getElementsByName(Element parent, String name) {
        NodeListImpl result = new NodeListImpl();
        NodeList l = parent.getChildNodes();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Element e;
            String localName;
            Node n = l.item(i);
            if (n.getNodeType() == 1 && (localName = (e = (Element)n).getLocalName()) == null && name.equals(e.getNodeName())) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    public static NodeList getElementsByNameNS(Element parent, String namespaceURI, String name) {
        NodeListImpl result = new NodeListImpl();
        NodeList l = parent.getChildNodes();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                String elemNsURI;
                Element e = (Element)n;
                String localName = e.getLocalName();
                if (localName == null && name.equals(e.getNodeName())) {
                    result.add(e);
                }
                if (namespaceURI != null && name.equals(localName) && namespaceURI.equals(elemNsURI = e.getNamespaceURI())) {
                    result.add(e);
                }
            }
            ++i;
        }
        return result;
    }

    public static Node insertAfter(Node parent, Node newChild, Node refChild) {
        if (refChild != null) {
            Node next = refChild.getNextSibling();
            return parent.insertBefore(newChild, next);
        }
        return parent.insertBefore(newChild, refChild);
    }

    public static boolean moveNodeUp(Node node) {
        Node parent = node.getParentNode();
        Node previous = node.getPreviousSibling();
        if (previous != null) {
            parent.removeChild(node);
            parent.insertBefore(node, previous);
            return true;
        }
        return false;
    }

    public static boolean moveNodeDown(Node node) {
        Node parent = node.getParentNode();
        Node next = node.getNextSibling();
        if (next != null) {
            parent.removeChild(node);
            DOMUtil.insertAfter(parent, node, next);
            return true;
        }
        return false;
    }

    public static boolean isNamespaceAttribute(Attr attribute) {
        boolean rtnVal = false;
        String prefix = attribute.getPrefix();
        if (StringUtil.equals((String)prefix, (String)"xmlns")) {
            rtnVal = true;
        }
        return rtnVal;
    }

    public static Attr getAttributeIgnoreCase(Element element, String attributeName) {
        NamedNodeMap nm = element.getAttributes();
        int i = 0;
        while (i < nm.getLength()) {
            Attr a = (Attr)nm.item(i);
            if (a.getName().equalsIgnoreCase(attributeName)) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public static void removeAttributeIgnoreCase(Element element, String attributeName) {
        Attr a = DOMUtil.getAttributeIgnoreCase(element, attributeName);
        if (a != null) {
            element.removeAttributeNode(a);
        }
    }

    public static String getAttributeValueIgnoreCase(Element element, String attributeName) {
        Attr a = DOMUtil.getAttributeIgnoreCase(element, attributeName);
        if (a != null) {
            a.getValue();
        }
        return null;
    }

    public static Document getOwnerDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static String getNamespacePrefix(Node parentNode, String preferredPrefix, String nsUri) {
        int i;
        Node currentNode = parentNode;
        do {
            NamedNodeMap nodeMap = currentNode.getAttributes();
            i = 0;
            while (nodeMap != null && i < nodeMap.getLength()) {
                String uri;
                Node item = nodeMap.item(i);
                String itemName = item.getNodeName();
                if (itemName.startsWith("xmlns") && nsUri.equals(uri = DOMUtil.getTextValue(item))) {
                    return itemName.substring(itemName.indexOf(":") + 1);
                }
                ++i;
            }
        } while ((currentNode = currentNode.getParentNode()) != null);
        Element root = parentNode.getOwnerDocument().getDocumentElement();
        if (root != null) {
            i = 1;
            while (true) {
                String p = preferredPrefix;
                if (i > 1) {
                    p = String.valueOf(p) + i;
                }
                if (root.getAttributeNode("xmlns:" + p) == null) {
                    root.setAttribute("xmlns:" + p, nsUri);
                    return p;
                }
                ++i;
            }
        }
        return "";
    }

    public static Document clone(Document inDoc) {
        Document rtnVal = (Document)inDoc.cloneNode(true);
        return rtnVal;
    }

    public static String getChildText(Element element, String nodeName) {
        NodeList ndlist = element.getChildNodes();
        String rtnVal = null;
        int i = 0;
        while (i < ndlist.getLength()) {
            Node nd = ndlist.item(i);
            if (nd.getNodeType() == 1 && nd.getNodeName().equals(nodeName)) {
                rtnVal = DOMUtil.getText(nd);
                break;
            }
            ++i;
        }
        return rtnVal;
    }

    public static String getText(Node n) {
        String rtnVal = "";
        NodeList nlist = n.getChildNodes();
        int i = 0;
        while (i < nlist.getLength()) {
            Node currentNode = nlist.item(i);
            if (currentNode.getNodeType() == 3) {
                rtnVal = currentNode.getNodeValue();
            }
            ++i;
        }
        return rtnVal;
    }

    public static String getAttributeValue(Element e, String key) {
        String value = null;
        NamedNodeMap map = e.getAttributes();
        Node keyNode = map.getNamedItem(key);
        if (keyNode != null) {
            value = keyNode.getNodeValue();
        }
        return value;
    }

    public static void addNode(Element parent, String elementName) {
        DOMUtil.addNode(parent, elementName, null);
    }

    public static void addNode(Element parent, String elementName, String namespaceURI) {
        Document doc = parent.getOwnerDocument();
        Element elt = doc.createElementNS(namespaceURI, elementName);
        parent.appendChild(elt);
    }

    public static void addBigDecimal(Element parent, String elementName, BigDecimal value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addBigDecimal(Element parent, String elementName, BigDecimal value, String namespace) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespace);
    }

    public static void addBoolean(Element parent, String elementName, boolean value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addBoolean(Element parent, String elementName, boolean value, String namespace) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespace);
    }

    public static void addDate(Element parent, String elementName, Date value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addDate(Element parent, String elementName, Date value, String namespace) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespace);
    }

    public static void addDouble(Element parent, String elementName, double value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addDouble(Element parent, String elementName, double value, String namespace) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespace);
    }

    public static void addInteger(Element parent, String elementName, int value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addInteger(Element parent, String elementName, int value, String namespace) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespace);
    }

    public static void addLong(Element parent, String elementName, long value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addLong(Element parent, String elementName, long value, String namespace) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespace);
    }

    public static void addString(Element parent, String elementName, String value) {
        DOMUtil.addString(parent, elementName, value, null);
    }

    public static void addString(Element parent, String elementName, String value, String namespaceURI) {
        Document doc = parent.getOwnerDocument();
        Element elt = doc.createElementNS(namespaceURI, elementName);
        elt.appendChild(doc.createTextNode(value));
        parent.appendChild(elt);
    }

    public static void addTime(Element parent, String elementName, Time value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addTime(Element parent, String elementName, Time value, String namespaceURI) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespaceURI);
    }

    public static void addTimestamp(Element parent, String elementName, Timestamp value) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), null);
    }

    public static void addTimestamp(Element parent, String elementName, Timestamp value, String namespaceURI) {
        DOMUtil.addString(parent, elementName, XMIConverter.toString(value), namespaceURI);
    }

    public static List<Node> getChildrenAsList(Element elt) {
        ArrayList<Node> rtnVal = new ArrayList<Node>();
        NodeList nlist = elt.getChildNodes();
        int i = 0;
        while (i < nlist.getLength()) {
            rtnVal.add(i, nlist.item(i));
            ++i;
        }
        return rtnVal;
    }

    public static String getSourceReferenceId(Node node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String id = element.getAttribute("id");
            if (StringUtil.isEmpty((String)id)) {
                return DOMUtil.createSourceReferenceId(element);
            }
            return id;
        }
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            Element element = attr.getOwnerElement();
            String sourceId = DOMUtil.getSourceReferenceId(element);
            return String.valueOf(sourceId) + "/@" + attr.getName();
        }
        if (node.getNodeType() == 4 || node.getNodeType() == 3) {
            Node parent = node.getParentNode();
            String parentPath = DOMUtil.getSourceReferenceId(parent);
            if (parentPath.lastIndexOf(47) != parentPath.length() - 1) {
                parentPath = String.valueOf(parentPath) + '/';
            }
            int textsCount = 0;
            boolean lastWasText = false;
            int nodeTextListIndex = -1;
            NodeList children = parent.getChildNodes();
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                boolean siblingIsText;
                Node sibling = children.item(i);
                boolean bl = siblingIsText = 3 == sibling.getNodeType() || 4 == sibling.getNodeType();
                if (siblingIsText) {
                    if (!lastWasText && ++textsCount > 1 && -1 != nodeTextListIndex) break;
                    if (node == sibling) {
                        nodeTextListIndex = textsCount;
                        if (textsCount > 1 && -1 != nodeTextListIndex) break;
                    }
                }
                lastWasText = siblingIsText;
                ++i;
            }
            String path = textsCount == 1 ? String.valueOf(parentPath) + "text()" : String.valueOf(parentPath) + "text()[" + nodeTextListIndex + "]";
            return path;
        }
        if (node instanceof Document) {
            return "/";
        }
        return null;
    }

    private static String createSourceReferenceId(Element elt) {
        StringBuffer buffer = new StringBuffer();
        while (StringUtil.isEmpty((String)elt.getAttribute("id"))) {
            DOMUtil.insertElementReferenceId(buffer, elt);
            if (elt.getParentNode() == elt.getOwnerDocument()) break;
            elt = (Element)elt.getParentNode();
        }
        buffer.insert(0, elt.getAttribute("id"));
        return buffer.toString();
    }

    private static void insertElementReferenceId(StringBuffer buffer, Element elt) {
        int predicate = 1;
        Node sibling = elt;
        while ((sibling = sibling.getPreviousSibling()) != null) {
            if (!elt.getNodeName().equals(sibling.getNodeName())) continue;
            ++predicate;
        }
        buffer.insert(0, "]");
        buffer.insert(0, predicate);
        buffer.insert(0, "[");
        buffer.insert(0, elt.getNodeName());
        buffer.insert(0, "/");
    }

    public static NodeList getChildElementsByTagNameNS(Element element, String uri, String tag) {
        NodeList found = element.getElementsByTagNameNS(uri, tag);
        NodeListImpl children = new NodeListImpl();
        int i = 0;
        while (i < found.getLength()) {
            Node node = found.item(i);
            Node parentNode = node.getParentNode();
            if (parentNode.equals(element)) {
                children.add(node);
            }
            ++i;
        }
        return children;
    }

    public static NodeList getChildElementsByTagName(Element element, String tag) {
        NodeList found = element.getElementsByTagName(tag);
        NodeListImpl children = new NodeListImpl();
        int i = 0;
        while (i < found.getLength()) {
            Node node = found.item(i);
            Node parentNode = node.getParentNode();
            if (parentNode.equals(element)) {
                children.add(node);
            }
            ++i;
        }
        return children;
    }

    public static int compareLocations(Node node1, int offset1, Node node2, int offset2) {
        Node cpChild2;
        if (node1 == node2) {
            return offset1 - offset2;
        }
        List parents1 = DOMUtil.getParents(node1);
        List parents2 = DOMUtil.getParents(node2);
        parents1.add(0, node1);
        parents2.add(0, node2);
        if (node1.hasChildNodes()) {
            parents1.add(0, node1.getChildNodes().item(offset1));
        }
        if (node2.hasChildNodes()) {
            parents2.add(0, node2.getChildNodes().item(offset2));
        }
        Node commonParent = null;
        int cpIndex1 = 1;
        int cpIndex2 = 0;
        ListIterator iter = parents1.listIterator(cpIndex1);
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            int index = parents2.indexOf(node);
            if (index > 0) {
                commonParent = node;
                cpIndex2 = index;
                break;
            }
            ++cpIndex1;
        }
        if (commonParent == null) {
            return -1;
        }
        NodeList cpChildren = commonParent.getChildNodes();
        Node cpChild1 = (Node)parents1.get(cpIndex1 - 1);
        if (cpChild1 == (cpChild2 = (Node)parents2.get(cpIndex2 - 1))) {
            return offset1 - offset2;
        }
        if (cpChild1 == null) {
            return 1;
        }
        if (cpChild2 == null) {
            return -1;
        }
        int indexCpChild1 = DOMUtil.getOffsetInParent(cpChild1);
        int i = indexCpChild1 + 1;
        while (i < cpChildren.getLength()) {
            if (cpChildren.item(i) == cpChild2) {
                return -1;
            }
            ++i;
        }
        return 1;
    }

    private static List getParents(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        node = node.getParentNode();
        while (node != null) {
            list.add(node);
            node = node.getParentNode();
        }
        return list;
    }

    public static Node getNode(Node node, int offset) {
        if (node.getNodeType() != 3) {
            return node.getChildNodes().item(offset);
        }
        return node;
    }

    public static int getOffsetInParent(Node node) {
        Node parent = node.getParentNode();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child == node) {
                    return i;
                }
                ++i;
            }
            throw new IllegalStateException();
        }
        return -1;
    }

    public static NodeList getAllChildElementsByName(Element parent, String name) {
        NodeListImpl result = new NodeListImpl();
        NodeList l = parent.getChildNodes();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                String nodeName = e.getNodeName();
                if (name.equals(nodeName)) {
                    result.add(e);
                } else {
                    NodeList nl = DOMUtil.getAllChildElementsByName((Element)n, name);
                    if (nl.getLength() > 0) {
                        result = DOMUtil.concatNodeLists(result, nl);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static NodeListImpl concatNodeLists(NodeList nl1, NodeList nl2) {
        NodeListImpl results = new NodeListImpl();
        int i = 0;
        while (i < nl1.getLength()) {
            results.add(nl1.item(i));
            ++i;
        }
        i = 0;
        while (i < nl2.getLength()) {
            results.add(nl2.item(i));
            ++i;
        }
        return results;
    }

    public static Element getFirstElementAtAnyDepthByNodeName(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                String nodeName = e.getNodeName();
                if (name.equals(nodeName)) {
                    return e;
                }
                Element returnElement = DOMUtil.getFirstElementAtAnyDepthByNodeName(e, name);
                if (returnElement != null) {
                    return returnElement;
                }
            }
            ++i;
        }
        return null;
    }

    public static NodeList getChildNodesToNLevels(Node parent) {
        NodeList l = parent.getChildNodes();
        NodeListImpl returnList = new NodeListImpl();
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Node n = l.item(i);
            returnList.add(n);
            NodeList children = DOMUtil.getChildNodesToNLevels(n);
            if (children != null) {
                returnList = DOMUtil.concatNodeLists(returnList, children);
            }
            ++i;
        }
        return returnList;
    }

    public static boolean findChildAtAnyLevel(Node parent, Node child) {
        NodeList l = parent.getChildNodes();
        boolean returnBoolean = false;
        int count = l.getLength();
        int i = 0;
        while (i < count) {
            Node n = l.item(i);
            if (n == child) {
                returnBoolean = true;
            } else {
                boolean bl = returnBoolean = returnBoolean || DOMUtil.findChildAtAnyLevel(n, child);
            }
            if (returnBoolean) {
                return true;
            }
            ++i;
        }
        return returnBoolean;
    }
}

