/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceHandler {
    private static ResourceBundle _resourceBundle;
    private static ResourceBundle _loggingResourceBundle;

    private static ResourceBundle getResourceBundle(String bundle) {
        try {
            String bundlePackage = ResourceHandler.buildResourcePath(bundle);
            return ResourceBundle.getBundle(bundlePackage);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String buildResourcePath(String name) {
        String clName = ResourceHandler.class.getName();
        return String.valueOf(clName.substring(0, clName.lastIndexOf(46) + 1)) + name;
    }

    public static String getString(String key) {
        if (_resourceBundle == null) {
            _resourceBundle = ResourceHandler.getResourceBundle("messages");
        }
        return ResourceHandler.getResourceBundleString(_resourceBundle, key);
    }

    public static String getLoggingString(String key) {
        if (_loggingResourceBundle == null) {
            _loggingResourceBundle = ResourceHandler.getResourceBundle("logging");
        }
        return ResourceHandler.getResourceBundleString(_loggingResourceBundle, key);
    }

    public static String getResourceBundleString(ResourceBundle _bundle, String key) {
        if (_bundle != null) {
            try {
                return _bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                return "!" + key + "!";
            }
        }
        return "!" + key + "!";
    }
}

