/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import com.ibm.commons.util.EmptyIterator;
import com.ibm.commons.util.IteratorWrapper;
import com.ibm.commons.util.SingleValueIterator;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.DOMUtil;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.util.XMIConverter;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XResultUtils {
    public static Empty emptyResult = new Empty();
    private static Object[] EMPTY_NODES = new Object[0];
    private static String[] EMPTY_VALUES = new String[0];

    public static void dump(XResult result, PrintStream ps) {
        XResultUtils.dump(result, ps, null);
    }

    public static void dump(XResult result, PrintStream ps, NamespaceContext ns) {
        try {
            ps.print("Dumping XResult: ");
            switch (result.getValueType()) {
                case 0: {
                    ps.println(" Empty");
                    break;
                }
                case 1: {
                    ps.println(StringUtil.format((String)" String, {0}", (Object[])new Object[]{result.getStringValue()}));
                    break;
                }
                case 2: {
                    ps.println(StringUtil.format((String)" Boolean, {0}", (Object[])new Object[]{Boolean.toString(result.getBooleanValue())}));
                    break;
                }
                case 3: {
                    ps.println(StringUtil.format((String)" Double, {0}", (Object[])new Object[]{Double.toString(result.getNumberValue())}));
                    break;
                }
                case 4: {
                    ps.println(StringUtil.format((String)" Single Node, {0}", (Object[])new Object[]{XResultUtils.getNodePath((Node)result.getSingleNode(), ns)}));
                    break;
                }
                case 5: {
                    ps.println(StringUtil.format((String)" Multiple Node", (Object[])new Object[0]));
                    Iterator it = result.getNodeIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        ps.println(StringUtil.format((String)"     * {0}", (Object[])new Object[]{XResultUtils.getNodePath(n, ns)}));
                    }
                    break;
                }
                case 6: {
                    ps.println(StringUtil.format((String)" Date, {0}", (Object[])new Object[]{result.getStringValue()}));
                }
            }
        }
        catch (XMLException xMLException) {}
    }

    private static String getNodePath(Node node, NamespaceContext ns) {
        if (ns == null) {
            ns = DOMUtil.getSelectionNamespaces(node.getOwnerDocument());
        }
        StringBuffer b = new StringBuffer();
        XResultUtils.addNodePath(b, node, ns);
        String text = DOMUtil.getText(node);
        b.append("(");
        b.append(text);
        b.append(")");
        return b.toString();
    }

    private static void addNodePath(StringBuffer b, Node node, NamespaceContext ns) {
        Node p = node.getParentNode();
        if (p != null) {
            XResultUtils.addNodePath(b, p, ns);
            b.append("/");
        }
        if (node.getNodeType() == 1 || node.getNodeType() == 2) {
            String uri = node.getNamespaceURI();
            if (StringUtil.isNotEmpty((String)uri)) {
                String pre;
                String string = pre = ns != null ? ns.getPrefix(uri) : node.getPrefix();
                if (StringUtil.isNotEmpty((String)pre)) {
                    b.append(pre);
                    b.append(':');
                }
            }
            String localName = node.getLocalName();
            if (node.getNodeType() == 2) {
                b.append('@');
            }
            b.append(localName);
        }
    }

    private static abstract class AbstractResult
    implements XResult {
        private AbstractResult() {
        }
    }

    public static class BooleanValue
    extends ValueResult {
        private boolean value;

        public BooleanValue(boolean value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o instanceof BooleanValue) {
                BooleanValue r = (BooleanValue)o;
                return this.value == r.value;
            }
            return false;
        }

        @Override
        public int getValueType() {
            return 2;
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        protected String stringValue() {
            return this.value ? "true" : "false";
        }

        @Override
        public double getNumberValue() {
            return this.value ? 1.0 : 0.0;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }
    }

    private static class Empty
    extends AbstractResult {
        public boolean equals(Object o) {
            return o instanceof Empty;
        }

        @Override
        public int getValueType() {
            return 0;
        }

        @Override
        public boolean isValue() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public String getStringValue() {
            return null;
        }

        @Override
        public double getNumberValue() {
            return 0.0;
        }

        @Override
        public boolean getBooleanValue() {
            return false;
        }

        @Override
        public Date getDateValue() throws XMLException {
            return null;
        }

        @Override
        public Object getSingleNode() {
            return null;
        }

        @Override
        public Iterator getNodeIterator() {
            return EmptyIterator.getInstance();
        }

        @Override
        public Object[] getNodes() {
            return EMPTY_NODES;
        }

        @Override
        public Iterator getValueIterator() {
            return EmptyIterator.getInstance();
        }

        @Override
        public String[] getValues() {
            return EMPTY_VALUES;
        }

        public String toString() {
            return null;
        }
    }

    public static abstract class MultipleNode
    extends AbstractResult {
        @Override
        public int getValueType() {
            return 5;
        }

        @Override
        public boolean isValue() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public double getNumberValue() throws XMLException {
            throw new XMLException(null, "Cannot get single value from a node list");
        }

        @Override
        public boolean getBooleanValue() throws XMLException {
            throw new XMLException(null, "Cannot get single value from a node list");
        }

        @Override
        public Date getDateValue() throws XMLException {
            throw new XMLException(null, "Cannot get single value from a node list");
        }

        @Override
        public Object getSingleNode() throws XMLException {
            throw new XMLException(null, "Cannot get single node from a node list");
        }

        protected abstract String getText(Object var1);

        @Override
        public abstract Iterator getNodeIterator();

        @Override
        public Iterator getValueIterator() {
            return new IteratorWrapper(this.getNodeIterator()){

                protected Object wrap(Object o) {
                    return MultipleNode.this.getText(o);
                }
            };
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator i = this.getNodeIterator();
            while (i.hasNext()) {
                sb.append(DOMUtil.getTextValue((Node)i.next()));
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }

    public static class NumberValue
    extends ValueResult {
        private double value;

        public NumberValue(double value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o instanceof NumberValue) {
                NumberValue r = (NumberValue)o;
                return this.value == r.value;
            }
            return false;
        }

        @Override
        public int getValueType() {
            return 3;
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        protected String stringValue() {
            return Double.toString(this.value);
        }

        @Override
        public double getNumberValue() {
            return this.value;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value != 0.0;
        }
    }

    public static abstract class SingleNode
    extends AbstractResult {
        private Object node;

        public SingleNode(Object node) {
            this.node = node;
        }

        public boolean equals(Object o) {
            if (o instanceof SingleNode) {
                SingleNode r = (SingleNode)o;
                return this.node == r.node;
            }
            return false;
        }

        @Override
        public int getValueType() {
            return 4;
        }

        @Override
        public boolean isValue() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public String getStringValue() {
            return this.getText(this.node);
        }

        @Override
        public double getNumberValue() throws XMLException {
            try {
                String str = this.getText(this.node);
                return Double.parseDouble(str);
            }
            catch (Exception e) {
                throw new XMLException(e, "Error getting number value");
            }
        }

        @Override
        public boolean getBooleanValue() {
            String str = this.getText(this.node);
            return str.equals("true");
        }

        @Override
        public Date getDateValue() {
            String str = this.getText(this.node);
            return XMIConverter.parseDate(str);
        }

        @Override
        public Object getSingleNode() {
            return this.node;
        }

        @Override
        public Iterator getNodeIterator() {
            return new SingleValueIterator(this.node);
        }

        @Override
        public Object[] getNodes() {
            return new Object[]{this.node};
        }

        @Override
        public Iterator getValueIterator() {
            return new SingleValueIterator((Object)this.getText(this.node));
        }

        @Override
        public String[] getValues() {
            return new String[]{this.getText(this.node)};
        }

        public String toString() {
            return this.getStringValue();
        }

        protected abstract String getText(Object var1);
    }

    public static class StringValue
    extends ValueResult {
        private String value;

        public StringValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o instanceof StringValue) {
                StringValue r = (StringValue)o;
                return StringUtil.equals((String)this.value, (String)r.value);
            }
            return false;
        }

        @Override
        public int getValueType() {
            return 1;
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        protected String stringValue() {
            return this.value;
        }

        @Override
        public double getNumberValue() throws XMLException {
            try {
                return Double.parseDouble(this.value);
            }
            catch (Exception e) {
                throw new XMLException(e, "Error getting number value");
            }
        }

        @Override
        public boolean getBooleanValue() {
            return this.value.equals("true");
        }
    }

    private static abstract class ValueResult
    extends AbstractResult {
        private ValueResult() {
        }

        @Override
        public Object getSingleNode() {
            return null;
        }

        @Override
        public Iterator getNodeIterator() {
            return EmptyIterator.getInstance();
        }

        @Override
        public Object[] getNodes() {
            return EMPTY_NODES;
        }

        @Override
        public Iterator getValueIterator() {
            return new SingleValueIterator((Object)this.stringValue());
        }

        @Override
        public String[] getValues() {
            return new String[]{this.stringValue()};
        }

        @Override
        public String getStringValue() {
            return this.stringValue();
        }

        @Override
        public Date getDateValue() throws XMLException {
            return XMIConverter.parseDate(this.getStringValue());
        }

        public String toString() {
            return this.stringValue();
        }

        abstract String stringValue();
    }

    public static class XMLNode
    extends SingleNode {
        public XMLNode(Node node) {
            super(node);
        }

        @Override
        protected String getText(Object node) {
            return DOMUtil.getTextValue((Node)node);
        }
    }

    public static class XMLNodeList
    extends MultipleNode {
        private NodeList nodeList;

        public XMLNodeList(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        public boolean equals(Object o) {
            if (o instanceof XMLNodeList) {
                XMLNodeList r = (XMLNodeList)o;
                if (this.nodeList.getLength() == r.nodeList.getLength()) {
                    int i = 0;
                    while (i < this.nodeList.getLength()) {
                        Node n2;
                        Node n1 = this.nodeList.item(i);
                        if (n1 != (n2 = r.nodeList.item(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        protected String getText(Object node) {
            return DOMUtil.getTextValue((Node)node);
        }

        @Override
        public String getStringValue() {
            StringBuffer buffer = new StringBuffer();
            int length = this.nodeList.getLength();
            int i = 0;
            while (i < length) {
                buffer.append(DOMUtil.getTextValue(this.nodeList.item(i)));
                if (i + 1 < length) {
                    buffer.append(' ');
                }
                ++i;
            }
            return buffer.toString();
        }

        @Override
        public Iterator getNodeIterator() {
            return new Iterator(){
                private int current;
                private int len;
                {
                    this.len = XMLNodeList.this.nodeList.getLength();
                }

                @Override
                public boolean hasNext() {
                    return this.current < this.len;
                }

                public Object next() {
                    if (this.current < this.len) {
                        return XMLNodeList.this.nodeList.item(this.current++);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] getNodes() {
            Object[] result = new Object[this.nodeList.getLength()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.nodeList.item(i);
                ++i;
            }
            return result;
        }

        @Override
        public String[] getValues() {
            String[] result = new String[this.nodeList.getLength()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.getText(this.nodeList.item(i));
                ++i;
            }
            return result;
        }
    }
}

