/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.drivers;

import com.ibm.commons.xml.Format;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XPathContext;
import com.ibm.commons.xml.drivers.AbstractDriver;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public abstract class AbstractJAXPDriver
extends AbstractDriver {
    private DOMImplementation domImplementation;
    private DOMImplementationLS domImplementationLS;
    private static final String USERDATA_KEY = "com.ibm.xml.context";

    public AbstractJAXPDriver() {
        try {
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            this.domImplementation = reg.getDOMImplementation("XML 3.0");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (this.domImplementation == null) {
            throw new RuntimeException("Error while initializing the JAXP driver");
        }
        if (!(this.domImplementation instanceof DOMImplementationLS)) {
            throw new RuntimeException("DOMImplementation does not implement Load/Save");
        }
        this.domImplementationLS = (DOMImplementationLS)((Object)this.domImplementation);
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.domImplementation;
    }

    @Override
    protected DocumentBuilderFactory createDocumentBuilderFactory(boolean resolveEntities, boolean validate) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setExpandEntityReferences(resolveEntities);
        dbFactory.setValidating(validate);
        return dbFactory;
    }

    private UserData getUserData(Document doc) {
        UserData data = (UserData)doc.getUserData(USERDATA_KEY);
        if (data == null) {
            data = new UserData();
            doc.setUserData(USERDATA_KEY, data, null);
        }
        return data;
    }

    @Override
    public XPathContext getXPathContext(Document doc) {
        UserData data = this.getUserData(doc);
        return data.xpContext;
    }

    @Override
    public void pushXPathContext(Document doc, String xpath) throws XMLException {
        UserData data = this.getUserData(doc);
        data.xpContext = new XPathContext(doc, data.xpContext, xpath);
    }

    @Override
    public void popXPathContext(Document doc) throws XMLException {
        UserData data = this.getUserData(doc);
        data.xpContext = data.xpContext.getParent();
    }

    @Override
    public NamespaceContext getNamespaceContext(Document doc) {
        UserData data = this.getUserData(doc);
        return data.nsContext;
    }

    @Override
    public void setNamespaceContext(Document doc, NamespaceContext ns) {
        UserData data = this.getUserData(doc);
        data.nsContext = ns;
    }

    @Override
    public void serialize(OutputStream os, Node node, Format format) throws XMLException {
        try {
            LSSerializer ser = this.createLSSerializer(format);
            LSOutput out = this.domImplementationLS.createLSOutput();
            out.setByteStream(os);
            ser.write(node, out);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while converting XML document to string");
        }
    }

    @Override
    public void serialize(Writer w, Node node, Format format) throws XMLException {
        try {
            LSSerializer ser = this.createLSSerializer(format);
            LSOutput out = this.domImplementationLS.createLSOutput();
            out.setCharacterStream(w);
            ser.write(node, out);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while converting XML document to string");
        }
    }

    private LSSerializer createLSSerializer(Format format) {
        LSSerializer ser = this.domImplementationLS.createLSSerializer();
        DOMConfiguration c = ser.getDomConfig();
        c.setParameter("format-pretty-print", format.indent != 0);
        c.setParameter("xml-declaration", !format.xmlDecl);
        return ser;
    }

    private static class UserData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient NamespaceContext nsContext;
        private transient XPathContext xpContext;

        private UserData() {
        }
    }
}

