/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.drivers;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.Format;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XPathContext;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.XResultUtils;
import com.ibm.commons.xml.drivers.AbstractDriver;
import com.ibm.commons.xml.xpath.NodeListImpl;
import com.ibm.commons.xml.xpath.XPathException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXercesDriver
extends AbstractDriver {
    private DOMImplementation domImplementation = DOMImplementationImpl.getDOMImplementation();

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.domImplementation;
    }

    @Override
    protected DocumentBuilderFactory createDocumentBuilderFactory(boolean resolveEntities, boolean validate) {
        DocumentBuilderFactoryImpl dbFactory = new DocumentBuilderFactoryImpl();
        dbFactory.setNamespaceAware(true);
        dbFactory.setExpandEntityReferences(resolveEntities);
        dbFactory.setValidating(validate);
        return dbFactory;
    }

    private UserData getUserData(Document doc) {
        NodeImpl impl = (NodeImpl)doc;
        UserData data = (UserData)impl.getUserData();
        if (data == null) {
            data = new UserData();
            impl.setUserData((Object)data);
        }
        return data;
    }

    @Override
    public XPathContext getXPathContext(Document doc) {
        UserData data = this.getUserData(doc);
        return data.xpContext;
    }

    @Override
    public void pushXPathContext(Document doc, String xpath) throws XMLException {
        UserData data = this.getUserData(doc);
        data.xpContext = new XPathContext(doc, data.xpContext, xpath);
    }

    @Override
    public void popXPathContext(Document doc) throws XMLException {
        UserData data = this.getUserData(doc);
        data.xpContext = data.xpContext.getParent();
    }

    @Override
    public NamespaceContext getNamespaceContext(Document doc) {
        UserData data = this.getUserData(doc);
        return data.nsContext;
    }

    @Override
    public void setNamespaceContext(Document doc, NamespaceContext ns) {
        UserData data = this.getUserData(doc);
        data.nsContext = ns;
    }

    @Override
    public void serialize(OutputStream os, Node node, Format format) throws XMLException {
        try {
            XMLSerializer ser = this.createXMLSerializer(node, format);
            ser.setOutputByteStream(os);
            this.serialize(ser, node);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while converting XML document to string");
        }
    }

    @Override
    public void serialize(Writer w, Node node, Format format) throws XMLException {
        try {
            XMLSerializer ser = this.createXMLSerializer(node, format);
            ser.setOutputCharStream(w);
            this.serialize(ser, node);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while converting XML document to string");
        }
    }

    private XMLSerializer createXMLSerializer(Node node, Format fmt) {
        if (fmt == null) {
            fmt = Format.defaultFormat;
        }
        OutputFormat format = new OutputFormat();
        format.setIndent(fmt.indent);
        format.setOmitXMLDeclaration(!fmt.xmlDecl);
        format.setEncoding(fmt.encoding);
        return new XMLSerializer(format);
    }

    private void serialize(XMLSerializer ser, Node node) throws IOException {
        if (node instanceof Document) {
            ser.serialize((Document)node);
        } else if (node instanceof Element) {
            ser.serialize((Element)node);
        } else if (node instanceof DocumentFragment) {
            ser.serialize((DocumentFragment)node);
        }
    }

    @Override
    public Object createXPath(String xpath) throws XPathException {
        return xpath;
    }

    @Override
    public XResult evaluateXPath(Node node, Object xpath, NamespaceContext nsContext) throws XPathException {
        try {
            NSResolver pr = nsContext != null ? new NSResolver(nsContext) : null;
            XObject res = XPathAPI.eval((Node)node, (String)((String)xpath), (PrefixResolver)pr);
            return AbstractXercesDriver.convertResult(res);
        }
        catch (Exception e) {
            throw new XPathException(e, "Error while evaluating XPath {0}", xpath.toString());
        }
    }

    @Override
    public XResult evaluateXPath(NodeList nodeList, Object xpath, NamespaceContext nsContext) throws XPathException {
        try {
            if (nodeList.getLength() > 0) {
                XResultUtils.ValueResult result = null;
                NodeListImpl nodes = null;
                NSResolver pr = nsContext != null ? new NSResolver(nsContext) : null;
                int i = 0;
                while (i < nodeList.getLength()) {
                    XObject res = XPathAPI.eval((Node)nodeList.item(i), (String)((String)xpath), (PrefixResolver)pr);
                    switch (res.getType()) {
                        case 1: {
                            if (nodes != null) {
                                throw new XPathException(null, "XPath result cannot contain both values and nodes");
                            }
                            if (result != null) {
                                throw new XPathException(null, "XPath exception cannot return multiple values");
                            }
                            result = new XResultUtils.BooleanValue(res.bool());
                            break;
                        }
                        case 2: {
                            if (nodes != null) {
                                throw new XPathException(null, "XPath result cannot contain both values and nodes");
                            }
                            if (result != null) {
                                throw new XPathException(null, "XPath exception cannot return multiple values");
                            }
                            result = new XResultUtils.NumberValue(res.num());
                            break;
                        }
                        case 3: {
                            if (nodes != null) {
                                throw new XPathException(null, "XPath result cannot contain both values and nodes");
                            }
                            if (result != null) {
                                throw new XPathException(null, "XPath exception cannot return multiple values");
                            }
                            result = new XResultUtils.StringValue(res.str());
                            break;
                        }
                        case 4: {
                            if (result != null) {
                                throw new XPathException(null, "XPath result cannot contain both values and nodes");
                            }
                            NodeList nl = res.nodelist();
                            int len = nl.getLength();
                            if (len <= 0) break;
                            if (nodes == null) {
                                nodes = new NodeListImpl();
                            }
                            int j = 0;
                            while (j < nl.getLength()) {
                                nodes.add(nl.item(j));
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
                if (result != null) {
                    return result;
                }
                if (nodes != null) {
                    int len = nodes.getLength();
                    if (len == 0) {
                        return XResultUtils.emptyResult;
                    }
                    if (len == 1) {
                        return new XResultUtils.XMLNode(nodes.item(0));
                    }
                    return new XResultUtils.XMLNodeList(nodes);
                }
            }
            return XResultUtils.emptyResult;
        }
        catch (Exception e) {
            throw new XPathException(e, "Error evaluating XPath {0}", xpath.toString());
        }
    }

    private static XResult convertResult(XObject object) throws TransformerException {
        switch (object.getType()) {
            case 1: {
                return new XResultUtils.BooleanValue(object.bool());
            }
            case 2: {
                return new XResultUtils.NumberValue(object.num());
            }
            case 3: {
                return new XResultUtils.StringValue(object.str());
            }
            case 4: {
                NodeList nl = object.nodelist();
                int len = nl.getLength();
                if (len == 0) {
                    return XResultUtils.emptyResult;
                }
                if (len == 1) {
                    return new XResultUtils.XMLNode(nl.item(0));
                }
                return new XResultUtils.XMLNodeList(nl);
            }
        }
        return XResultUtils.emptyResult;
    }

    private static class NSResolver
    implements PrefixResolver {
        NamespaceContext nsContext;

        NSResolver(NamespaceContext nsContext) {
            this.nsContext = nsContext;
        }

        public String getNamespaceForPrefix(String prefix) {
            return this.nsContext.getNamespaceURI(prefix);
        }

        public String getNamespaceForPrefix(String prefix, Node context) {
            return this.nsContext.getNamespaceURI(prefix);
        }

        public boolean handlesNullPrefixes() {
            String nsUri = this.nsContext.getNamespaceURI("");
            return !StringUtil.isEmpty((String)nsUri);
        }

        public String getBaseIdentifier() {
            return "";
        }
    }

    private static class UserData {
        private NamespaceContext nsContext;
        private XPathContext xpContext;

        private UserData() {
        }
    }
}

