/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.drivers;

import com.ibm.commons.util.ObjectPool;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.drivers.AbstractXercesDriver;
import java.io.InputStream;
import java.io.Reader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;

public class XercesDriverL3
extends AbstractXercesDriver {
    private DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)this.getDOMImplementation());
    private ParserPool parserPool = new ParserPool(this.domImplementationLS);
    private static BlankFilter BLANK_FILTER = new BlankFilter();

    private LSParser getParser() throws Exception {
        LSParser parser = (LSParser)this.parserPool.get();
        return parser;
    }

    private void recycleParser(LSParser parser) {
        parser.setFilter(null);
        this.parserPool.recycle(parser);
    }

    public Document parse(InputStream is, boolean ignoreBlanks) throws XMLException {
        LSParser parser = this.getParser();
        try {
            Document doc;
            if (ignoreBlanks) {
                parser.setFilter(BLANK_FILTER);
            }
            LSInput ip = this.domImplementationLS.createLSInput();
            ip.setByteStream(is);
            Document document = doc = parser.parse(ip);
            this.recycleParser(parser);
            return document;
        }
        catch (Throwable throwable) {
            try {
                this.recycleParser(parser);
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLException(e, "Error parsing XML input stream");
            }
        }
    }

    public Document parse(Reader reader, boolean ignoreBlanks) throws XMLException {
        LSParser parser = this.getParser();
        try {
            Document doc;
            if (ignoreBlanks) {
                parser.setFilter(BLANK_FILTER);
            }
            LSInput ip = this.domImplementationLS.createLSInput();
            ip.setCharacterStream(reader);
            Document document = doc = parser.parse(ip);
            this.recycleParser(parser);
            return document;
        }
        catch (Throwable throwable) {
            try {
                this.recycleParser(parser);
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLException(e, "Error parsing XML character stream");
            }
        }
    }

    public Document parse(InputStream is, boolean ignoreBlanks, boolean validate) throws XMLException {
        return this.parse(is, ignoreBlanks);
    }

    public Document parse(Reader reader, boolean ignoreBlanks, boolean validate) throws XMLException {
        return this.parse(reader, ignoreBlanks);
    }

    private static class BlankFilter
    implements LSParserFilter {
        private BlankFilter() {
        }

        @Override
        public short acceptNode(Node node) {
            if (node instanceof Text) {
                Text t = (Text)node;
                String data = t.getData();
                int length = data.length();
                int first = 0;
                while (first < length) {
                    char c = data.charAt(first);
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                        return 1;
                    }
                    ++first;
                }
                return 3;
            }
            return 1;
        }

        @Override
        public int getWhatToShow() {
            return 4;
        }

        @Override
        public short startElement(Element elt) {
            return 1;
        }
    }

    private static class ParserPool
    extends ObjectPool {
        private DOMImplementationLS domImplementationLS;

        ParserPool(DOMImplementationLS domImplementationLS) {
            super(8);
            this.domImplementationLS = domImplementationLS;
        }

        protected Object createObject() throws Exception {
            LSParser parser = this.domImplementationLS.createLSParser((short)1, null);
            return parser;
        }
    }
}

